/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.solar;

import com.tyme.AbstractTyme;
import com.tyme.culture.Week;
import com.tyme.solar.SolarDay;
import com.tyme.solar.SolarMonth;
import java.util.ArrayList;
import java.util.List;

public class SolarWeek
extends AbstractTyme {
    public static final String[] NAMES = new String[]{"\u7b2c\u4e00\u5468", "\u7b2c\u4e8c\u5468", "\u7b2c\u4e09\u5468", "\u7b2c\u56db\u5468", "\u7b2c\u4e94\u5468", "\u7b2c\u516d\u5468"};
    protected SolarMonth month;
    protected int index;
    protected Week start;

    protected SolarWeek(int year, int month, int index, int start) {
        if (index < 0 || index > 5) {
            throw new IllegalArgumentException(String.format("illegal solar week index: %d", index));
        }
        if (start < 0 || start > 6) {
            throw new IllegalArgumentException(String.format("illegal solar week start: %d", start));
        }
        SolarMonth m = SolarMonth.fromYm(year, month);
        if (index >= m.getWeekCount(start)) {
            throw new IllegalArgumentException(String.format("illegal solar week index: %d in month: %s", index, m));
        }
        this.month = m;
        this.index = index;
        this.start = Week.fromIndex(start);
    }

    public static SolarWeek fromYm(int year, int month, int index, int start) {
        return new SolarWeek(year, month, index, start);
    }

    public SolarMonth getMonth() {
        return this.month;
    }

    public int getIndex() {
        return this.index;
    }

    public Week getStart() {
        return this.start;
    }

    @Override
    public String getName() {
        return NAMES[this.index];
    }

    @Override
    public String toString() {
        return this.month + this.getName();
    }

    @Override
    public SolarWeek next(int n) {
        int add;
        if (n == 0) {
            return SolarWeek.fromYm(this.month.getYear().getYear(), this.month.getMonth(), this.index, this.start.getIndex());
        }
        int d = this.index + n;
        SolarMonth m = this.month;
        int startIndex = this.start.getIndex();
        int weeksInMonth = m.getWeekCount(startIndex);
        boolean forward = n > 0;
        int n2 = add = forward ? 1 : -1;
        while (forward ? d >= weeksInMonth : d < 0) {
            if (forward) {
                d -= weeksInMonth;
            }
            if (!forward && !SolarDay.fromYmd(m.getYear().getYear(), m.getMonth(), 1).getWeek().equals(this.start)) {
                d += add;
            }
            m = m.next(add);
            if (forward && !SolarDay.fromYmd(m.getYear().getYear(), m.getMonth(), 1).getWeek().equals(this.start)) {
                d += add;
            }
            weeksInMonth = m.getWeekCount(startIndex);
            if (forward) continue;
            d += weeksInMonth;
        }
        return SolarWeek.fromYm(m.getYear().getYear(), m.getMonth(), d, startIndex);
    }

    public SolarDay getFirstDay() {
        SolarMonth m = this.getMonth();
        SolarDay firstDay = SolarDay.fromYmd(m.getYear().getYear(), m.getMonth(), 1);
        return firstDay.next(this.index * 7 - this.indexOf(firstDay.getWeek().getIndex() - this.start.getIndex(), 7));
    }

    public List<SolarDay> getDays() {
        ArrayList<SolarDay> l = new ArrayList<SolarDay>(7);
        SolarDay d = this.getFirstDay();
        l.add(d);
        for (int i = 1; i < 7; ++i) {
            l.add(d.next(i));
        }
        return l;
    }
}

