/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.solar;

import com.tyme.AbstractTyme;
import com.tyme.jd.JulianDay;
import com.tyme.lunar.LunarDay;
import com.tyme.lunar.LunarHour;
import com.tyme.lunar.LunarMonth;
import com.tyme.solar.SolarDay;
import com.tyme.solar.SolarMonth;
import com.tyme.solar.SolarTerm;

public class SolarTime
extends AbstractTyme {
    protected SolarDay day;
    protected int hour;
    protected int minute;
    protected int second;

    protected SolarTime(int year, int month, int day, int hour, int minute, int second) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException(String.format("illegal hour: %d", hour));
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException(String.format("illegal minute: %d", minute));
        }
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException(String.format("illegal second: %d", second));
        }
        this.day = SolarDay.fromYmd(year, month, day);
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    public static SolarTime fromYmdHms(int year, int month, int day, int hour, int minute, int second) {
        return new SolarTime(year, month, day, hour, minute, second);
    }

    public SolarDay getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    @Override
    public String getName() {
        return String.format("%02d:%02d:%02d", this.hour, this.minute, this.second);
    }

    @Override
    public String toString() {
        return String.format("%s %s", this.day, this.getName());
    }

    public boolean isBefore(SolarTime target) {
        if (!this.day.equals(target.getDay())) {
            return this.day.isBefore(target.getDay());
        }
        int bHour = target.getHour();
        if (this.hour == bHour) {
            int bMinute = target.getMinute();
            return this.minute == bMinute ? this.second < target.getSecond() : this.minute < bMinute;
        }
        return this.hour < bHour;
    }

    public boolean isAfter(SolarTime target) {
        if (!this.day.equals(target.getDay())) {
            return this.day.isAfter(target.getDay());
        }
        int bHour = target.getHour();
        if (this.hour == bHour) {
            int bMinute = target.getMinute();
            return this.minute == bMinute ? this.second > target.getSecond() : this.minute > bMinute;
        }
        return this.hour > bHour;
    }

    public SolarTerm getTerm() {
        SolarTerm term = SolarTerm.fromIndex(this.day.getMonth().getYear().getYear() + 1, 0);
        while (this.isBefore(term.getJulianDay().getSolarTime())) {
            term = term.next(-1);
        }
        return term;
    }

    public JulianDay getJulianDay() {
        SolarMonth month = this.day.getMonth();
        return JulianDay.fromYmdHms(month.getYear().getYear(), month.getMonth(), this.day.getDay(), this.hour, this.minute, this.second);
    }

    public int subtract(SolarTime target) {
        int days = this.day.subtract(target.getDay());
        int cs = this.hour * 3600 + this.minute * 60 + this.second;
        int ts = target.getHour() * 3600 + target.getMinute() * 60 + target.getSecond();
        int seconds = cs - ts;
        if (seconds < 0) {
            seconds += 86400;
            --days;
        }
        return seconds += days * 86400;
    }

    @Override
    public SolarTime next(int n) {
        int ts = this.second + n;
        int tm = this.minute + ts / 60;
        int th = this.hour + tm / 60;
        SolarDay d = this.day.next(th / 24);
        SolarMonth month = d.getMonth();
        return SolarTime.fromYmdHms(month.getYear().getYear(), month.getMonth(), d.getDay(), th % 24, tm % 60, ts % 60);
    }

    public LunarHour getLunarHour() {
        LunarDay d = this.day.getLunarDay();
        LunarMonth m = d.getMonth();
        return LunarHour.fromYmdHms(m.getYear().getYear(), m.getMonthWithLeap(), d.getDay(), this.hour, this.minute, this.second);
    }
}

