/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.solar;

import com.tyme.LoopTyme;
import com.tyme.jd.JulianDay;
import com.tyme.util.ShouXingUtil;

public class SolarTerm
extends LoopTyme {
    public static final String[] NAMES = new String[]{"\u51ac\u81f3", "\u5c0f\u5bd2", "\u5927\u5bd2", "\u7acb\u6625", "\u96e8\u6c34", "\u60ca\u86f0", "\u6625\u5206", "\u6e05\u660e", "\u8c37\u96e8", "\u7acb\u590f", "\u5c0f\u6ee1", "\u8292\u79cd", "\u590f\u81f3", "\u5c0f\u6691", "\u5927\u6691", "\u7acb\u79cb", "\u5904\u6691", "\u767d\u9732", "\u79cb\u5206", "\u5bd2\u9732", "\u971c\u964d", "\u7acb\u51ac", "\u5c0f\u96ea", "\u5927\u96ea"};
    protected double cursoryJulianDay;

    protected SolarTerm(int year, int index) {
        super(NAMES, index);
        this.initByYear(year, index);
    }

    protected SolarTerm(int year, String name) {
        super(NAMES, name);
        this.initByYear(year, this.index);
    }

    protected SolarTerm(double cursoryJulianDay, int index) {
        super(NAMES, index);
        this.cursoryJulianDay = cursoryJulianDay;
    }

    protected void initByYear(int year, int offset) {
        double jd = Math.floor((double)(year - 2000) * 365.2422 + 180.0);
        double w = Math.floor((jd - 355.0 + 183.0) / 365.2422) * 365.2422 + 355.0;
        if (ShouXingUtil.calcQi(w) > jd) {
            w -= 365.2422;
        }
        this.cursoryJulianDay = ShouXingUtil.calcQi(w + 15.2184 * (double)offset);
    }

    public static SolarTerm fromIndex(int year, int index) {
        return new SolarTerm(year, index);
    }

    public static SolarTerm fromName(int year, String name) {
        return new SolarTerm(year, name);
    }

    @Override
    public SolarTerm next(int n) {
        return new SolarTerm(this.cursoryJulianDay + 15.2184 * (double)n, this.nextIndex(n));
    }

    public boolean isJie() {
        return this.index % 2 == 1;
    }

    public boolean isQi() {
        return this.index % 2 == 0;
    }

    public JulianDay getJulianDay() {
        return JulianDay.fromJulianDay(ShouXingUtil.qiAccurate2(this.cursoryJulianDay) + 2451545.0);
    }

    public double getCursoryJulianDay() {
        return this.cursoryJulianDay;
    }
}

