/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.solar;

import com.tyme.AbstractTyme;
import com.tyme.solar.SolarMonth;
import com.tyme.solar.SolarYear;
import java.util.ArrayList;
import java.util.List;

public class SolarSeason
extends AbstractTyme {
    public static final String[] NAMES = new String[]{"\u4e00\u5b63\u5ea6", "\u4e8c\u5b63\u5ea6", "\u4e09\u5b63\u5ea6", "\u56db\u5b63\u5ea6"};
    protected SolarYear year;
    protected int index;

    protected SolarSeason(int year, int index) {
        this.year = SolarYear.fromYear(year);
        if (index < 0 || index > 3) {
            throw new IllegalArgumentException(String.format("illegal solar season index: %d", index));
        }
        this.index = index;
    }

    public static SolarSeason fromIndex(int year, int index) {
        return new SolarSeason(year, index);
    }

    public SolarYear getYear() {
        return this.year;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return NAMES[this.index];
    }

    @Override
    public String toString() {
        return this.year + this.getName();
    }

    @Override
    public SolarSeason next(int n) {
        int m = this.index + n;
        return SolarSeason.fromIndex(this.year.getYear() + m / 4, Math.abs(m % 4));
    }

    public List<SolarMonth> getMonths() {
        ArrayList<SolarMonth> l = new ArrayList<SolarMonth>(3);
        int y = this.year.getYear();
        for (int i = 0; i < 3; ++i) {
            l.add(SolarMonth.fromYm(y, this.index * 3 + i + 1));
        }
        return l;
    }
}

