/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.solar;

import com.tyme.AbstractTyme;
import com.tyme.solar.SolarDay;
import com.tyme.solar.SolarSeason;
import com.tyme.solar.SolarWeek;
import com.tyme.solar.SolarYear;
import java.util.ArrayList;
import java.util.List;

public class SolarMonth
extends AbstractTyme {
    public static final String[] NAMES = new String[]{"1\u6708", "2\u6708", "3\u6708", "4\u6708", "5\u6708", "6\u6708", "7\u6708", "8\u6708", "9\u6708", "10\u6708", "11\u6708", "12\u6708"};
    public static final int[] DAYS = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    protected SolarYear year;
    protected int month;

    protected SolarMonth(int year, int month) {
        this.year = SolarYear.fromYear(year);
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException(String.format("illegal solar month: %d", month));
        }
        this.month = month;
    }

    public static SolarMonth fromYm(int year, int month) {
        return new SolarMonth(year, month);
    }

    public SolarYear getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDayCount() {
        if (1582 == this.year.getYear() && 10 == this.month) {
            return 21;
        }
        int d = DAYS[this.getIndexInYear()];
        if (2 == this.month && this.year.isLeap()) {
            ++d;
        }
        return d;
    }

    public int getIndexInYear() {
        return this.month - 1;
    }

    public SolarSeason getSeason() {
        return SolarSeason.fromIndex(this.year.getYear(), this.getIndexInYear() / 3);
    }

    public int getWeekCount(int start) {
        return (int)Math.ceil((double)(this.indexOf(SolarDay.fromYmd(this.year.getYear(), this.month, 1).getWeek().getIndex() - start, 7) + this.getDayCount()) / 7.0);
    }

    @Override
    public String getName() {
        return NAMES[this.getIndexInYear()];
    }

    @Override
    public String toString() {
        return this.year + this.getName();
    }

    @Override
    public SolarMonth next(int n) {
        if (n == 0) {
            return SolarMonth.fromYm(this.year.getYear(), this.month);
        }
        int m = this.month + n;
        int y = this.year.getYear() + m / 12;
        if ((m %= 12) < 1) {
            m += 12;
            --y;
        }
        return SolarMonth.fromYm(y, m);
    }

    public List<SolarWeek> getWeeks(int start) {
        int size = this.getWeekCount(start);
        int y = this.year.getYear();
        ArrayList<SolarWeek> l = new ArrayList<SolarWeek>(size);
        for (int i = 0; i < size; ++i) {
            l.add(SolarWeek.fromYm(y, this.month, i, start));
        }
        return l;
    }

    public List<SolarDay> getDays() {
        int size = this.getDayCount();
        int y = this.year.getYear();
        ArrayList<SolarDay> l = new ArrayList<SolarDay>(size);
        for (int i = 0; i < size; ++i) {
            l.add(SolarDay.fromYmd(y, this.month, i + 1));
        }
        return l;
    }
}

