/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.lunar;

import com.tyme.AbstractTyme;
import com.tyme.culture.Direction;
import com.tyme.culture.Duty;
import com.tyme.culture.Phase;
import com.tyme.culture.Week;
import com.tyme.culture.fetus.FetusDay;
import com.tyme.culture.star.nine.NineStar;
import com.tyme.culture.star.twelve.TwelveStar;
import com.tyme.culture.star.twentyeight.TwentyEightStar;
import com.tyme.festival.LunarFestival;
import com.tyme.lunar.LunarMonth;
import com.tyme.lunar.LunarYear;
import com.tyme.sixtycycle.EarthBranch;
import com.tyme.sixtycycle.HeavenStem;
import com.tyme.sixtycycle.SixtyCycle;
import com.tyme.solar.SolarDay;
import com.tyme.solar.SolarTerm;

public class LunarDay
extends AbstractTyme {
    public static final String[] NAMES = new String[]{"\u521d\u4e00", "\u521d\u4e8c", "\u521d\u4e09", "\u521d\u56db", "\u521d\u4e94", "\u521d\u516d", "\u521d\u4e03", "\u521d\u516b", "\u521d\u4e5d", "\u521d\u5341", "\u5341\u4e00", "\u5341\u4e8c", "\u5341\u4e09", "\u5341\u56db", "\u5341\u4e94", "\u5341\u516d", "\u5341\u4e03", "\u5341\u516b", "\u5341\u4e5d", "\u4e8c\u5341", "\u5eff\u4e00", "\u5eff\u4e8c", "\u5eff\u4e09", "\u5eff\u56db", "\u5eff\u4e94", "\u5eff\u516d", "\u5eff\u4e03", "\u5eff\u516b", "\u5eff\u4e5d", "\u4e09\u5341"};
    protected LunarMonth month;
    protected int day;

    protected LunarDay(int year, int month, int day) {
        LunarMonth m = LunarMonth.fromYm(year, month);
        if (day < 1 || day > m.getDayCount()) {
            throw new IllegalArgumentException(String.format("illegal day %d in %s", day, m));
        }
        this.month = m;
        this.day = day;
    }

    public static LunarDay fromYmd(int year, int month, int day) {
        return new LunarDay(year, month, day);
    }

    public LunarMonth getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    @Override
    public String getName() {
        return NAMES[this.day - 1];
    }

    @Override
    public String toString() {
        return this.month + this.getName();
    }

    @Override
    public LunarDay next(int n) {
        int add;
        if (n == 0) {
            return LunarDay.fromYmd(this.month.getYear().getYear(), this.month.getMonthWithLeap(), this.day);
        }
        int d = this.day + n;
        LunarMonth lm = this.month;
        int daysInMonth = lm.getDayCount();
        boolean forward = n > 0;
        int n2 = add = forward ? 1 : -1;
        while (forward ? d > daysInMonth : d <= 0) {
            if (forward) {
                d -= daysInMonth;
            }
            lm = lm.next(add);
            daysInMonth = lm.getDayCount();
            if (forward) continue;
            d += daysInMonth;
        }
        return LunarDay.fromYmd(lm.getYear().getYear(), lm.getMonthWithLeap(), d);
    }

    public boolean isBefore(LunarDay target) {
        LunarMonth targetMonth;
        int bYear;
        int aYear = this.month.getYear().getYear();
        if (aYear == (bYear = (targetMonth = target.getMonth()).getYear().getYear())) {
            int bMonth;
            int aMonth = this.month.getMonth();
            if (aMonth == (bMonth = targetMonth.getMonth())) {
                if (this.month.isLeap() && !targetMonth.isLeap()) {
                    return false;
                }
                return this.day < target.getDay();
            }
            return aMonth < bMonth;
        }
        return aYear < bYear;
    }

    public boolean isAfter(LunarDay target) {
        LunarMonth targetMonth;
        int bYear;
        int aYear = this.month.getYear().getYear();
        if (aYear == (bYear = (targetMonth = target.getMonth()).getYear().getYear())) {
            int bMonth;
            int aMonth = this.month.getMonth();
            if (aMonth == (bMonth = targetMonth.getMonth())) {
                if (this.month.isLeap() && !targetMonth.isLeap()) {
                    return true;
                }
                return this.day > target.getDay();
            }
            return aMonth > bMonth;
        }
        return aYear > bYear;
    }

    public Week getWeek() {
        return this.getSolarDay().getJulianDay().getWeek();
    }

    public SixtyCycle getYearSixtyCycle() {
        SolarDay solarDay = this.getSolarDay();
        int solarYear = solarDay.getMonth().getYear().getYear();
        SolarDay springSolarDay = SolarTerm.fromIndex(solarYear, 3).getJulianDay().getSolarDay();
        LunarYear lunarYear = this.month.getYear();
        int year = lunarYear.getYear();
        SixtyCycle sixtyCycle = lunarYear.getSixtyCycle();
        if (year == solarYear) {
            if (solarDay.isBefore(springSolarDay)) {
                sixtyCycle = sixtyCycle.next(-1);
            }
        } else if (year < solarYear && !solarDay.isBefore(springSolarDay)) {
            sixtyCycle = sixtyCycle.next(1);
        }
        return sixtyCycle;
    }

    public SixtyCycle getMonthSixtyCycle() {
        SolarDay solarDay = this.getSolarDay();
        int year = solarDay.getMonth().getYear().getYear();
        SolarTerm term = solarDay.getTerm();
        int index = term.getIndex() - 3;
        if (index < 0 && term.getJulianDay().getSolarDay().isAfter(SolarTerm.fromIndex(year, 3).getJulianDay().getSolarDay())) {
            index += 24;
        }
        return LunarMonth.fromYm(year, 1).getSixtyCycle().next((int)Math.floor((double)index * 1.0 / 2.0));
    }

    public SixtyCycle getSixtyCycle() {
        int offset = (int)this.month.getFirstJulianDay().next(this.day - 12).getDay();
        return SixtyCycle.fromName(HeavenStem.fromIndex(offset).getName() + EarthBranch.fromIndex(offset).getName());
    }

    public Duty getDuty() {
        return Duty.fromIndex(this.getSixtyCycle().getEarthBranch().getIndex() - this.getMonthSixtyCycle().getEarthBranch().getIndex());
    }

    public TwelveStar getTwelveStar() {
        return TwelveStar.fromIndex(this.getSixtyCycle().getEarthBranch().getIndex() + (8 - this.getMonthSixtyCycle().getEarthBranch().getIndex() % 6) * 2);
    }

    public NineStar getNineStar() {
        SolarDay solar = this.getSolarDay();
        SolarTerm dongZhi = SolarTerm.fromIndex(solar.getMonth().getYear().getYear(), 0);
        SolarTerm xiaZhi = dongZhi.next(12);
        SolarTerm dongZhi2 = dongZhi.next(24);
        SolarDay dongZhiSolar = dongZhi.getJulianDay().getSolarDay();
        SolarDay xiaZhiSolar = xiaZhi.getJulianDay().getSolarDay();
        SolarDay dongZhiSolar2 = dongZhi2.getJulianDay().getSolarDay();
        int dongZhiIndex = dongZhiSolar.getLunarDay().getSixtyCycle().getIndex();
        int xiaZhiIndex = xiaZhiSolar.getLunarDay().getSixtyCycle().getIndex();
        int dongZhiIndex2 = dongZhiSolar2.getLunarDay().getSixtyCycle().getIndex();
        SolarDay solarShunBai = dongZhiSolar.next(dongZhiIndex > 29 ? 60 - dongZhiIndex : -dongZhiIndex);
        SolarDay solarShunBai2 = dongZhiSolar2.next(dongZhiIndex2 > 29 ? 60 - dongZhiIndex2 : -dongZhiIndex2);
        SolarDay solarNiZi = xiaZhiSolar.next(xiaZhiIndex > 29 ? 60 - xiaZhiIndex : -xiaZhiIndex);
        int offset = 0;
        if (!solar.isBefore(solarShunBai) && solar.isBefore(solarNiZi)) {
            offset = solar.subtract(solarShunBai);
        } else if (!solar.isBefore(solarNiZi) && solar.isBefore(solarShunBai2)) {
            offset = 8 - solar.subtract(solarNiZi);
        } else if (!solar.isBefore(solarShunBai2)) {
            offset = solar.subtract(solarShunBai2);
        } else if (solar.isBefore(solarShunBai)) {
            offset = 8 + solarShunBai.subtract(solar);
        }
        return NineStar.fromIndex(offset);
    }

    public Direction getJupiterDirection() {
        int index = this.getSixtyCycle().getIndex();
        if (index % 12 < 6) {
            return Direction.fromIndex((new int[]{2, 8, 4, 6, 0})[index / 12]);
        }
        return this.month.getYear().getJupiterDirection();
    }

    public FetusDay getFetusDay() {
        return FetusDay.fromLunarDay(this);
    }

    public Phase getPhase() {
        return Phase.fromIndex(this.day - 1);
    }

    public SolarDay getSolarDay() {
        return this.month.getFirstJulianDay().next(this.day - 1).getSolarDay();
    }

    public TwentyEightStar getTwentyEightStar() {
        return TwentyEightStar.fromIndex((new int[]{10, 18, 26, 6, 14, 22, 2})[this.getSolarDay().getWeek().getIndex()]).next(-7 * this.getSixtyCycle().getEarthBranch().getIndex());
    }

    public LunarFestival getFestival() {
        LunarMonth m = this.getMonth();
        return LunarFestival.fromYmd(m.getYear().getYear(), m.getMonthWithLeap(), this.day);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LunarDay)) {
            return false;
        }
        LunarDay target = (LunarDay)o;
        return this.month.equals(target.getMonth()) && this.day == target.getDay();
    }
}

