/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.jd;

import com.tyme.AbstractTyme;
import com.tyme.culture.Week;
import com.tyme.solar.SolarDay;
import com.tyme.solar.SolarTime;

public class JulianDay
extends AbstractTyme {
    public static final double J2000 = 2451545.0;
    protected double day;

    protected JulianDay(double day) {
        this.day = day;
    }

    public static JulianDay fromJulianDay(double day) {
        return new JulianDay(day);
    }

    public static JulianDay fromYmdHms(int year, int month, int day, int hour, int minute, int second) {
        boolean g;
        double d = (double)day + (((double)second * 1.0 / 60.0 + (double)minute) / 60.0 + (double)hour) / 24.0;
        int n = 0;
        boolean bl = g = year * 372 + month * 31 + (int)d >= 588829;
        if (month <= 2) {
            month += 12;
            --year;
        }
        if (g) {
            n = (int)((double)year * 1.0 / 100.0);
            n = 2 - n + (int)((double)n * 1.0 / 4.0);
        }
        return JulianDay.fromJulianDay((double)((int)(365.25 * (double)(year + 4716)) + (int)(30.6001 * (double)(month + 1))) + d + (double)n - 1524.5);
    }

    public double getDay() {
        return this.day;
    }

    @Override
    public String getName() {
        return this.day + "";
    }

    @Override
    public JulianDay next(int n) {
        return JulianDay.fromJulianDay(this.day + (double)n);
    }

    public SolarDay getSolarDay() {
        int d = (int)(this.day + 0.5);
        double f = this.day + 0.5 - (double)d;
        if (d >= 2299161) {
            int c = (int)(((double)d - 1867216.25) / 36524.25);
            d += 1 + c - (int)((double)c * 1.0 / 4.0);
        }
        int year = (int)(((double)(d += 1524) - 122.1) / 365.25);
        int month = (int)((double)(d -= (int)(365.25 * (double)year)) * 1.0 / 30.601);
        int day = d -= (int)(30.601 * (double)month);
        if (month > 13) {
            month -= 13;
            year -= 4715;
        } else {
            --month;
            year -= 4716;
        }
        int hour = (int)(f *= 24.0);
        f -= (double)hour;
        int minute = (int)(f *= 60.0);
        f -= (double)minute;
        int second = (int)Math.round(f *= 60.0);
        if (second > 59) {
            ++minute;
        }
        if (minute > 59) {
            ++hour;
        }
        if (hour > 23) {
            ++day;
        }
        return SolarDay.fromYmd(year, month, day);
    }

    public SolarTime getSolarTime() {
        int d = (int)(this.day + 0.5);
        double f = this.day + 0.5 - (double)d;
        if (d >= 2299161) {
            int c = (int)(((double)d - 1867216.25) / 36524.25);
            d += 1 + c - (int)((double)c * 1.0 / 4.0);
        }
        int year = (int)(((double)(d += 1524) - 122.1) / 365.25);
        int month = (int)((double)(d -= (int)(365.25 * (double)year)) * 1.0 / 30.601);
        int day = d -= (int)(30.601 * (double)month);
        if (month > 13) {
            month -= 13;
            year -= 4715;
        } else {
            --month;
            year -= 4716;
        }
        int hour = (int)(f *= 24.0);
        f -= (double)hour;
        int minute = (int)(f *= 60.0);
        f -= (double)minute;
        int second = (int)Math.round(f *= 60.0);
        if (second > 59) {
            second -= 60;
            ++minute;
        }
        if (minute > 59) {
            minute -= 60;
            ++hour;
        }
        if (hour > 23) {
            hour -= 24;
            ++day;
        }
        return SolarTime.fromYmdHms(year, month, day, hour, minute, second);
    }

    public Week getWeek() {
        return Week.fromIndex((int)(this.day + 0.5) + 7000001);
    }
}

