/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.enums;

public enum Side {
    IN(0, "\u5185"),
    OUT(1, "\u5916");

    private final int code;
    private final String name;

    private Side(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static Side fromCode(Integer code) {
        if (null == code) {
            return null;
        }
        for (Side item : Side.values()) {
            if (item.getCode() != code.intValue()) continue;
            return item;
        }
        return null;
    }

    public static Side fromName(String name) {
        if (null == name) {
            return null;
        }
        for (Side item : Side.values()) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }
}

