/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.eightchar.provider.impl;

import com.tyme.eightchar.ChildLimitInfo;
import com.tyme.eightchar.provider.ChildLimitProvider;
import com.tyme.solar.SolarDay;
import com.tyme.solar.SolarMonth;
import com.tyme.solar.SolarTerm;
import com.tyme.solar.SolarTime;

public class DefaultChildLimitProvider
implements ChildLimitProvider {
    @Override
    public ChildLimitInfo getInfo(SolarTime birthTime, SolarTerm term) {
        int seconds = Math.abs(term.getJulianDay().getSolarTime().subtract(birthTime));
        int year = seconds / 259200;
        int month = (seconds %= 259200) / 21600;
        int day = (seconds %= 21600) / 720;
        int hour = (seconds %= 720) / 30;
        int minute = (seconds %= 30) * 2;
        SolarDay birthday = birthTime.getDay();
        SolarMonth birthMonth = birthday.getMonth();
        int d = birthday.getDay() + day;
        int h = birthTime.getHour() + hour;
        int mi = birthTime.getMinute() + minute;
        h += mi / 60;
        mi %= 60;
        d += h / 24;
        h %= 24;
        SolarMonth sm = SolarMonth.fromYm(birthMonth.getYear().getYear() + year, birthMonth.getMonth()).next(month);
        int dc = sm.getDayCount();
        if (d > dc) {
            d -= dc;
            sm = sm.next(1);
        }
        return new ChildLimitInfo(birthTime, SolarTime.fromYmdHms(sm.getYear().getYear(), sm.getMonth(), d, h, mi, birthTime.getSecond()), year, month, day, hour, minute);
    }
}

