/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.eightchar.provider.impl;

import com.tyme.eightchar.ChildLimitInfo;
import com.tyme.eightchar.provider.ChildLimitProvider;
import com.tyme.solar.SolarDay;
import com.tyme.solar.SolarMonth;
import com.tyme.solar.SolarTerm;
import com.tyme.solar.SolarTime;

public class China95ChildLimitProvider
implements ChildLimitProvider {
    @Override
    public ChildLimitInfo getInfo(SolarTime birthTime, SolarTerm term) {
        int dc;
        int minutes = Math.abs(term.getJulianDay().getSolarTime().subtract(birthTime)) / 60;
        int year = minutes / 4320;
        int month = (minutes %= 4320) / 360;
        int day = (minutes %= 360) / 12;
        SolarDay birthday = birthTime.getDay();
        SolarMonth birthMonth = birthday.getMonth();
        SolarMonth sm = SolarMonth.fromYm(birthMonth.getYear().getYear() + year, birthMonth.getMonth()).next(month);
        int d = birthday.getDay() + day;
        if (d > (dc = sm.getDayCount())) {
            d -= dc;
            sm = sm.next(1);
        }
        return new ChildLimitInfo(birthTime, SolarTime.fromYmdHms(sm.getYear().getYear(), sm.getMonth(), d, birthTime.getHour(), birthTime.getMinute(), birthTime.getSecond()), year, month, day, 0, 0);
    }
}

