/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.eightchar;

import com.tyme.AbstractTyme;
import com.tyme.eightchar.ChildLimit;
import com.tyme.lunar.LunarYear;
import com.tyme.sixtycycle.SixtyCycle;

public class Fortune
extends AbstractTyme {
    protected ChildLimit childLimit;
    protected int index;

    protected Fortune(ChildLimit childLimit, int index) {
        this.childLimit = childLimit;
        this.index = index;
    }

    public static Fortune fromChildLimit(ChildLimit childLimit, int index) {
        return new Fortune(childLimit, index);
    }

    public int getAge() {
        return this.childLimit.getYearCount() + 1 + this.index;
    }

    public LunarYear getLunarYear() {
        return this.childLimit.getEndTime().getLunarHour().getDay().getMonth().getYear().next(this.index);
    }

    public SixtyCycle getSixtyCycle() {
        int n = this.getAge();
        return this.childLimit.getEightChar().getHour().next(this.childLimit.isForward() ? n : -n);
    }

    @Override
    public String getName() {
        return this.getSixtyCycle().getName();
    }

    @Override
    public Fortune next(int n) {
        return Fortune.fromChildLimit(this.childLimit, this.index + n);
    }
}

