/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.eightchar;

import com.tyme.AbstractTyme;
import com.tyme.eightchar.ChildLimit;
import com.tyme.eightchar.Fortune;
import com.tyme.lunar.LunarYear;
import com.tyme.sixtycycle.SixtyCycle;

public class DecadeFortune
extends AbstractTyme {
    protected ChildLimit childLimit;
    protected int index;

    protected DecadeFortune(ChildLimit childLimit, int index) {
        this.childLimit = childLimit;
        this.index = index;
    }

    public static DecadeFortune fromChildLimit(ChildLimit childLimit, int index) {
        return new DecadeFortune(childLimit, index);
    }

    public int getStartAge() {
        return this.childLimit.getYearCount() + 1 + this.index * 10;
    }

    public int getEndAge() {
        return this.getStartAge() + 9;
    }

    public LunarYear getStartLunarYear() {
        return this.childLimit.getEndTime().getLunarHour().getDay().getMonth().getYear().next(this.index * 10);
    }

    public LunarYear getEndLunarYear() {
        return this.getStartLunarYear().next(9);
    }

    public SixtyCycle getSixtyCycle() {
        int n = this.index + 1;
        return this.childLimit.getEightChar().getMonth().next(this.childLimit.isForward() ? n : -n);
    }

    @Override
    public String getName() {
        return this.getSixtyCycle().getName();
    }

    @Override
    public DecadeFortune next(int n) {
        return DecadeFortune.fromChildLimit(this.childLimit, this.index + n);
    }

    public Fortune getStartFortune() {
        return Fortune.fromChildLimit(this.childLimit, this.index * 10);
    }
}

