/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.model.impl;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.core.IRequest;
import com.nlf.dao.exception.DaoException;
import com.nlf.dao.paging.PageData;
import com.nlf.dao.transaction.ITransaction;
import com.nlf.extend.dao.sql.ISqlDao;
import com.nlf.extend.dao.sql.ISqlSelecter;
import com.nlf.extend.dao.sql.SqlConnection;
import com.nlf.extend.dao.sql.SqlDaoFactory;
import com.nlf.extend.model.IModelSelecter;
import com.nlf.extend.model.Model;
import com.nlf.extend.model.ModelIterator;
import com.nlf.extend.model.paging.ModelPage;
import com.nlf.util.IOUtil;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelSelecter<M extends Model>
implements IModelSelecter<M> {
    protected Model model;
    private ISqlSelecter selecter;

    public DefaultModelSelecter(Model model) {
        this.model = model;
        String alias = model.alias();
        ISqlDao dao = null == alias ? SqlDaoFactory.getDao() : SqlDaoFactory.getDao((String)alias);
        this.selecter = dao.getSelecter().table(model.tableName());
    }

    @Override
    public IModelSelecter<M> column(String columns) {
        this.selecter.column(columns);
        return this;
    }

    @Override
    public IModelSelecter<M> columnIf(String columns, boolean condition) {
        this.selecter.columnIf(columns, condition);
        return this;
    }

    @Override
    public IModelSelecter<M> where(String sql) {
        this.selecter.where(sql);
        return this;
    }

    @Override
    public IModelSelecter<M> where(String columnOrSql, Object valueOrBean) {
        this.selecter.where(columnOrSql, valueOrBean);
        return this;
    }

    @Override
    public IModelSelecter<M> whereIf(String sql, boolean condition) {
        this.selecter.whereIf(sql, condition);
        return this;
    }

    @Override
    public IModelSelecter<M> whereIf(String columnOrSql, Object valueOrBean, boolean condition) {
        this.selecter.whereIf(columnOrSql, valueOrBean, condition);
        return this;
    }

    @Override
    public IModelSelecter<M> whereIn(String column, Object ... values) {
        this.selecter.whereIn(column, values);
        return this;
    }

    @Override
    public IModelSelecter<M> whereNotIn(String column, Object ... values) {
        this.selecter.whereNotIn(column, values);
        return this;
    }

    @Override
    public IModelSelecter<M> whereNotEqual(String column, Object value) {
        this.selecter.whereNotEqual(column, value);
        return this;
    }

    @Override
    public IModelSelecter<M> groupBy(String columns) {
        this.selecter.groupBy(columns);
        return this;
    }

    @Override
    public IModelSelecter<M> groupByIf(String columns, boolean condition) {
        this.selecter.groupByIf(columns, condition);
        return this;
    }

    @Override
    public IModelSelecter<M> having(String sql) {
        this.selecter.having(sql);
        return this;
    }

    @Override
    public IModelSelecter<M> having(String columnOrSql, Object valueOrBean) {
        this.selecter.having(columnOrSql, valueOrBean);
        return this;
    }

    @Override
    public IModelSelecter<M> havingIf(String sql, boolean condition) {
        this.selecter.havingIf(sql, condition);
        return this;
    }

    @Override
    public IModelSelecter<M> havingIf(String columnOrSql, Object valueOrBean, boolean condition) {
        this.selecter.havingIf(columnOrSql, valueOrBean, condition);
        return this;
    }

    @Override
    public IModelSelecter<M> asc(String columns) {
        this.selecter.asc(columns);
        return this;
    }

    @Override
    public IModelSelecter<M> ascIf(String columns, boolean condition) {
        this.selecter.ascIf(columns, condition);
        return this;
    }

    @Override
    public IModelSelecter<M> desc(String columns) {
        this.selecter.desc(columns);
        return this;
    }

    @Override
    public IModelSelecter<M> descIf(String columns, boolean condition) {
        this.selecter.descIf(columns, condition);
        return this;
    }

    @Override
    public List<M> top(int count) {
        return null;
    }

    @Override
    public M topOne() {
        List<M> l = this.top(1);
        if (l.size() < 1) {
            throw new DaoException(App.getProperty((String)"nlf.exception.dao.select.one.not_found", (Object[])new Object[0]));
        }
        return (M)((Object)((Model)((Object)l.get(0))));
    }

    @Override
    public M one() {
        List<M> l = this.query();
        if (l.size() < 1) {
            throw new DaoException(App.getProperty((String)"nlf.exception.dao.select.one.not_found", (Object[])new Object[0]));
        }
        return (M)((Object)((Model)((Object)l.get(0))));
    }

    @Override
    public int count() {
        return this.selecter.count();
    }

    @Override
    public ModelPage<M> page(int pageNumber, int pageSize) {
        PageData pd = this.selecter.page(pageNumber, pageSize);
        ArrayList<Model> l = new ArrayList<Model>(pd.getSize());
        for (Bean o : pd) {
            for (String key : o.keySet()) {
                o.set(this.model.decode(key), o.get(key));
            }
            try {
                l.add((Model)((Object)o.toObject(((Object)((Object)this.model)).getClass())));
            }
            catch (Exception e) {
                throw new DaoException((Throwable)e);
            }
        }
        return new ModelPage(l, pd.getPageSize(), pd.getPageNumber(), pd.getRecordCount());
    }

    @Override
    public ModelPage<M> paging() {
        IRequest r = App.getRequest();
        return this.page(r.getPageNumber(), r.getPageSize());
    }

    protected void bindParams(PreparedStatement stmt) throws SQLException {
        int j = this.selecter.getParams().size();
        for (int i = 1; i <= j; ++i) {
            Object p = this.selecter.getParams().get(i - 1);
            if (p instanceof Timestamp) {
                stmt.setTimestamp(i, (Timestamp)p);
                continue;
            }
            if (p instanceof Date) {
                stmt.setDate(i, (Date)p);
                continue;
            }
            if (p instanceof java.util.Date) {
                java.util.Date dd = (java.util.Date)p;
                stmt.setDate(i, new Date(dd.getTime()));
                continue;
            }
            stmt.setObject(i, p);
        }
    }

    @Override
    public Iterator<M> iterator() {
        String alias = this.model.alias();
        ISqlDao dao = null == alias ? SqlDaoFactory.getDao() : SqlDaoFactory.getDao((String)alias);
        ITransaction t = dao.beginTransaction();
        SqlConnection connection = (SqlConnection)t.getConnection();
        ModelIterator iterator = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.getConnection().prepareStatement(this.selecter.getSql());
            this.bindParams(stmt);
            rs = stmt.executeQuery();
            iterator = new ModelIterator(((Object)((Object)this.model)).getClass(), this.model, rs);
        }
        catch (SQLException e) {
            IOUtil.closeQuietly(stmt);
            throw new DaoException((Throwable)e);
        }
        return iterator;
    }

    @Override
    public List<M> query() {
        List l = this.selecter.query();
        ArrayList<Model> ret = new ArrayList<Model>(l.size());
        for (Bean o : l) {
            for (String key : o.keySet()) {
                o.set(this.model.decode(key), o.get(key));
            }
            try {
                Model m = (Model)((Object)o.toObject(((Object)((Object)this.model)).getClass()));
                ret.add(m);
            }
            catch (Exception exception) {}
        }
        return ret;
    }
}

