/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.model;

import com.nlf.Bean;
import com.nlf.core.AbstractBean;
import com.nlf.extend.dao.sql.ISqlDao;
import com.nlf.extend.dao.sql.ISqlDeleter;
import com.nlf.extend.dao.sql.ISqlSelecter;
import com.nlf.extend.dao.sql.ISqlUpdater;
import com.nlf.extend.dao.sql.SqlDaoFactory;
import com.nlf.extend.model.IModelSelecter;
import com.nlf.extend.model.impl.DefaultModelSelecter;
import com.nlf.serialize.json.JSON;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model<M extends Model>
extends AbstractBean {
    public static final String DEFAULT_PRIMARY_KEY = "id";
    private static final Pattern PATTERN_UPPER = Pattern.compile("[A-Z]");
    private static final Pattern PATTERN_LINE = Pattern.compile("_(\\w)");
    protected String alias;
    protected String tableName;
    protected Set<String> primaryKeys = new LinkedHashSet<String>();
    protected String autoIncrement;
    protected Bean cache;

    protected Model(String tableName) {
        this(tableName, new String[0], null);
    }

    protected Model(String tableName, String primaryKey) {
        this(tableName, primaryKey, null);
    }

    protected Model(String tableName, String primaryKey, String autoIncrement) {
        this(tableName, new String[]{primaryKey}, autoIncrement);
    }

    protected Model(String tableName, String[] primaryKeys, String autoIncrement) {
        this(null, tableName, primaryKeys, autoIncrement);
    }

    protected Model(String alias, String tableName, String[] primaryKeys, String autoIncrement) {
        this.alias = alias;
        this.tableName = tableName;
        if (null != primaryKeys) {
            for (String key : primaryKeys) {
                this.primaryKeys.add(this.encode(key));
            }
        }
        if (this.primaryKeys.isEmpty()) {
            this.primaryKeys.add(DEFAULT_PRIMARY_KEY);
        }
        this.autoIncrement = this.encode(autoIncrement);
    }

    public String encode(String property) {
        if (null == property) {
            return null;
        }
        Matcher matcher = PATTERN_UPPER.matcher(property);
        StringBuffer s = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(s, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(s);
        return s.toString();
    }

    public String decode(String field) {
        if (null == field) {
            return null;
        }
        field = field.toLowerCase();
        Matcher matcher = PATTERN_LINE.matcher(field);
        StringBuffer s = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(s, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(s);
        return s.toString();
    }

    public String alias() {
        return this.alias;
    }

    public String tableName() {
        return this.tableName;
    }

    public Set<String> primaryKeys() {
        return this.primaryKeys;
    }

    public String autoIncrement() {
        return this.autoIncrement;
    }

    public void delete() {
        Bean param = (Bean)JSON.toBean((String)JSON.fromObject((Object)((Object)this)));
        ISqlDao dao = null == this.alias ? SqlDaoFactory.getDao() : SqlDaoFactory.getDao((String)this.alias);
        ISqlDeleter deleter = dao.getDeleter().table(this.tableName);
        for (String key : this.primaryKeys) {
            deleter.where(key, param.get(this.decode(key)));
        }
        deleter.delete();
    }

    public void save() {
        ISqlDao iSqlDao;
        Bean record = (Bean)JSON.toBean((String)JSON.fromObject((Object)((Object)this)));
        if (record.isEmpty()) {
            return;
        }
        HashSet<String> needEncode = new HashSet<String>();
        for (String string : record.keySet()) {
            if (this.encode(string).equals(string)) continue;
            needEncode.add(string);
        }
        for (String string : needEncode) {
            record.set(this.encode(string), record.get(string));
            record.remove(string);
        }
        int type = 0;
        if (null != this.cache) {
            type = 2;
        } else {
            for (String key : this.primaryKeys) {
                if (record.getString(key, "").length() >= 1) continue;
                type = 1;
                break;
            }
        }
        ISqlDao iSqlDao2 = iSqlDao = null == this.alias ? SqlDaoFactory.getDao() : SqlDaoFactory.getDao((String)this.alias);
        if (0 == type) {
            ISqlSelecter selecter = iSqlDao.getSelecter().table(this.tableName);
            for (String key : this.primaryKeys) {
                selecter.where(key, record.get(key));
            }
            type = selecter.count() > 0 ? 3 : 1;
        }
        block1 : switch (type) {
            case 1: {
                if (null == this.autoIncrement || record.getString(this.autoIncrement, "").length() > 0) {
                    iSqlDao.getInserter().table(this.tableName).set(record).insert();
                    break;
                }
                record.remove(this.autoIncrement);
                Bean ret = iSqlDao.getInserter().table(this.tableName).set(record).insertAndGetGenerated();
                if (ret.isEmpty()) break;
                try {
                    PropertyDescriptor[] props;
                    Object property = this.decode(this.autoIncrement);
                    BeanInfo info = Introspector.getBeanInfo(((Object)((Object)this)).getClass(), Object.class);
                    for (PropertyDescriptor p : props = info.getPropertyDescriptors()) {
                        Method setter;
                        if (!p.getName().equals(property) || null == (setter = p.getWriteMethod())) continue;
                        Object value = this.convert(ret.get("GENERATED_KEY"), p.getPropertyType(), setter.getGenericParameterTypes()[0]);
                        setter.invoke((Object)this, value);
                        break block1;
                    }
                    break;
                }
                catch (Exception property) {
                    break;
                }
            }
            case 2: {
                Bean temp = new Bean();
                for (Object property : this.cache.keySet()) {
                    temp.set((String)property, this.cache.get((String)property));
                }
                for (Object property : this.cache.keySet()) {
                    String value;
                    String field = this.encode((String)property);
                    String cacheValue = this.cache.getString((String)property, "");
                    if (cacheValue.equals(value = record.getString(field, ""))) {
                        record.remove(field);
                        continue;
                    }
                    temp.set((String)property, record.get(field));
                }
                if (record.isEmpty()) break;
                ISqlUpdater updater = iSqlDao.getUpdater().table(this.tableName);
                for (String key : this.primaryKeys) {
                    updater.where(key, this.cache.get(this.decode(key)));
                }
                updater.set(record).update();
                this.cache = temp;
                break;
            }
            case 3: {
                Bean temp = new Bean();
                for (String field : record.keySet()) {
                    temp.set(this.decode(field), record.get(field));
                }
                ISqlUpdater updater = iSqlDao.getUpdater().table(this.tableName);
                for (String key : this.primaryKeys) {
                    updater.where(key, record.get(key));
                    record.remove(key);
                }
                updater.set(record).update();
                this.cache = temp;
                break;
            }
        }
    }

    public void load() {
        Bean param = (Bean)JSON.toBean((String)JSON.fromObject((Object)((Object)this)));
        ISqlDao dao = null == this.alias ? SqlDaoFactory.getDao() : SqlDaoFactory.getDao((String)this.alias);
        ISqlSelecter selecter = dao.getSelecter().table(this.tableName);
        for (String key : this.primaryKeys) {
            selecter.where(key, param.get(this.decode(key)));
        }
        Bean ret = selecter.one();
        try {
            PropertyDescriptor[] props;
            BeanInfo info = Introspector.getBeanInfo(((Object)((Object)this)).getClass(), Object.class);
            for (PropertyDescriptor p : props = info.getPropertyDescriptors()) {
                Method setter = p.getWriteMethod();
                if (null == setter) continue;
                Object value = this.convert(ret.get(this.encode(p.getName())), p.getPropertyType(), setter.getGenericParameterTypes()[0]);
                setter.invoke((Object)this, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cache = (Bean)JSON.toBean((String)JSON.fromObject((Object)((Object)this)));
    }

    public IModelSelecter<M> selecter() {
        return new DefaultModelSelecter(this);
    }
}

