/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.log.commons.logging;

import com.nlf.App;
import com.nlf.log.AbstractLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggingLog
extends AbstractLog {
    public static final String KLASS = LoggingLog.class.getName();
    private Log logger;

    public LoggingLog(String name) {
        super(name);
        this.logger = LogFactory.getLog((String)name);
    }

    private String wrap(String msg) {
        StackTraceElement[] sts;
        int index = 0;
        for (StackTraceElement st : sts = Thread.currentThread().getStackTrace()) {
            if (KLASS.equals(st.getClassName())) {
                index += 2;
                break;
            }
            ++index;
        }
        StackTraceElement st = sts[index];
        String prefix = App.getProperty((String)"nlf.log.commons.logging.message.prefix", (Object[])new Object[]{st});
        return prefix + msg;
    }

    public void debug(String msg) {
        this.logger.debug((Object)this.wrap(msg));
    }

    public void debug(String msg, Throwable e) {
        this.logger.debug((Object)this.wrap(msg), e);
    }

    public void info(String msg) {
        this.logger.info((Object)this.wrap(msg));
    }

    public void info(String msg, Throwable e) {
        this.logger.info((Object)this.wrap(msg), e);
    }

    public void warn(String msg) {
        this.logger.warn((Object)this.wrap(msg));
    }

    public void warn(String msg, Throwable e) {
        this.logger.warn((Object)this.wrap(msg), e);
    }

    public void error(String msg) {
        this.logger.error((Object)this.wrap(msg));
    }

    public void error(String msg, Throwable e) {
        this.logger.error((Object)this.wrap(msg), e);
    }

    public void trace(String msg) {
        this.logger.trace((Object)this.wrap(msg));
    }

    public void trace(String msg, Throwable e) {
        this.logger.trace((Object)this.wrap(msg), e);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }
}

