/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.Solar;
import com.nlf.calendar.SolarMonth;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolarSeason {
    private final int year;
    private final int month;
    public static final int MONTH_COUNT = 3;

    public SolarSeason() {
        this(new Date());
    }

    public SolarSeason(Date date) {
        Solar solar = Solar.fromDate(date);
        this.year = solar.getYear();
        this.month = solar.getMonth();
    }

    @Deprecated
    public SolarSeason(Calendar calendar) {
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
    }

    public SolarSeason(int year, int month) {
        this.year = year;
        this.month = month;
    }

    public static SolarSeason fromDate(Date date) {
        return new SolarSeason(date);
    }

    @Deprecated
    public static SolarSeason fromCalendar(Calendar calendar) {
        return new SolarSeason(calendar);
    }

    public static SolarSeason fromYm(int year, int month) {
        return new SolarSeason(year, month);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getIndex() {
        return (int)Math.ceil((double)this.month * 1.0 / 3.0);
    }

    public SolarSeason next(int seasons) {
        SolarMonth m = SolarMonth.fromYm(this.year, this.month).next(3 * seasons);
        return new SolarSeason(m.getYear(), m.getMonth());
    }

    public List<SolarMonth> getMonths() {
        ArrayList<SolarMonth> l = new ArrayList<SolarMonth>();
        int index = this.getIndex() - 1;
        for (int i = 0; i < 3; ++i) {
            l.add(new SolarMonth(this.year, 3 * index + i + 1));
        }
        return l;
    }

    public String toString() {
        return this.year + "." + this.getIndex();
    }

    public String toFullString() {
        return this.year + "\u5e74" + this.getIndex() + "\u5b63\u5ea6";
    }
}

