/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.Lunar;
import com.nlf.calendar.LunarMonth;
import com.nlf.calendar.NineStar;
import com.nlf.calendar.Solar;
import com.nlf.calendar.util.LunarUtil;
import com.nlf.calendar.util.ShouXingUtil;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LunarYear {
    private static final String[] YUAN = new String[]{"\u4e0b", "\u4e0a", "\u4e2d"};
    private static final String[] YUN = new String[]{"\u4e03", "\u516b", "\u4e5d", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"};
    private static final int[] LEAP_11 = new int[]{75, 94, 170, 265, 322, 398, 469, 553, 583, 610, 678, 735, 754, 773, 849, 887, 936, 1050, 1069, 1126, 1145, 1164, 1183, 1259, 1278, 1308, 1373, 1403, 1441, 1460, 1498, 1555, 1593, 1612, 1631, 1642, 2033, 2128, 2147, 2242, 2614, 2728, 2910, 3062, 3244, 3339, 3616, 3711, 3730, 3825, 4007, 4159, 4197, 4322, 4341, 4379, 4417, 4531, 4599, 4694, 4713, 4789, 4808, 4971, 5085, 5104, 5161, 5180, 5199, 5294, 5305, 5476, 5677, 5696, 5772, 5791, 5848, 5886, 6049, 6068, 6144, 6163, 6258, 6402, 6440, 6497, 6516, 6630, 6641, 6660, 6679, 6736, 6774, 6850, 6869, 6899, 6918, 6994, 7013, 7032, 7051, 7070, 7089, 7108, 7127, 7146, 7222, 7271, 7290, 7309, 7366, 7385, 7404, 7442, 7461, 7480, 7491, 7499, 7594, 7624, 7643, 7662, 7681, 7719, 7738, 7814, 7863, 7882, 7901, 7939, 7958, 7977, 7996, 8034, 8053, 8072, 8091, 8121, 8159, 8186, 8216, 8235, 8254, 8273, 8311, 8330, 8341, 8349, 8368, 8444, 8463, 8474, 8493, 8531, 8569, 8588, 8626, 8664, 8683, 8694, 8702, 8713, 8721, 8751, 8789, 8808, 8816, 8827, 8846, 8884, 8903, 8922, 8941, 8971, 9036, 9066, 9085, 9104, 9123, 9142, 9161, 9180, 9199, 9218, 9256, 9294, 9313, 9324, 9343, 9362, 9381, 9419, 9438, 9476, 9514, 9533, 9544, 9552, 9563, 9571, 9582, 9601, 9639, 9658, 9666, 9677, 9696, 9734, 9753, 9772, 9791, 9802, 9821, 9886, 9897, 9916, 9935, 9954, 9973, 9992};
    private static final int[] LEAP_12 = new int[]{37, 56, 113, 132, 151, 189, 208, 227, 246, 284, 303, 341, 360, 379, 417, 436, 458, 477, 496, 515, 534, 572, 591, 629, 648, 667, 697, 716, 792, 811, 830, 868, 906, 925, 944, 963, 982, 1001, 1020, 1039, 1058, 1088, 1153, 1202, 1221, 1240, 1297, 1335, 1392, 1411, 1422, 1430, 1517, 1525, 1536, 1574, 3358, 3472, 3806, 3988, 4751, 4941, 5066, 5123, 5275, 5343, 5438, 5457, 5495, 5533, 5552, 5715, 5810, 5829, 5905, 5924, 6421, 6535, 6793, 6812, 6888, 6907, 7002, 7184, 7260, 7279, 7374, 7556, 7746, 7757, 7776, 7833, 7852, 7871, 7966, 8015, 8110, 8129, 8148, 8224, 8243, 8338, 8406, 8425, 8482, 8501, 8520, 8558, 8596, 8607, 8615, 8645, 8740, 8778, 8835, 8865, 8930, 8960, 8979, 8998, 9017, 9055, 9074, 9093, 9112, 9150, 9188, 9237, 9275, 9332, 9351, 9370, 9408, 9427, 9446, 9457, 9465, 9495, 9560, 9590, 9628, 9647, 9685, 9715, 9742, 9780, 9810, 9818, 9829, 9848, 9867, 9905, 9924, 9943, 9962, 10000};
    private static final int[] YMC = new int[]{11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    private static LunarYear CACHE_YEAR = null;
    private final int year;
    private final int ganIndex;
    private final int zhiIndex;
    private final List<LunarMonth> months = new ArrayList<LunarMonth>();
    private final List<Double> jieQiJulianDays = new ArrayList<Double>();

    public LunarYear(int lunarYear) {
        this.year = lunarYear;
        int offset = lunarYear - 4;
        int yearGanIndex = offset % 10;
        int yearZhiIndex = offset % 12;
        if (yearGanIndex < 0) {
            yearGanIndex += 10;
        }
        if (yearZhiIndex < 0) {
            yearZhiIndex += 12;
        }
        this.ganIndex = yearGanIndex;
        this.zhiIndex = yearZhiIndex;
        this.compute();
    }

    private static boolean contains(int[] arr, int n) {
        for (int o : arr) {
            if (n != o) continue;
            return true;
        }
        return false;
    }

    public static synchronized LunarYear fromYear(int lunarYear) {
        LunarYear y;
        if (null == CACHE_YEAR || CACHE_YEAR.getYear() != lunarYear) {
            CACHE_YEAR = y = new LunarYear(lunarYear);
        } else {
            y = CACHE_YEAR;
        }
        return y;
    }

    private void compute() {
        int i;
        int i2;
        double[] jq = new double[27];
        double[] hs = new double[16];
        int[] dayCounts = new int[15];
        int[] months = new int[15];
        int currentYear = this.year;
        double jd = Math.floor((double)(currentYear - 2000) * 365.2422 + 180.0);
        double w = Math.floor((jd - 355.0 + 183.0) / 365.2422) * 365.2422 + 355.0;
        if (ShouXingUtil.calcQi(w) > jd) {
            w -= 365.2422;
        }
        for (i2 = 0; i2 < 26; ++i2) {
            jq[i2] = ShouXingUtil.calcQi(w + 15.2184 * (double)i2);
        }
        int j = Lunar.JIE_QI_IN_USE.length;
        for (i2 = 0; i2 < j; ++i2) {
            jd = i2 == 0 ? ShouXingUtil.qiAccurate2(jq[0] - 15.2184) : (i2 <= 26 ? ShouXingUtil.qiAccurate2(jq[i2 - 1]) : ShouXingUtil.qiAccurate2(jq[25] + 15.2184 * (double)(i2 - 26)));
            this.jieQiJulianDays.add(jd + 2451545.0);
        }
        w = ShouXingUtil.calcShuo(jq[0]);
        if (w > jq[0]) {
            w -= 29.53;
        }
        for (i2 = 0; i2 < 16; ++i2) {
            hs[i2] = ShouXingUtil.calcShuo(w + 29.5306 * (double)i2);
        }
        for (i2 = 0; i2 < 15; ++i2) {
            dayCounts[i2] = (int)(hs[i2 + 1] - hs[i2]);
            months[i2] = i2;
        }
        int prevYear = currentYear - 1;
        int leapIndex = 16;
        if (LunarYear.contains(LEAP_11, currentYear)) {
            leapIndex = 13;
        } else if (LunarYear.contains(LEAP_12, currentYear)) {
            leapIndex = 14;
        } else if (hs[13] <= jq[24]) {
            for (i = 1; hs[i + 1] > jq[2 * i] && i < 13; ++i) {
            }
            leapIndex = i;
        }
        i = leapIndex;
        while (i < 15) {
            int n = i++;
            months[n] = months[n] - 1;
        }
        int fm = -1;
        int index = -1;
        int y = prevYear;
        for (int i3 = 0; i3 < 15; ++i3) {
            double dm = hs[i3] + 2451545.0;
            int v2 = months[i3];
            int mc = YMC[v2 % 12];
            if (1724360.0 <= dm && dm < 1729794.0) {
                mc = YMC[(v2 + 1) % 12];
            } else if (1807724.0 <= dm && dm < 1808699.0) {
                mc = YMC[(v2 + 1) % 12];
            } else if (dm == 1729794.0 || dm == 1808699.0) {
                mc = 12;
            }
            if (fm == -1) {
                fm = mc;
                index = mc;
            }
            if (mc < fm) {
                ++y;
                index = 1;
            }
            fm = mc;
            if (i3 == leapIndex) {
                mc = -mc;
            } else if (dm == 1729794.0 || dm == 1808699.0) {
                mc = -11;
            }
            this.months.add(new LunarMonth(y, mc, dayCounts[i3], hs[i3] + 2451545.0, index));
            ++index;
        }
    }

    public int getYear() {
        return this.year;
    }

    public int getDayCount() {
        int n = 0;
        for (LunarMonth m : this.months) {
            if (m.getYear() != this.year) continue;
            n += m.getDayCount();
        }
        return n;
    }

    public List<LunarMonth> getMonthsInYear() {
        ArrayList<LunarMonth> l = new ArrayList<LunarMonth>();
        for (LunarMonth m : this.months) {
            if (m.getYear() != this.year) continue;
            l.add(m);
        }
        return l;
    }

    public List<LunarMonth> getMonths() {
        return this.months;
    }

    public List<Double> getJieQiJulianDays() {
        return this.jieQiJulianDays;
    }

    public int getGanIndex() {
        return this.ganIndex;
    }

    public int getZhiIndex() {
        return this.zhiIndex;
    }

    public String getGan() {
        return LunarUtil.GAN[this.ganIndex + 1];
    }

    public String getZhi() {
        return LunarUtil.ZHI[this.zhiIndex + 1];
    }

    public String getGanZhi() {
        return this.getGan() + this.getZhi();
    }

    public LunarMonth getMonth(int lunarMonth) {
        for (LunarMonth m : this.months) {
            if (m.getYear() != this.year || m.getMonth() != lunarMonth) continue;
            return m;
        }
        return null;
    }

    public int getLeapMonth() {
        for (LunarMonth m : this.months) {
            if (m.getYear() != this.year || !m.isLeap()) continue;
            return Math.abs(m.getMonth());
        }
        return 0;
    }

    protected String getZaoByGan(int index, String name) {
        int offset = index - Solar.fromJulianDay(this.getMonth(1).getFirstJulianDay()).getLunar().getDayGanIndex();
        if (offset < 0) {
            offset += 10;
        }
        return name.replaceFirst("\u51e0", LunarUtil.NUMBER[offset + 1]);
    }

    protected String getZaoByZhi(int index, String name) {
        int offset = index - Solar.fromJulianDay(this.getMonth(1).getFirstJulianDay()).getLunar().getDayZhiIndex();
        if (offset < 0) {
            offset += 12;
        }
        return name.replaceFirst("\u51e0", LunarUtil.NUMBER[offset + 1]);
    }

    public String getTouLiang() {
        return this.getZaoByZhi(0, "\u51e0\u9f20\u5077\u7cae");
    }

    public String getCaoZi() {
        return this.getZaoByZhi(0, "\u8349\u5b50\u51e0\u5206");
    }

    public String getGengTian() {
        return this.getZaoByZhi(1, "\u51e0\u725b\u8015\u7530");
    }

    public String getHuaShou() {
        return this.getZaoByZhi(3, "\u82b1\u6536\u51e0\u5206");
    }

    public String getZhiShui() {
        return this.getZaoByZhi(4, "\u51e0\u9f99\u6cbb\u6c34");
    }

    public String getTuoGu() {
        return this.getZaoByZhi(6, "\u51e0\u9a6c\u9a6e\u8c37");
    }

    public String getQiangMi() {
        return this.getZaoByZhi(9, "\u51e0\u9e21\u62a2\u7c73");
    }

    public String getKanCan() {
        return this.getZaoByZhi(9, "\u51e0\u59d1\u770b\u8695");
    }

    public String getGongZhu() {
        return this.getZaoByZhi(11, "\u51e0\u5c60\u5171\u732a");
    }

    public String getJiaTian() {
        return this.getZaoByGan(0, "\u7532\u7530\u51e0\u5206");
    }

    public String getFenBing() {
        return this.getZaoByGan(2, "\u51e0\u4eba\u5206\u997c");
    }

    public String getDeJin() {
        return this.getZaoByGan(7, "\u51e0\u65e5\u5f97\u91d1");
    }

    public String getRenBing() {
        return this.getZaoByGan(2, this.getZaoByZhi(2, "\u51e0\u4eba\u51e0\u4e19"));
    }

    public String getRenChu() {
        return this.getZaoByGan(3, this.getZaoByZhi(2, "\u51e0\u4eba\u51e0\u9504"));
    }

    public String getYuan() {
        return YUAN[(this.year + 2696) / 60 % 3] + "\u5143";
    }

    public String getYun() {
        return YUN[(this.year + 2696) / 20 % 9] + "\u8fd0";
    }

    public NineStar getNineStar() {
        int yuan = (this.year + 2696) / 60 % 3;
        int index = LunarUtil.getJiaZiIndex(this.getGanZhi()) + 1;
        int offset = (62 + yuan * 3 - index) % 9;
        if (0 == offset) {
            offset = 9;
        }
        return NineStar.fromIndex(offset - 1);
    }

    public String getPositionXi() {
        return LunarUtil.POSITION_XI[this.ganIndex + 1];
    }

    public String getPositionXiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getPositionXi());
    }

    public String getPositionYangGui() {
        return LunarUtil.POSITION_YANG_GUI[this.ganIndex + 1];
    }

    public String getPositionYangGuiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getPositionYangGui());
    }

    public String getPositionYinGui() {
        return LunarUtil.POSITION_YIN_GUI[this.ganIndex + 1];
    }

    public String getPositionYinGuiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getPositionYinGui());
    }

    public String getPositionFu() {
        return this.getPositionFu(2);
    }

    public String getPositionFu(int sect) {
        return (1 == sect ? LunarUtil.POSITION_FU : LunarUtil.POSITION_FU_2)[this.ganIndex + 1];
    }

    public String getPositionFuDesc() {
        return this.getPositionFuDesc(2);
    }

    public String getPositionFuDesc(int sect) {
        return LunarUtil.POSITION_DESC.get(this.getPositionFu(sect));
    }

    public String getPositionCai() {
        return LunarUtil.POSITION_CAI[this.ganIndex + 1];
    }

    public String getPositionCaiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getPositionCai());
    }

    public String getPositionTaiSui() {
        return LunarUtil.POSITION_TAI_SUI_YEAR[this.zhiIndex];
    }

    public String getPositionTaiSuiDesc() {
        return LunarUtil.POSITION_DESC.get(this.getPositionTaiSui());
    }

    public String toString() {
        return this.year + "";
    }

    public String toFullString() {
        return this.year + "\u5e74";
    }

    public LunarYear next(int n) {
        return LunarYear.fromYear(this.year + n);
    }
}

