/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.ExactDate;
import com.nlf.calendar.Holiday;
import com.nlf.calendar.Lunar;
import com.nlf.calendar.util.HolidayUtil;
import com.nlf.calendar.util.LunarUtil;
import com.nlf.calendar.util.SolarUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solar {
    public static final double J2000 = 2451545.0;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private Calendar calendar;

    public Solar() {
        this(new Date());
    }

    public Solar(int year, int month, int day) {
        this(year, month, day, 0, 0, 0);
    }

    public Solar(int year, int month, int day, int hour, int minute, int second) {
        this.calendar = ExactDate.fromYmdHms(year, month, day, hour, minute, second);
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    public Solar(Date date) {
        this.calendar = ExactDate.fromDate(date);
        this.year = this.calendar.get(1);
        this.month = this.calendar.get(2) + 1;
        this.day = this.calendar.get(5);
        this.hour = this.calendar.get(11);
        this.minute = this.calendar.get(12);
        this.second = this.calendar.get(13);
    }

    public Solar(Calendar calendar) {
        calendar.set(14, 0);
        this.calendar = calendar;
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
    }

    public Solar(double julianDay) {
        int d = (int)(julianDay + 0.5);
        double f = julianDay + 0.5 - (double)d;
        if (d >= 2299161) {
            int c = (int)(((double)d - 1867216.25) / 36524.25);
            d += 1 + c - (int)((double)c * 1.0 / 4.0);
        }
        int year = (int)(((double)(d += 1524) - 122.1) / 365.25);
        int month = (int)((double)(d -= (int)(365.25 * (double)year)) * 1.0 / 30.601);
        int day = d -= (int)(30.601 * (double)month);
        if (month > 13) {
            month -= 13;
            year -= 4715;
        } else {
            --month;
            year -= 4716;
        }
        int hour = (int)(f *= 24.0);
        f -= (double)hour;
        int minute = (int)(f *= 60.0);
        f -= (double)minute;
        int second = (int)Math.round(f *= 60.0);
        this.calendar = ExactDate.fromYmdHms(year, month, day, hour, minute, second);
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    public static Solar fromDate(Date date) {
        return new Solar(date);
    }

    public static Solar fromCalendar(Calendar calendar) {
        return new Solar(calendar);
    }

    public static Solar fromJulianDay(double julianDay) {
        return new Solar(julianDay);
    }

    public static Solar fromYmd(int year, int month, int day) {
        return new Solar(year, month, day);
    }

    public static Solar fromYmdHms(int year, int month, int day, int hour, int minute, int second) {
        return new Solar(year, month, day, hour, minute, second);
    }

    public static List<Solar> fromBaZi(String yearGanZhi, String monthGanZhi, String dayGanZhi, String timeGanZhi) {
        return Solar.fromBaZi(yearGanZhi, monthGanZhi, dayGanZhi, timeGanZhi, 2);
    }

    public static List<Solar> fromBaZi(String yearGanZhi, String monthGanZhi, String dayGanZhi, String timeGanZhi, int sect) {
        return Solar.fromBaZi(yearGanZhi, monthGanZhi, dayGanZhi, timeGanZhi, sect, 1900);
    }

    public static List<Solar> fromBaZi(String yearGanZhi, String monthGanZhi, String dayGanZhi, String timeGanZhi, int sect, int baseYear) {
        sect = 1 == sect ? 1 : 2;
        ArrayList<Solar> l = new ArrayList<Solar>();
        Solar today = new Solar();
        Lunar lunar = today.getLunar();
        int offsetYear = LunarUtil.getJiaZiIndex(lunar.getYearInGanZhiExact()) - LunarUtil.getJiaZiIndex(yearGanZhi);
        if (offsetYear < 0) {
            offsetYear += 60;
        }
        int startYear = today.getYear() - offsetYear;
        int hour = 0;
        String timeZhi = timeGanZhi.substring(1);
        int j = LunarUtil.ZHI.length;
        for (int i = 0; i < j; ++i) {
            if (!LunarUtil.ZHI[i].equals(timeZhi)) continue;
            hour = (i - 1) * 2;
        }
        while (startYear >= baseYear) {
            int day;
            Solar solar;
            int counter;
            int year = startYear - 1;
            int month = 12;
            boolean found = false;
            for (counter = 0; counter < 15; ++counter) {
                if (year >= baseYear && (lunar = (solar = new Solar(year, month, day = 1, hour, 0, 0)).getLunar()).getYearInGanZhiExact().equals(yearGanZhi) && lunar.getMonthInGanZhiExact().equals(monthGanZhi)) {
                    found = true;
                    break;
                }
                if (++month <= 12) continue;
                month = 1;
                ++year;
            }
            if (found) {
                counter = 0;
                if (--month < 1) {
                    month = 12;
                    --year;
                }
                day = 1;
                solar = new Solar(year, month, day, hour, 0, 0);
                while (counter < 61) {
                    String dgz;
                    lunar = solar.getLunar();
                    String string = dgz = 2 == sect ? lunar.getDayInGanZhiExact2() : lunar.getDayInGanZhiExact();
                    if (lunar.getYearInGanZhiExact().equals(yearGanZhi) && lunar.getMonthInGanZhiExact().equals(monthGanZhi) && dgz.equals(dayGanZhi) && lunar.getTimeInGanZhi().equals(timeGanZhi)) {
                        l.add(solar);
                        break;
                    }
                    solar = solar.next(1);
                    ++counter;
                }
            }
            startYear -= 60;
        }
        return l;
    }

    public boolean isLeapYear() {
        return SolarUtil.isLeapYear(this.year);
    }

    public int getWeek() {
        return this.calendar.get(7) - 1;
    }

    public String getWeekInChinese() {
        return SolarUtil.WEEK[this.getWeek()];
    }

    public List<String> getFestivals() {
        ArrayList<String> l = new ArrayList<String>();
        String f = SolarUtil.FESTIVAL.get(this.month + "-" + this.day);
        if (null != f) {
            l.add(f);
        }
        int weeks = (int)Math.ceil((double)this.day / 7.0);
        int week = this.getWeek();
        f = SolarUtil.WEEK_FESTIVAL.get(this.month + "-" + weeks + "-" + week);
        if (null != f) {
            l.add(f);
        }
        return l;
    }

    public List<String> getOtherFestivals() {
        ArrayList<String> l = new ArrayList<String>();
        List<String> fs = SolarUtil.OTHER_FESTIVAL.get(this.month + "-" + this.day);
        if (null != fs) {
            l.addAll(fs);
        }
        return l;
    }

    public String getXingzuo() {
        return this.getXingZuo();
    }

    public String getXingZuo() {
        int index = 11;
        int y = this.month * 100 + this.day;
        if (y >= 321 && y <= 419) {
            index = 0;
        } else if (y >= 420 && y <= 520) {
            index = 1;
        } else if (y >= 521 && y <= 621) {
            index = 2;
        } else if (y >= 622 && y <= 722) {
            index = 3;
        } else if (y >= 723 && y <= 822) {
            index = 4;
        } else if (y >= 823 && y <= 922) {
            index = 5;
        } else if (y >= 923 && y <= 1023) {
            index = 6;
        } else if (y >= 1024 && y <= 1122) {
            index = 7;
        } else if (y >= 1123 && y <= 1221) {
            index = 8;
        } else if (y >= 1222 || y <= 119) {
            index = 9;
        } else if (y <= 218) {
            index = 10;
        }
        return SolarUtil.XINGZUO[index];
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public Lunar getLunar() {
        return new Lunar(this.calendar.getTime());
    }

    public double getJulianDay() {
        int y = this.year;
        int m = this.month;
        double d = (double)this.day + (((double)this.second * 1.0 / 60.0 + (double)this.minute) / 60.0 + (double)this.hour) / 24.0;
        int n = 0;
        boolean g = false;
        if (y * 372 + m * 31 + (int)d >= 588829) {
            g = true;
        }
        if (m <= 2) {
            m += 12;
            --y;
        }
        if (g) {
            n = (int)((double)y * 1.0 / 100.0);
            n = 2 - n + (int)((double)n * 1.0 / 4.0);
        }
        return (double)((int)(365.25 * (double)(y + 4716)) + (int)(30.6001 * (double)(m + 1))) + d + (double)n - 1524.5;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public String toString() {
        return this.toYmd();
    }

    public String toYmd() {
        return String.format("%04d-%02d-%02d", this.year, this.month, this.day);
    }

    public String toYmdHms() {
        return this.toYmd() + " " + String.format("%02d:%02d:%02d", this.hour, this.minute, this.second);
    }

    public String toFullString() {
        StringBuilder s = new StringBuilder();
        s.append(this.toYmdHms());
        if (this.isLeapYear()) {
            s.append(" ");
            s.append("\u95f0\u5e74");
        }
        s.append(" ");
        s.append("\u661f\u671f");
        s.append(this.getWeekInChinese());
        for (String f : this.getFestivals()) {
            s.append(" (");
            s.append(f);
            s.append(")");
        }
        for (String f : this.getOtherFestivals()) {
            s.append(" (");
            s.append(f);
            s.append(")");
        }
        s.append(" ");
        s.append(this.getXingZuo());
        s.append("\u5ea7");
        return s.toString();
    }

    public Solar next(int days) {
        return this.next(days, false);
    }

    public Solar next(int days, boolean onlyWorkday) {
        Calendar c = ExactDate.fromYmdHms(this.year, this.month, this.day, this.hour, this.minute, this.second);
        if (0 != days) {
            if (!onlyWorkday) {
                c.add(5, days);
            } else {
                int add;
                int rest = Math.abs(days);
                int n = add = days < 1 ? -1 : 1;
                while (rest > 0) {
                    c.add(5, add);
                    boolean work = true;
                    Holiday holiday = HolidayUtil.getHoliday(c.get(1), c.get(2) + 1, c.get(5));
                    if (null == holiday) {
                        int week = c.get(7);
                        if (1 == week || 7 == week) {
                            work = false;
                        }
                    } else {
                        work = holiday.isWork();
                    }
                    if (!work) continue;
                    --rest;
                }
            }
        }
        return new Solar(c);
    }
}

