/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.LunarYear;
import com.nlf.calendar.util.LunarUtil;

public class LunarMonth {
    private int year;
    private int month;
    private int dayCount;
    private double firstJulianDay;

    public LunarMonth(int lunarYear, int lunarMonth, int dayCount, double firstJulianDay) {
        this.year = lunarYear;
        this.month = lunarMonth;
        this.dayCount = dayCount;
        this.firstJulianDay = firstJulianDay;
    }

    public static LunarMonth fromYm(int lunarYear, int lunarMonth) {
        return LunarYear.fromYear(lunarYear).getMonth(lunarMonth);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public boolean isLeap() {
        return this.month < 0;
    }

    public int getDayCount() {
        return this.dayCount;
    }

    public double getFirstJulianDay() {
        return this.firstJulianDay;
    }

    public String toString() {
        return this.year + "\u5e74" + (this.isLeap() ? "\u95f0" : "") + LunarUtil.MONTH[Math.abs(this.month)] + "\u6708(" + this.dayCount + "\u5929)";
    }
}

