/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.ExactDate;
import com.nlf.calendar.SolarMonth;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolarYear {
    private final int year;
    public static final int MONTH_COUNT = 12;

    public SolarYear() {
        this(new Date());
    }

    public SolarYear(Date date) {
        Calendar c = ExactDate.fromDate(date);
        this.year = c.get(1);
    }

    public SolarYear(Calendar calendar) {
        this.year = calendar.get(1);
    }

    public SolarYear(int year) {
        this.year = year;
    }

    public static SolarYear fromDate(Date date) {
        return new SolarYear(date);
    }

    public static SolarYear fromCalendar(Calendar calendar) {
        return new SolarYear(calendar);
    }

    public static SolarYear fromYear(int year) {
        return new SolarYear(year);
    }

    public int getYear() {
        return this.year;
    }

    public List<SolarMonth> getMonths() {
        ArrayList<SolarMonth> l = new ArrayList<SolarMonth>(12);
        SolarMonth m = new SolarMonth(this.year, 1);
        l.add(m);
        for (int i = 1; i < 12; ++i) {
            l.add(m.next(i));
        }
        return l;
    }

    public SolarYear next(int years) {
        Calendar c = ExactDate.fromYmd(this.year, 1, 1);
        c.add(1, years);
        return new SolarYear(c);
    }

    public String toString() {
        return this.year + "";
    }

    public String toFullString() {
        return this.year + "\u5e74";
    }
}

