/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.ExactDate;
import com.nlf.calendar.SolarMonth;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolarHalfYear {
    private final int year;
    private final int month;
    public static final int MONTH_COUNT = 6;

    public SolarHalfYear() {
        this(new Date());
    }

    public SolarHalfYear(Date date) {
        Calendar c = ExactDate.fromDate(date);
        this.year = c.get(1);
        this.month = c.get(2) + 1;
    }

    public SolarHalfYear(Calendar calendar) {
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
    }

    public SolarHalfYear(int year, int month) {
        this.year = year;
        this.month = month;
    }

    public static SolarHalfYear fromDate(Date date) {
        return new SolarHalfYear(date);
    }

    public static SolarHalfYear fromCalendar(Calendar calendar) {
        return new SolarHalfYear(calendar);
    }

    public static SolarHalfYear fromYm(int year, int month) {
        return new SolarHalfYear(year, month);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getIndex() {
        return (int)Math.ceil((double)this.month * 1.0 / 6.0);
    }

    public SolarHalfYear next(int halfYears) {
        if (0 == halfYears) {
            return new SolarHalfYear(this.year, this.month);
        }
        Calendar c = ExactDate.fromYmd(this.year, this.month, 1);
        c.add(2, 6 * halfYears);
        return new SolarHalfYear(c);
    }

    public List<SolarMonth> getMonths() {
        ArrayList<SolarMonth> l = new ArrayList<SolarMonth>();
        int index = this.getIndex() - 1;
        for (int i = 0; i < 6; ++i) {
            l.add(new SolarMonth(this.year, 6 * index + i + 1));
        }
        return l;
    }

    public String toString() {
        return this.year + "." + this.getIndex();
    }

    public String toFullString() {
        return this.year + "\u5e74" + (this.getIndex() == 1 ? "\u4e0a" : "\u4e0b") + "\u534a\u5e74";
    }
}

