/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.FotoFestival;
import com.nlf.calendar.Lunar;
import com.nlf.calendar.LunarMonth;
import com.nlf.calendar.util.FotoUtil;
import com.nlf.calendar.util.LunarUtil;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Foto {
    public static final int DEAD_YEAR = -543;
    private final Lunar lunar;

    public Foto(Lunar lunar) {
        this.lunar = lunar;
    }

    public static Foto fromLunar(Lunar lunar) {
        return new Foto(lunar);
    }

    public static Foto fromYmdHms(int year, int month, int day, int hour, int minute, int second) {
        return Foto.fromLunar(Lunar.fromYmdHms(year + -543 - 1, month, day, hour, minute, second));
    }

    public static Foto fromYmd(int year, int month, int day) {
        return Foto.fromYmdHms(year, month, day, 0, 0, 0);
    }

    public Lunar getLunar() {
        return this.lunar;
    }

    public int getYear() {
        int sy = this.lunar.getSolar().getYear();
        int y = sy - -543;
        if (sy == this.lunar.getYear()) {
            ++y;
        }
        return y;
    }

    public int getMonth() {
        return this.lunar.getMonth();
    }

    public int getDay() {
        return this.lunar.getDay();
    }

    public String getYearInChinese() {
        String y = this.getYear() + "";
        StringBuilder s = new StringBuilder();
        int j = y.length();
        for (int i = 0; i < j; ++i) {
            s.append(LunarUtil.NUMBER[y.charAt(i) - 48]);
        }
        return s.toString();
    }

    public String getMonthInChinese() {
        return this.lunar.getMonthInChinese();
    }

    public String getDayInChinese() {
        return this.lunar.getDayInChinese();
    }

    public List<FotoFestival> getFestivals() {
        ArrayList<FotoFestival> l = new ArrayList<FotoFestival>();
        List<FotoFestival> fs = FotoUtil.FESTIVAL.get(this.getMonth() + "-" + this.getDay());
        if (null != fs) {
            l.addAll(fs);
        }
        return l;
    }

    public boolean isMonthZhai() {
        int m = this.getMonth();
        return 1 == m || 5 == m || 9 == m;
    }

    public boolean isDayYangGong() {
        for (FotoFestival f : this.getFestivals()) {
            if (!"\u6768\u516c\u5fcc".equals(f.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isDayZhaiShuoWang() {
        int d = this.getDay();
        return 1 == d || 15 == d;
    }

    public boolean isDayZhaiSix() {
        int d = this.getDay();
        if (8 == d || 14 == d || 15 == d || 23 == d || 29 == d || 30 == d) {
            return true;
        }
        if (28 == d) {
            LunarMonth m = LunarMonth.fromYm(this.lunar.getYear(), this.getMonth());
            return null != m && 30 != m.getDayCount();
        }
        return false;
    }

    public boolean isDayZhaiTen() {
        int d = this.getDay();
        return 1 == d || 8 == d || 14 == d || 15 == d || 18 == d || 23 == d || 24 == d || 28 == d || 29 == d || 30 == d;
    }

    public boolean isDayZhaiGuanYin() {
        String k = this.getMonth() + "-" + this.getDay();
        for (String d : FotoUtil.DAY_ZHAI_GUAN_YIN) {
            if (!k.equals(d)) continue;
            return true;
        }
        return false;
    }

    public String getXiu() {
        return FotoUtil.getXiu(this.getMonth(), this.getDay());
    }

    public String getXiuLuck() {
        return LunarUtil.XIU_LUCK.get(this.getXiu());
    }

    public String getXiuSong() {
        return LunarUtil.XIU_SONG.get(this.getXiu());
    }

    public String getZheng() {
        return LunarUtil.ZHENG.get(this.getXiu());
    }

    public String getAnimal() {
        return LunarUtil.ANIMAL.get(this.getXiu());
    }

    public String getGong() {
        return LunarUtil.GONG.get(this.getXiu());
    }

    public String getShou() {
        return LunarUtil.SHOU.get(this.getGong());
    }

    public String toString() {
        return this.getYearInChinese() + "\u5e74" + this.getMonthInChinese() + "\u6708" + this.getDayInChinese();
    }

    public String toFullString() {
        StringBuilder s = new StringBuilder();
        s.append(this);
        for (FotoFestival f : this.getFestivals()) {
            s.append(" (");
            s.append(f);
            s.append(")");
        }
        return s.toString();
    }
}

