/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar.util;

import com.nlf.calendar.ExactDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SolarUtil {
    public static final String[] WEEK = new String[]{"\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"};
    public static final int[] DAYS_OF_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final String[] XINGZUO = new String[]{"\u767d\u7f8a", "\u91d1\u725b", "\u53cc\u5b50", "\u5de8\u87f9", "\u72ee\u5b50", "\u5904\u5973", "\u5929\u79e4", "\u5929\u874e", "\u5c04\u624b", "\u6469\u7faf", "\u6c34\u74f6", "\u53cc\u9c7c"};
    public static final Map<String, String> FESTIVAL = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("1-1", "\u5143\u65e6\u8282");
            this.put("2-14", "\u60c5\u4eba\u8282");
            this.put("3-8", "\u5987\u5973\u8282");
            this.put("3-12", "\u690d\u6811\u8282");
            this.put("3-15", "\u6d88\u8d39\u8005\u6743\u76ca\u65e5");
            this.put("4-1", "\u611a\u4eba\u8282");
            this.put("5-1", "\u52b3\u52a8\u8282");
            this.put("5-4", "\u9752\u5e74\u8282");
            this.put("6-1", "\u513f\u7ae5\u8282");
            this.put("7-1", "\u5efa\u515a\u8282");
            this.put("8-1", "\u5efa\u519b\u8282");
            this.put("9-10", "\u6559\u5e08\u8282");
            this.put("10-1", "\u56fd\u5e86\u8282");
            this.put("12-24", "\u5e73\u5b89\u591c");
            this.put("12-25", "\u5723\u8bde\u8282");
        }
    };
    public static final Map<String, String> WEEK_FESTIVAL = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("5-2-0", "\u6bcd\u4eb2\u8282");
            this.put("6-3-0", "\u7236\u4eb2\u8282");
            this.put("11-4-4", "\u611f\u6069\u8282");
        }
    };
    public static final Map<String, List<String>> OTHER_FESTIVAL = new HashMap<String, List<String>>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("1-8", Collections.nCopies(1, "\u5468\u6069\u6765\u901d\u4e16\u7eaa\u5ff5\u65e5"));
            this.put("1-10", Arrays.asList("\u4e2d\u56fd\u4eba\u6c11\u8b66\u5bdf\u8282", "\u4e2d\u56fd\u516c\u5b89110\u5ba3\u4f20\u65e5"));
            this.put("1-21", Collections.nCopies(1, "\u5217\u5b81\u901d\u4e16\u7eaa\u5ff5\u65e5"));
            this.put("1-26", Collections.nCopies(1, "\u56fd\u9645\u6d77\u5173\u65e5"));
            this.put("2-2", Collections.nCopies(1, "\u4e16\u754c\u6e7f\u5730\u65e5"));
            this.put("2-4", Collections.nCopies(1, "\u4e16\u754c\u6297\u764c\u65e5"));
            this.put("2-7", Collections.nCopies(1, "\u4eac\u6c49\u94c1\u8def\u7f62\u5de5\u7eaa\u5ff5"));
            this.put("2-10", Collections.nCopies(1, "\u56fd\u9645\u6c14\u8c61\u8282"));
            this.put("2-19", Collections.nCopies(1, "\u9093\u5c0f\u5e73\u901d\u4e16\u7eaa\u5ff5\u65e5"));
            this.put("2-21", Collections.nCopies(1, "\u56fd\u9645\u6bcd\u8bed\u65e5"));
            this.put("2-24", Collections.nCopies(1, "\u7b2c\u4e09\u4e16\u754c\u9752\u5e74\u65e5"));
            this.put("3-1", Collections.nCopies(1, "\u56fd\u9645\u6d77\u8c79\u65e5"));
            this.put("3-3", Collections.nCopies(1, "\u5168\u56fd\u7231\u8033\u65e5"));
            this.put("3-5", Arrays.asList("\u5468\u6069\u6765\u8bde\u8fb0\u7eaa\u5ff5\u65e5", "\u4e2d\u56fd\u9752\u5e74\u5fd7\u613f\u8005\u670d\u52a1\u65e5"));
            this.put("3-6", Collections.nCopies(1, "\u4e16\u754c\u9752\u5149\u773c\u65e5"));
            this.put("3-12", Collections.nCopies(1, "\u5b59\u4e2d\u5c71\u901d\u4e16\u7eaa\u5ff5\u65e5"));
            this.put("3-14", Collections.nCopies(1, "\u9a6c\u514b\u601d\u901d\u4e16\u7eaa\u5ff5\u65e5"));
            this.put("3-17", Collections.nCopies(1, "\u56fd\u9645\u822a\u6d77\u65e5"));
            this.put("3-18", Collections.nCopies(1, "\u5168\u56fd\u79d1\u6280\u4eba\u624d\u6d3b\u52a8\u65e5"));
            this.put("3-21", Arrays.asList("\u4e16\u754c\u68ee\u6797\u65e5", "\u4e16\u754c\u7761\u7720\u65e5"));
            this.put("3-22", Collections.nCopies(1, "\u4e16\u754c\u6c34\u65e5"));
            this.put("3-23", Collections.nCopies(1, "\u4e16\u754c\u6c14\u8c61\u65e5"));
            this.put("3-24", Collections.nCopies(1, "\u4e16\u754c\u9632\u6cbb\u7ed3\u6838\u75c5\u65e5"));
            this.put("4-2", Collections.nCopies(1, "\u56fd\u9645\u513f\u7ae5\u56fe\u4e66\u65e5"));
            this.put("4-7", Collections.nCopies(1, "\u4e16\u754c\u536b\u751f\u65e5"));
            this.put("4-22", Collections.nCopies(1, "\u5217\u5b81\u8bde\u8fb0\u7eaa\u5ff5\u65e5"));
            this.put("4-23", Collections.nCopies(1, "\u4e16\u754c\u56fe\u4e66\u548c\u7248\u6743\u65e5"));
            this.put("4-26", Collections.nCopies(1, "\u4e16\u754c\u77e5\u8bc6\u4ea7\u6743\u65e5"));
            this.put("5-3", Collections.nCopies(1, "\u4e16\u754c\u65b0\u95fb\u81ea\u7531\u65e5"));
            this.put("5-5", Collections.nCopies(1, "\u9a6c\u514b\u601d\u8bde\u8fb0\u7eaa\u5ff5\u65e5"));
            this.put("5-8", Collections.nCopies(1, "\u4e16\u754c\u7ea2\u5341\u5b57\u65e5"));
            this.put("5-11", Collections.nCopies(1, "\u4e16\u754c\u80a5\u80d6\u65e5"));
            this.put("5-27", Collections.nCopies(1, "\u4e0a\u6d77\u89e3\u653e\u65e5"));
            this.put("5-31", Collections.nCopies(1, "\u4e16\u754c\u65e0\u70df\u65e5"));
            this.put("6-5", Collections.nCopies(1, "\u4e16\u754c\u73af\u5883\u65e5"));
            this.put("6-6", Collections.nCopies(1, "\u5168\u56fd\u7231\u773c\u65e5"));
            this.put("6-8", Collections.nCopies(1, "\u4e16\u754c\u6d77\u6d0b\u65e5"));
            this.put("6-11", Collections.nCopies(1, "\u4e2d\u56fd\u4eba\u53e3\u65e5"));
            this.put("6-14", Collections.nCopies(1, "\u4e16\u754c\u732e\u8840\u65e5"));
            this.put("7-1", Collections.nCopies(1, "\u9999\u6e2f\u56de\u5f52\u7eaa\u5ff5\u65e5"));
            this.put("7-7", Collections.nCopies(1, "\u4e2d\u56fd\u4eba\u6c11\u6297\u65e5\u6218\u4e89\u7eaa\u5ff5\u65e5"));
            this.put("7-11", Collections.nCopies(1, "\u4e16\u754c\u4eba\u53e3\u65e5"));
            this.put("8-5", Collections.nCopies(1, "\u6069\u683c\u65af\u901d\u4e16\u7eaa\u5ff5\u65e5"));
            this.put("8-6", Collections.nCopies(1, "\u56fd\u9645\u7535\u5f71\u8282"));
            this.put("8-12", Collections.nCopies(1, "\u56fd\u9645\u9752\u5e74\u65e5"));
            this.put("8-22", Collections.nCopies(1, "\u9093\u5c0f\u5e73\u8bde\u8fb0\u7eaa\u5ff5\u65e5"));
            this.put("9-3", Collections.nCopies(1, "\u4e2d\u56fd\u6297\u65e5\u6218\u4e89\u80dc\u5229\u7eaa\u5ff5\u65e5"));
            this.put("9-8", Collections.nCopies(1, "\u4e16\u754c\u626b\u76f2\u65e5"));
            this.put("9-9", Collections.nCopies(1, "\u6bdb\u6cfd\u4e1c\u901d\u4e16\u7eaa\u5ff5\u65e5"));
            this.put("9-14", Collections.nCopies(1, "\u4e16\u754c\u6e05\u6d01\u5730\u7403\u65e5"));
            this.put("9-18", Collections.nCopies(1, "\u4e5d\u4e00\u516b\u4e8b\u53d8\u7eaa\u5ff5\u65e5"));
            this.put("9-20", Collections.nCopies(1, "\u5168\u56fd\u7231\u7259\u65e5"));
            this.put("9-21", Collections.nCopies(1, "\u56fd\u9645\u548c\u5e73\u65e5"));
            this.put("9-27", Collections.nCopies(1, "\u4e16\u754c\u65c5\u6e38\u65e5"));
            this.put("10-4", Collections.nCopies(1, "\u4e16\u754c\u52a8\u7269\u65e5"));
            this.put("10-10", Collections.nCopies(1, "\u8f9b\u4ea5\u9769\u547d\u7eaa\u5ff5\u65e5"));
            this.put("10-13", Collections.nCopies(1, "\u4e2d\u56fd\u5c11\u5e74\u5148\u950b\u961f\u8bde\u8fb0\u65e5"));
            this.put("10-25", Collections.nCopies(1, "\u6297\u7f8e\u63f4\u671d\u7eaa\u5ff5\u65e5"));
            this.put("11-12", Collections.nCopies(1, "\u5b59\u4e2d\u5c71\u8bde\u8fb0\u7eaa\u5ff5\u65e5"));
            this.put("11-17", Collections.nCopies(1, "\u56fd\u9645\u5927\u5b66\u751f\u8282"));
            this.put("11-28", Collections.nCopies(1, "\u6069\u683c\u65af\u8bde\u8fb0\u7eaa\u5ff5\u65e5"));
            this.put("12-1", Collections.nCopies(1, "\u4e16\u754c\u827e\u6ecb\u75c5\u65e5"));
            this.put("12-12", Collections.nCopies(1, "\u897f\u5b89\u4e8b\u53d8\u7eaa\u5ff5\u65e5"));
            this.put("12-13", Collections.nCopies(1, "\u56fd\u5bb6\u516c\u796d\u65e5"));
            this.put("12-26", Collections.nCopies(1, "\u6bdb\u6cfd\u4e1c\u8bde\u8fb0\u7eaa\u5ff5\u65e5"));
        }
    };

    protected SolarUtil() {
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static int getDaysOfMonth(int year, int month) {
        int m = month - 1;
        int d = DAYS_OF_MONTH[m];
        if (m == 1 && SolarUtil.isLeapYear(year)) {
            ++d;
        }
        return d;
    }

    public static int getWeeksOfMonth(int year, int month, int start) {
        int days = SolarUtil.getDaysOfMonth(year, month);
        int week = ExactDate.fromYmd(year, month, 1).get(7) - 1;
        return (int)Math.ceil((double)(days + week - start) * 1.0 / (double)WEEK.length);
    }
}

