/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar.eightchar;

import com.nlf.calendar.EightChar;
import com.nlf.calendar.ExactDate;
import com.nlf.calendar.JieQi;
import com.nlf.calendar.Lunar;
import com.nlf.calendar.Solar;
import com.nlf.calendar.eightchar.DaYun;
import com.nlf.calendar.util.LunarUtil;
import java.util.Calendar;

public class Yun {
    private int gender;
    private int startYear;
    private int startMonth;
    private int startDay;
    private boolean forward;
    private Lunar lunar;

    public Yun(EightChar eightChar, int gender) {
        this.lunar = eightChar.getLunar();
        this.gender = gender;
        boolean yang = 0 == this.lunar.getYearGanIndexExact() % 2;
        boolean man = 1 == gender;
        this.forward = yang && man || !yang && !man;
        this.computeStart();
    }

    private void computeStart() {
        JieQi prev = this.lunar.getPrevJie();
        JieQi next = this.lunar.getNextJie();
        Solar current = this.lunar.getSolar();
        Solar start = this.forward ? current : prev.getSolar();
        Solar end = this.forward ? next.getSolar() : current;
        int endTimeZhiIndex = end.getHour() == 23 ? 11 : LunarUtil.getTimeZhiIndex(end.toYmdHms().substring(11, 16));
        int startTimeZhiIndex = start.getHour() == 23 ? 11 : LunarUtil.getTimeZhiIndex(start.toYmdHms().substring(11, 16));
        int hourDiff = endTimeZhiIndex - startTimeZhiIndex;
        Calendar endCalendar = ExactDate.fromYmd(end.getYear(), end.getMonth(), end.getDay());
        Calendar startCalendar = ExactDate.fromYmd(start.getYear(), start.getMonth(), start.getDay());
        int dayDiff = (int)((endCalendar.getTimeInMillis() - startCalendar.getTimeInMillis()) / 86400000L);
        if (hourDiff < 0) {
            hourDiff += 12;
            --dayDiff;
        }
        int monthDiff = hourDiff * 10 / 30;
        int month = dayDiff * 4 + monthDiff;
        int day = hourDiff * 10 - monthDiff * 30;
        int year = month / 12;
        this.startYear = year;
        this.startMonth = month -= year * 12;
        this.startDay = day;
    }

    public int getGender() {
        return this.gender;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public int getStartMonth() {
        return this.startMonth;
    }

    public int getStartDay() {
        return this.startDay;
    }

    public boolean isForward() {
        return this.forward;
    }

    public Lunar getLunar() {
        return this.lunar;
    }

    public Solar getStartSolar() {
        Solar birth = this.lunar.getSolar();
        Calendar c = ExactDate.fromYmd(birth.getYear(), birth.getMonth(), birth.getDay());
        c.add(1, this.startYear);
        c.add(2, this.startMonth);
        c.add(5, this.startDay);
        return Solar.fromCalendar(c);
    }

    public DaYun[] getDaYun() {
        return this.getDaYun(10);
    }

    public DaYun[] getDaYun(int n) {
        DaYun[] l = new DaYun[n];
        for (int i = 0; i < n; ++i) {
            l[i] = new DaYun(this, i);
        }
        return l;
    }
}

