/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar.eightchar;

import com.nlf.calendar.Lunar;
import com.nlf.calendar.eightchar.LiuNian;
import com.nlf.calendar.eightchar.XiaoYun;
import com.nlf.calendar.eightchar.Yun;
import com.nlf.calendar.util.LunarUtil;

public class DaYun {
    private int startYear;
    private int endYear;
    private int startAge;
    private int endAge;
    private int index;
    private Yun yun;
    private Lunar lunar;

    public DaYun(Yun yun, int index) {
        this.yun = yun;
        this.lunar = yun.getLunar();
        this.index = index;
        int birthYear = this.lunar.getSolar().getYear();
        int year = yun.getStartSolar().getYear();
        if (index < 1) {
            this.startYear = birthYear;
            this.startAge = 1;
            this.endYear = year - 1;
            this.endAge = year - birthYear;
        } else {
            int add = (index - 1) * 10;
            this.startYear = year + add;
            this.startAge = this.startYear - birthYear + 1;
            this.endYear = this.startYear + 9;
            this.endAge = this.startAge + 9;
        }
    }

    public int getStartYear() {
        return this.startYear;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public int getStartAge() {
        return this.startAge;
    }

    public int getEndAge() {
        return this.endAge;
    }

    public int getIndex() {
        return this.index;
    }

    public Lunar getLunar() {
        return this.lunar;
    }

    public String getGanZhi() {
        int size;
        if (this.index < 1) {
            return "";
        }
        int offset = LunarUtil.getJiaZiIndex(this.lunar.getMonthInGanZhiExact());
        if ((offset += this.yun.isForward() ? this.index : -this.index) >= (size = LunarUtil.JIA_ZI.length)) {
            offset -= size;
        }
        if (offset < 0) {
            offset += size;
        }
        return LunarUtil.JIA_ZI[offset];
    }

    public String getXun() {
        return LunarUtil.getXun(this.getGanZhi());
    }

    public String getXunKong() {
        return LunarUtil.getXunKong(this.getGanZhi());
    }

    public LiuNian[] getLiuNian() {
        return this.getLiuNian(10);
    }

    public LiuNian[] getLiuNian(int n) {
        if (this.index < 1) {
            n = this.endYear - this.startYear + 1;
        }
        LiuNian[] l = new LiuNian[n];
        for (int i = 0; i < n; ++i) {
            l[i] = new LiuNian(this, i);
        }
        return l;
    }

    public XiaoYun[] getXiaoYun() {
        return this.getXiaoYun(10);
    }

    public XiaoYun[] getXiaoYun(int n) {
        if (this.index < 1) {
            n = this.endYear - this.startYear + 1;
        }
        XiaoYun[] l = new XiaoYun[n];
        for (int i = 0; i < n; ++i) {
            l[i] = new XiaoYun(this, i, this.yun.isForward());
        }
        return l;
    }
}

