/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.Lunar;
import com.nlf.calendar.TaoFestival;
import com.nlf.calendar.util.LunarUtil;
import com.nlf.calendar.util.TaoUtil;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tao {
    public static final int BIRTH_YEAR = -2697;
    private Lunar lunar;

    public Tao(Lunar lunar) {
        this.lunar = lunar;
    }

    public static Tao fromLunar(Lunar lunar) {
        return new Tao(lunar);
    }

    public static Tao fromYmdHms(int year, int month, int day, int hour, int minute, int second) {
        return Tao.fromLunar(Lunar.fromYmdHms(year + -2697, month, day, hour, minute, second));
    }

    public static Tao fromYmd(int year, int month, int day) {
        return Tao.fromYmdHms(year, month, day, 0, 0, 0);
    }

    public Lunar getLunar() {
        return this.lunar;
    }

    public int getYear() {
        return this.lunar.getYear() - -2697;
    }

    public int getMonth() {
        return this.lunar.getMonth();
    }

    public int getDay() {
        return this.lunar.getDay();
    }

    public String getYearInChinese() {
        String y = this.getYear() + "";
        StringBuilder s = new StringBuilder();
        int j = y.length();
        for (int i = 0; i < j; ++i) {
            s.append(LunarUtil.NUMBER[y.charAt(i) - 48]);
        }
        return s.toString();
    }

    public String getMonthInChinese() {
        return this.lunar.getMonthInChinese();
    }

    public String getDayInChinese() {
        return this.lunar.getDayInChinese();
    }

    public List<TaoFestival> getFestivals() {
        String jq;
        ArrayList<TaoFestival> l = new ArrayList<TaoFestival>();
        List<TaoFestival> fs = TaoUtil.FESTIVAL.get(this.getMonth() + "-" + this.getDay());
        if (null != fs) {
            l.addAll(fs);
        }
        if ("\u51ac\u81f3".equals(jq = this.lunar.getJieQi())) {
            l.add(new TaoFestival("\u5143\u59cb\u5929\u5c0a\u5723\u8bde"));
        } else if ("\u590f\u81f3".equals(jq)) {
            l.add(new TaoFestival("\u7075\u5b9d\u5929\u5c0a\u5723\u8bde"));
        }
        String f = TaoUtil.BA_JIE.get(jq);
        if (null != f) {
            l.add(new TaoFestival(f));
        }
        if (null != (f = TaoUtil.BA_HUI.get(this.lunar.getDayInGanZhi()))) {
            l.add(new TaoFestival(f));
        }
        return l;
    }

    private boolean isDayIn(String[] days) {
        String md = this.getMonth() + "-" + this.getDay();
        for (String d : days) {
            if (!md.equals(d)) continue;
            return true;
        }
        return false;
    }

    public boolean isDaySanHui() {
        return this.isDayIn(TaoUtil.SAN_HUI);
    }

    public boolean isDaySanYuan() {
        return this.isDayIn(TaoUtil.SAN_YUAN);
    }

    public boolean isDayBaJie() {
        return TaoUtil.BA_JIE.containsKey(this.lunar.getJieQi());
    }

    public boolean isDayWuLa() {
        return this.isDayIn(TaoUtil.WU_LA);
    }

    public boolean isDayBaHui() {
        return TaoUtil.BA_HUI.containsKey(this.lunar.getDayInGanZhi());
    }

    public boolean isDayMingWu() {
        return "\u620a".equals(this.lunar.getDayGan());
    }

    public boolean isDayAnWu() {
        return this.lunar.getDayZhi().equals(TaoUtil.AN_WU[Math.abs(this.getMonth()) - 1]);
    }

    public boolean isDayWu() {
        return this.isDayMingWu() || this.isDayAnWu();
    }

    public String toString() {
        return String.format("%s\u5e74%s\u6708%s", this.getYearInChinese(), this.getMonthInChinese(), this.getDayInChinese());
    }

    public String toFullString() {
        return String.format("\u9053\u6b77%s\u5e74\uff0c\u5929\u904b%s\u5e74\uff0c%s\u6708\uff0c%s\u65e5\u3002%s\u6708%s\u65e5\uff0c%s\u6642\u3002", this.getYearInChinese(), this.lunar.getYearInGanZhi(), this.lunar.getMonthInGanZhi(), this.lunar.getDayInGanZhi(), this.getMonthInChinese(), this.getDayInChinese(), this.lunar.getTimeZhi());
    }
}

