package com.nlf.calendar;

import java.util.*;

import com.nlf.calendar.util.LunarUtil;
import com.nlf.calendar.util.SolarUtil;

/**
 * 农历日期
 *
 * @author 6tail
 *
 */
public class Lunar{
  /** 节气表头部追加农历上年末的节气名(节令：大雪)，以示区分 */
  public static final String JIE_QI_PREPEND = "DA_XUE";
  /** 节气表尾部追加农历下年初的节气名(气令：冬至)，以示区分 */
  public static final String JIE_QI_APPEND = "DONG_ZHI";
  /** 农历年初节气名(气令：冬至) */
  public static final String JIE_QI_FIRST = "冬至";
  /** 农历年末节气名(节令：大雪) */
  public static final String JIE_QI_LAST = "大雪";
  /** 节气表尾部追加阳历下年初的第一个节气名(节令：小寒)，以示区分 */
  public static final String JIE_APPEND_SOLAR_FIRST = "XIAO_HAN";
  /** 节气表尾部追加阳历下年初的第二个节气名(气令：大寒)，以示区分 */
  public static final String QI_APPEND_SOLAR_SECOND = "DA_HAN";
  /** 阳历下年初的第一个节气名(节令：小寒) */
  public static final String JIE_SOLAR_FIRST = "小寒";
  /** 阳历下年初的第二个节气名(气令：大寒) */
  public static final String QI_SOLAR_SECOND = "大寒";
  /** 1弧度对应的角秒 */
  private static final double SECOND_PER_RAD = 180 * 3600 / Math.PI;
  /** 节气表，国标以冬至为首个节气 */
  private static final String[] JIE_QI = {"冬至","小寒","大寒","立春","雨水","惊蛰","春分","清明","谷雨","立夏","小满","芒种","夏至","小暑","大暑","立秋","处暑","白露","秋分","寒露","霜降","立冬","小雪","大雪"};
  private static final double[] NUT_B = {2.1824, -33.75705, 36e-6, -1720, 920, 3.5069, 1256.66393, 11e-6, -132, 57, 1.3375, 16799.4182, -51e-6, -23, 10, 4.3649, -67.5141, 72e-6, 21, -9, 0.04, -628.302, 0, -14, 0, 2.36, 8328.691, 0, 7, 0, 3.46, 1884.966, 0, -5, 2, 5.44, 16833.175, 0, -4, 2, 3.69, 25128.110, 0, -3, 0, 3.55, 628.362, 0, 2, 0};
  private static final double[] DT_AT = {-4000, 108371.7, -13036.80, 392.000, 0.0000, -500, 17201.0, -627.82, 16.170, -0.3413, -150, 12200.6, -346.41, 5.403, -0.1593, 150, 9113.8, -328.13, -1.647, 0.0377, 500, 5707.5, -391.41, 0.915, 0.3145, 900, 2203.4, -283.45, 13.034, -0.1778, 1300, 490.1, -57.35, 2.085, -0.0072, 1600, 120.0, -9.81, -1.532, 0.1403, 1700, 10.2, -0.91, 0.510, -0.0370, 1800, 13.4, -0.72, 0.202, -0.0193, 1830, 7.8, -1.81, 0.416, -0.0247, 1860, 8.3, -0.13, -0.406, 0.0292, 1880, -5.4, 0.32, -0.183, 0.0173, 1900, -2.3, 2.06, 0.169, -0.0135, 1920, 21.2, 1.69, -0.304, 0.0167, 1940, 24.2, 1.22, -0.064, 0.0031, 1960, 33.2, 0.51, 0.231, -0.0109, 1980, 51.0, 1.29, -0.026, 0.0032, 2000, 63.87, 0.1, 0, 0, 2005, 64.7, 0.4, 0, 0, 2015, 69};
  private static final double[] XL0 = {10000000000D, 20, 578, 920, 1100, 1124, 1136, 1148, 1217, 1226, 1229, 1229, 1229, 1229, 1937, 2363, 2618, 2633, 2660, 2666, 17534704567D, 0.00000000000, 0.00000000000, 334165646, 4.669256804, 6283.075849991, 3489428, 4.6261024, 12566.1517000, 349706, 2.744118, 5753.384885, 341757, 2.828866, 3.523118, 313590, 3.627670, 77713.771468, 267622, 4.418084, 7860.419392, 234269, 6.135162, 3930.209696, 132429, 0.742464, 11506.769770, 127317, 2.037097, 529.690965, 119917, 1.109629, 1577.343542, 99025, 5.23268, 5884.92685, 90186, 2.04505, 26.29832, 85722, 3.50849, 398.14900, 77979, 1.17883, 5223.69392, 75314, 2.53339, 5507.55324, 50526, 4.58293, 18849.22755, 49238, 4.20507, 775.52261, 35666, 2.91954, 0.06731, 31709, 5.84902, 11790.62909, 28413, 1.89869, 796.29801, 27104, 0.31489, 10977.07880, 24281, 0.34481, 5486.77784, 20616, 4.80647, 2544.31442, 20539, 1.86948, 5573.14280, 20226, 2.45768, 6069.77675, 15552, 0.83306, 213.29910, 13221, 3.41118, 2942.46342, 12618, 1.08303, 20.77540, 11513, 0.64545, 0.98032, 10285, 0.63600, 4694.00295, 10190, 0.97569, 15720.83878, 10172, 4.26680, 7.11355, 9921, 6.2099, 2146.1654, 9761, 0.6810, 155.4204, 8580, 5.9832, 161000.6857, 8513, 1.2987, 6275.9623, 8471, 3.6708, 71430.6956, 7964, 1.8079, 17260.1547, 7876, 3.0370, 12036.4607, 7465, 1.7551, 5088.6288, 7387, 3.5032, 3154.6871, 7355, 4.6793, 801.8209, 6963, 0.8330, 9437.7629, 6245, 3.9776, 8827.3903, 6115, 1.8184, 7084.8968, 5696, 2.7843, 6286.5990, 5612, 4.3869, 14143.4952, 5558, 3.4701, 6279.5527, 5199, 0.1891, 12139.5535, 5161, 1.3328, 1748.0164, 5115, 0.2831, 5856.4777, 4900, 0.4874, 1194.4470, 4104, 5.3682, 8429.2413, 4094, 2.3985, 19651.0485, 3920, 6.1683, 10447.3878, 3677, 6.0413, 10213.2855, 3660, 2.5696, 1059.3819, 3595, 1.7088, 2352.8662, 3557, 1.7760, 6812.7668, 3329, 0.5931, 17789.8456, 3041, 0.4429, 83996.8473, 3005, 2.7398, 1349.8674, 2535, 3.1647, 4690.4798, 2474, 0.2148, 3.5904, 2366, 0.4847, 8031.0923, 2357, 2.0653, 3340.6124, 2282, 5.2220, 4705.7323, 2189, 5.5559, 553.5694, 2142, 1.4256, 16730.4637, 2109, 4.1483, 951.7184, 2030, 0.3713, 283.8593, 1992, 5.2221, 12168.0027, 1986, 5.7747, 6309.3742, 1912, 3.8222, 23581.2582, 1889, 5.3863, 149854.4001, 1790, 2.2149, 13367.9726, 1748, 4.5605, 135.0651, 1622, 5.9884, 11769.8537, 1508, 4.1957, 6256.7775, 1442, 4.1932, 242.7286, 1435, 3.7236, 38.0277, 1397, 4.4014, 6681.2249, 1362, 1.8893, 7632.9433, 1250, 1.1305, 5.5229, 1205, 2.6223, 955.5997, 1200, 1.0035, 632.7837, 1129, 0.1774, 4164.3120, 1083, 0.3273, 103.0928, 1052, 0.9387, 11926.2544, 1050, 5.3591, 1592.5960, 1033, 6.1998, 6438.4962, 1001, 6.0291, 5746.2713, 980, 0.999, 11371.705, 980, 5.244, 27511.468, 938, 2.624, 5760.498, 923, 0.483, 522.577, 922, 4.571, 4292.331, 905, 5.337, 6386.169, 862, 4.165, 7058.598, 841, 3.299, 7234.794, 836, 4.539, 25132.303, 813, 6.112, 4732.031, 812, 6.271, 426.598, 801, 5.821, 28.449, 787, 0.996, 5643.179, 776, 2.957, 23013.540, 769, 3.121, 7238.676, 758, 3.974, 11499.656, 735, 4.386, 316.392, 731, 0.607, 11513.883, 719, 3.998, 74.782, 706, 0.323, 263.084, 676, 5.911, 90955.552, 663, 3.665, 17298.182, 653, 5.791, 18073.705, 630, 4.717, 6836.645, 615, 1.458, 233141.314, 612, 1.075, 19804.827, 596, 3.321, 6283.009, 596, 2.876, 6283.143, 555, 2.452, 12352.853, 541, 5.392, 419.485, 531, 0.382, 31441.678, 519, 4.065, 6208.294, 513, 2.361, 10973.556, 494, 5.737, 9917.697, 450, 3.272, 11015.106, 449, 3.653, 206.186, 447, 2.064, 7079.374, 435, 4.423, 5216.580, 421, 1.906, 245.832, 413, 0.921, 3738.761, 402, 0.840, 20.355, 387, 1.826, 11856.219, 379, 2.344, 3.881, 374, 2.954, 3128.389, 370, 5.031, 536.805, 365, 1.018, 16200.773, 365, 1.083, 88860.057, 352, 5.978, 3894.182, 352, 2.056, 244287.600, 351, 3.713, 6290.189, 340, 1.106, 14712.317, 339, 0.978, 8635.942, 339, 3.202, 5120.601, 333, 0.837, 6496.375, 325, 3.479, 6133.513, 316, 5.089, 21228.392, 316, 1.328, 10873.986, 309, 3.646, 10.637, 303, 1.802, 35371.887, 296, 3.397, 9225.539, 288, 6.026, 154717.610, 281, 2.585, 14314.168, 262, 3.856, 266.607, 262, 2.579, 22483.849, 257, 1.561, 23543.231, 255, 3.949, 1990.745, 251, 3.744, 10575.407, 240, 1.161, 10984.192, 238, 0.106, 7.046, 236, 4.272, 6040.347, 234, 3.577, 10969.965, 211, 3.714, 65147.620, 210, 0.754, 13521.751, 207, 4.228, 5650.292, 202, 0.814, 170.673, 201, 4.629, 6037.244, 200, 0.381, 6172.870, 199, 3.933, 6206.810, 199, 5.197, 6262.300, 197, 1.046, 18209.330, 195, 1.070, 5230.807, 195, 4.869, 36.028, 194, 4.313, 6244.943, 192, 1.229, 709.933, 192, 5.595, 6282.096, 192, 0.602, 6284.056, 189, 3.744, 23.878, 188, 1.904, 15.252, 188, 0.867, 22003.915, 182, 3.681, 15110.466, 181, 0.491, 1.484, 179, 3.222, 39302.097, 179, 1.259, 12559.038, 62833196674749D, 0.000000000000, 0.000000000000, 20605886, 2.67823456, 6283.07584999, 430343, 2.635127, 12566.151700, 42526, 1.59047, 3.52312, 11926, 5.79557, 26.29832, 10898, 2.96618, 1577.34354, 9348, 2.5921, 18849.2275, 7212, 1.1385, 529.6910, 6777, 1.8747, 398.1490, 6733, 4.4092, 5507.5532, 5903, 2.8880, 5223.6939, 5598, 2.1747, 155.4204, 4541, 0.3980, 796.2980, 3637, 0.4662, 775.5226, 2896, 2.6471, 7.1135, 2084, 5.3414, 0.9803, 1910, 1.8463, 5486.7778, 1851, 4.9686, 213.2991, 1729, 2.9912, 6275.9623, 1623, 0.0322, 2544.3144, 1583, 1.4305, 2146.1654, 1462, 1.2053, 10977.0788, 1246, 2.8343, 1748.0164, 1188, 3.2580, 5088.6288, 1181, 5.2738, 1194.4470, 1151, 2.0750, 4694.0030, 1064, 0.7661, 553.5694, 997, 1.303, 6286.599, 972, 4.239, 1349.867, 945, 2.700, 242.729, 858, 5.645, 951.718, 758, 5.301, 2352.866, 639, 2.650, 9437.763, 610, 4.666, 4690.480, 583, 1.766, 1059.382, 531, 0.909, 3154.687, 522, 5.661, 71430.696, 520, 1.854, 801.821, 504, 1.425, 6438.496, 433, 0.241, 6812.767, 426, 0.774, 10447.388, 413, 5.240, 7084.897, 374, 2.001, 8031.092, 356, 2.429, 14143.495, 350, 4.800, 6279.553, 337, 0.888, 12036.461, 337, 3.862, 1592.596, 325, 3.400, 7632.943, 322, 0.616, 8429.241, 318, 3.188, 4705.732, 297, 6.070, 4292.331, 295, 1.431, 5746.271, 290, 2.325, 20.355, 275, 0.935, 5760.498, 270, 4.804, 7234.794, 253, 6.223, 6836.645, 228, 5.003, 17789.846, 225, 5.672, 11499.656, 215, 5.202, 11513.883, 208, 3.955, 10213.286, 208, 2.268, 522.577, 206, 2.224, 5856.478, 206, 2.550, 25132.303, 203, 0.910, 6256.778, 189, 0.532, 3340.612, 188, 4.735, 83996.847, 179, 1.474, 4164.312, 178, 3.025, 5.523, 177, 3.026, 5753.385, 159, 4.637, 3.286, 157, 6.124, 5216.580, 155, 3.077, 6681.225, 154, 4.200, 13367.973, 143, 1.191, 3894.182, 138, 3.093, 135.065, 136, 4.245, 426.598, 134, 5.765, 6040.347, 128, 3.085, 5643.179, 127, 2.092, 6290.189, 125, 3.077, 11926.254, 125, 3.445, 536.805, 114, 3.244, 12168.003, 112, 2.318, 16730.464, 111, 3.901, 11506.770, 111, 5.320, 23.878, 105, 3.750, 7860.419, 103, 2.447, 1990.745, 96, 0.82, 3.88, 96, 4.08, 6127.66, 91, 5.42, 206.19, 91, 0.42, 7079.37, 88, 5.17, 11790.63, 81, 0.34, 9917.70, 80, 3.89, 10973.56, 78, 2.40, 1589.07, 78, 2.58, 11371.70, 77, 3.98, 955.60, 77, 3.36, 36.03, 76, 1.30, 103.09, 75, 5.18, 10969.97, 75, 4.96, 6496.37, 73, 5.21, 38.03, 72, 2.65, 6309.37, 70, 5.61, 3738.76, 69, 2.60, 3496.03, 69, 0.39, 15.25, 69, 2.78, 20.78, 65, 1.13, 7058.60, 64, 4.28, 28.45, 61, 5.63, 10984.19, 60, 0.73, 419.48, 60, 5.28, 10575.41, 58, 5.55, 17298.18, 58, 3.19, 4732.03, 5291887, 0.0000000, 0.0000000, 871984, 1.072097, 6283.075850, 30913, 0.86729, 12566.15170, 2734, 0.0530, 3.5231, 1633, 5.1883, 26.2983, 1575, 3.6846, 155.4204, 954, 0.757, 18849.228, 894, 2.057, 77713.771, 695, 0.827, 775.523, 506, 4.663, 1577.344, 406, 1.031, 7.114, 381, 3.441, 5573.143, 346, 5.141, 796.298, 317, 6.053, 5507.553, 302, 1.192, 242.729, 289, 6.117, 529.691, 271, 0.306, 398.149, 254, 2.280, 553.569, 237, 4.381, 5223.694, 208, 3.754, 0.980, 168, 0.902, 951.718, 153, 5.759, 1349.867, 145, 4.364, 1748.016, 134, 3.721, 1194.447, 125, 2.948, 6438.496, 122, 2.973, 2146.165, 110, 1.271, 161000.686, 104, 0.604, 3154.687, 100, 5.986, 6286.599, 92, 4.80, 5088.63, 89, 5.23, 7084.90, 83, 3.31, 213.30, 76, 3.42, 5486.78, 71, 6.19, 4690.48, 68, 3.43, 4694.00, 65, 1.60, 2544.31, 64, 1.98, 801.82, 61, 2.48, 10977.08, 50, 1.44, 6836.65, 49, 2.34, 1592.60, 46, 1.31, 4292.33, 46, 3.81, 149854.40, 43, 0.04, 7234.79, 40, 4.94, 7632.94, 39, 1.57, 71430.70, 38, 3.17, 6309.37, 35, 0.99, 6040.35, 35, 0.67, 1059.38, 31, 3.18, 2352.87, 31, 3.55, 8031.09, 30, 1.92, 10447.39, 30, 2.52, 6127.66, 28, 4.42, 9437.76, 28, 2.71, 3894.18, 27, 0.67, 25132.30, 26, 5.27, 6812.77, 25, 0.55, 6279.55, 23, 1.38, 4705.73, 22, 0.64, 6256.78, 20, 6.07, 640.88, 28923, 5.84384, 6283.07585, 3496, 0.0000, 0.0000, 1682, 5.4877, 12566.1517, 296, 5.196, 155.420, 129, 4.722, 3.523, 71, 5.30, 18849.23, 64, 5.97, 242.73, 40, 3.79, 553.57, 11408, 3.14159, 0.00000, 772, 4.134, 6283.076, 77, 3.84, 12566.15, 42, 0.42, 155.42, 88, 3.14, 0.00, 17, 2.77, 6283.08, 5, 2.01, 155.42, 3, 2.21, 12566.15, 27962, 3.19870, 84334.66158, 10164, 5.42249, 5507.55324, 8045, 3.8801, 5223.6939, 4381, 3.7044, 2352.8662, 3193, 4.0003, 1577.3435, 2272, 3.9847, 1047.7473, 1814, 4.9837, 6283.0758, 1639, 3.5646, 5856.4777, 1444, 3.7028, 9437.7629, 1430, 3.4112, 10213.2855, 1125, 4.8282, 14143.4952, 1090, 2.0857, 6812.7668, 1037, 4.0566, 71092.8814, 971, 3.473, 4694.003, 915, 1.142, 6620.890, 878, 4.440, 5753.385, 837, 4.993, 7084.897, 770, 5.554, 167621.576, 719, 3.602, 529.691, 692, 4.326, 6275.962, 558, 4.410, 7860.419, 529, 2.484, 4705.732, 521, 6.250, 18073.705, 903, 3.897, 5507.553, 618, 1.730, 5223.694, 380, 5.244, 2352.866, 166, 1.627, 84334.662, 10001398880D, 0.00000000000, 0.00000000000, 167069963, 3.098463508, 6283.075849991, 1395602, 3.0552461, 12566.1517000, 308372, 5.198467, 77713.771468, 162846, 1.173877, 5753.384885, 157557, 2.846852, 7860.419392, 92480, 5.45292, 11506.76977, 54244, 4.56409, 3930.20970, 47211, 3.66100, 5884.92685, 34598, 0.96369, 5507.55324, 32878, 5.89984, 5223.69392, 30678, 0.29867, 5573.14280, 24319, 4.27350, 11790.62909, 21183, 5.84715, 1577.34354, 18575, 5.02194, 10977.07880, 17484, 3.01194, 18849.22755, 10984, 5.05511, 5486.77784, 9832, 0.8868, 6069.7768, 8650, 5.6896, 15720.8388, 8583, 1.2708, 161000.6857, 6490, 0.2725, 17260.1547, 6292, 0.9218, 529.6910, 5706, 2.0137, 83996.8473, 5574, 5.2416, 71430.6956, 4938, 3.2450, 2544.3144, 4696, 2.5781, 775.5226, 4466, 5.5372, 9437.7629, 4252, 6.0111, 6275.9623, 3897, 5.3607, 4694.0030, 3825, 2.3926, 8827.3903, 3749, 0.8295, 19651.0485, 3696, 4.9011, 12139.5535, 3566, 1.6747, 12036.4607, 3454, 1.8427, 2942.4634, 3319, 0.2437, 7084.8968, 3192, 0.1837, 5088.6288, 3185, 1.7778, 398.1490, 2846, 1.2134, 6286.5990, 2779, 1.8993, 6279.5527, 2628, 4.5890, 10447.3878, 2460, 3.7866, 8429.2413, 2393, 4.9960, 5856.4777, 2359, 0.2687, 796.2980, 2329, 2.8078, 14143.4952, 2210, 1.9500, 3154.6871, 2035, 4.6527, 2146.1654, 1951, 5.3823, 2352.8662, 1883, 0.6731, 149854.4001, 1833, 2.2535, 23581.2582, 1796, 0.1987, 6812.7668, 1731, 6.1520, 16730.4637, 1717, 4.4332, 10213.2855, 1619, 5.2316, 17789.8456, 1381, 5.1896, 8031.0923, 1364, 3.6852, 4705.7323, 1314, 0.6529, 13367.9726, 1041, 4.3329, 11769.8537, 1017, 1.5939, 4690.4798, 998, 4.201, 6309.374, 966, 3.676, 27511.468, 874, 6.064, 1748.016, 779, 3.674, 12168.003, 771, 0.312, 7632.943, 756, 2.626, 6256.778, 746, 5.648, 11926.254, 693, 2.924, 6681.225, 680, 1.423, 23013.540, 674, 0.563, 3340.612, 663, 5.661, 11371.705, 659, 3.136, 801.821, 648, 2.650, 19804.827, 615, 3.029, 233141.314, 612, 5.134, 1194.447, 563, 4.341, 90955.552, 552, 2.091, 17298.182, 534, 5.100, 31441.678, 531, 2.407, 11499.656, 523, 4.624, 6438.496, 513, 5.324, 11513.883, 477, 0.256, 11856.219, 461, 1.722, 7234.794, 458, 3.766, 6386.169, 458, 4.466, 5746.271, 423, 1.055, 5760.498, 422, 1.557, 7238.676, 415, 2.599, 7058.598, 401, 3.030, 1059.382, 397, 1.201, 1349.867, 379, 4.907, 4164.312, 360, 5.707, 5643.179, 352, 3.626, 244287.600, 348, 0.761, 10973.556, 342, 3.001, 4292.331, 336, 4.546, 4732.031, 334, 3.138, 6836.645, 324, 4.164, 9917.697, 316, 1.691, 11015.106, 307, 0.238, 35371.887, 298, 1.306, 6283.143, 298, 1.750, 6283.009, 293, 5.738, 16200.773, 286, 5.928, 14712.317, 281, 3.515, 21228.392, 280, 5.663, 8635.942, 277, 0.513, 26.298, 268, 4.207, 18073.705, 266, 0.900, 12352.853, 260, 2.962, 25132.303, 255, 2.477, 6208.294, 242, 2.800, 709.933, 231, 1.054, 22483.849, 229, 1.070, 14314.168, 216, 1.314, 154717.610, 215, 6.038, 10873.986, 200, 0.561, 7079.374, 198, 2.614, 951.718, 197, 4.369, 167283.762, 186, 2.861, 5216.580, 183, 1.660, 39302.097, 183, 5.912, 3738.761, 175, 2.145, 6290.189, 173, 2.168, 10575.407, 171, 3.702, 1592.596, 171, 1.343, 3128.389, 164, 5.550, 6496.375, 164, 5.856, 10984.192, 161, 1.998, 10969.965, 161, 1.909, 6133.513, 157, 4.955, 25158.602, 154, 6.216, 23543.231, 153, 5.357, 13521.751, 150, 5.770, 18209.330, 150, 5.439, 155.420, 139, 1.778, 9225.539, 139, 1.626, 5120.601, 128, 2.460, 13916.019, 123, 0.717, 143571.324, 122, 2.654, 88860.057, 121, 4.414, 3894.182, 121, 1.192, 3.523, 120, 4.030, 553.569, 119, 1.513, 17654.781, 117, 3.117, 14945.316, 113, 2.698, 6040.347, 110, 3.085, 43232.307, 109, 0.998, 955.600, 108, 2.939, 17256.632, 107, 5.285, 65147.620, 103, 0.139, 11712.955, 103, 5.850, 213.299, 102, 3.046, 6037.244, 101, 2.842, 8662.240, 100, 3.626, 6262.300, 98, 2.36, 6206.81, 98, 5.11, 6172.87, 98, 2.00, 15110.47, 97, 2.67, 5650.29, 97, 2.75, 6244.94, 96, 4.02, 6282.10, 96, 5.31, 6284.06, 92, 0.10, 29088.81, 85, 3.26, 20426.57, 84, 2.60, 28766.92, 81, 3.58, 10177.26, 80, 5.81, 5230.81, 78, 2.53, 16496.36, 77, 4.06, 6127.66, 73, 0.04, 5481.25, 72, 5.96, 12559.04, 72, 5.92, 4136.91, 71, 5.49, 22003.91, 70, 3.41, 7.11, 69, 0.62, 11403.68, 69, 3.90, 1589.07, 69, 1.96, 12416.59, 69, 4.51, 426.60, 67, 1.61, 11087.29, 66, 4.50, 47162.52, 66, 5.08, 283.86, 66, 4.32, 16858.48, 65, 1.04, 6062.66, 64, 1.59, 18319.54, 63, 5.70, 45892.73, 63, 4.60, 66567.49, 63, 3.82, 13517.87, 62, 2.62, 11190.38, 61, 1.54, 33019.02, 60, 5.58, 10344.30, 60, 5.38, 316428.23, 60, 5.78, 632.78, 59, 6.12, 9623.69, 57, 0.16, 17267.27, 57, 3.86, 6076.89, 57, 1.98, 7668.64, 56, 4.78, 20199.09, 55, 4.56, 18875.53, 55, 3.51, 17253.04, 54, 3.07, 226858.24, 54, 4.83, 18422.63, 53, 5.02, 12132.44, 52, 3.63, 5333.90, 52, 0.97, 155427.54, 51, 3.36, 20597.24, 50, 0.99, 11609.86, 50, 2.21, 1990.75, 48, 1.62, 12146.67, 48, 1.17, 12569.67, 47, 4.62, 5436.99, 47, 1.81, 12562.63, 47, 0.59, 21954.16, 47, 0.76, 7342.46, 46, 0.27, 4590.91, 46, 3.77, 156137.48, 45, 5.66, 10454.50, 44, 5.84, 3496.03, 43, 0.24, 17996.03, 41, 5.93, 51092.73, 41, 4.21, 12592.45, 40, 5.14, 1551.05, 40, 5.28, 15671.08, 39, 3.69, 18052.93, 39, 4.94, 24356.78, 38, 2.72, 11933.37, 38, 5.23, 7477.52, 38, 4.99, 9779.11, 37, 3.70, 9388.01, 37, 4.44, 4535.06, 36, 2.16, 28237.23, 36, 2.54, 242.73, 36, 0.22, 5429.88, 35, 6.15, 19800.95, 35, 2.92, 36949.23, 34, 5.63, 2379.16, 34, 5.73, 16460.33, 34, 5.11, 5849.36, 33, 6.19, 6268.85, 10301861, 1.10748970, 6283.07584999, 172124, 1.064423, 12566.151700, 70222, 3.14159, 0.00000, 3235, 1.0217, 18849.2275, 3080, 2.8435, 5507.5532, 2497, 1.3191, 5223.6939, 1849, 1.4243, 1577.3435, 1008, 5.9138, 10977.0788, 865, 1.420, 6275.962, 863, 0.271, 5486.778, 507, 1.686, 5088.629, 499, 6.014, 6286.599, 467, 5.987, 529.691, 440, 0.518, 4694.003, 410, 1.084, 9437.763, 387, 4.750, 2544.314, 375, 5.071, 796.298, 352, 0.023, 83996.847, 344, 0.949, 71430.696, 341, 5.412, 775.523, 322, 6.156, 2146.165, 286, 5.484, 10447.388, 284, 3.420, 2352.866, 255, 6.132, 6438.496, 252, 0.243, 398.149, 243, 3.092, 4690.480, 225, 3.689, 7084.897, 220, 4.952, 6812.767, 219, 0.420, 8031.092, 209, 1.282, 1748.016, 193, 5.314, 8429.241, 185, 1.820, 7632.943, 175, 3.229, 6279.553, 173, 1.537, 4705.732, 158, 4.097, 11499.656, 158, 5.539, 3154.687, 150, 3.633, 11513.883, 148, 3.222, 7234.794, 147, 3.653, 1194.447, 144, 0.817, 14143.495, 135, 6.151, 5746.271, 134, 4.644, 6836.645, 128, 2.693, 1349.867, 123, 5.650, 5760.498, 118, 2.577, 13367.973, 113, 3.357, 17789.846, 110, 4.497, 4292.331, 108, 5.828, 12036.461, 102, 5.621, 6256.778, 99, 1.14, 1059.38, 98, 0.66, 5856.48, 93, 2.32, 10213.29, 92, 0.77, 16730.46, 88, 1.50, 11926.25, 86, 1.42, 5753.38, 85, 0.66, 155.42, 81, 1.64, 6681.22, 80, 4.11, 951.72, 66, 4.55, 5216.58, 65, 0.98, 25132.30, 64, 4.19, 6040.35, 64, 0.52, 6290.19, 63, 1.51, 5643.18, 59, 6.18, 4164.31, 57, 2.30, 10973.56, 55, 2.32, 11506.77, 55, 2.20, 1592.60, 55, 5.27, 3340.61, 54, 5.54, 553.57, 53, 5.04, 9917.70, 53, 0.92, 11371.70, 52, 3.98, 17298.18, 52, 3.60, 10969.97, 49, 5.91, 3894.18, 49, 2.51, 6127.66, 48, 1.67, 12168.00, 46, 0.31, 801.82, 42, 3.70, 10575.41, 42, 4.05, 10984.19, 40, 2.17, 7860.42, 40, 4.17, 26.30, 38, 5.82, 7058.60, 37, 3.39, 6496.37, 36, 1.08, 6309.37, 36, 5.34, 7079.37, 34, 3.62, 11790.63, 32, 0.32, 16200.77, 31, 4.24, 3738.76, 29, 4.55, 11856.22, 29, 1.26, 8635.94, 27, 3.45, 5884.93, 26, 5.08, 10177.26, 26, 5.38, 21228.39, 24, 2.26, 11712.96, 24, 1.05, 242.73, 24, 5.59, 6069.78, 23, 3.63, 6284.06, 23, 1.64, 4732.03, 22, 3.46, 213.30, 21, 1.05, 3496.03, 21, 3.92, 13916.02, 21, 4.01, 5230.81, 20, 5.16, 12352.85, 20, 0.69, 1990.75, 19, 2.73, 6062.66, 19, 5.01, 11015.11, 18, 6.04, 6283.01, 18, 2.85, 7238.68, 18, 5.60, 6283.14, 18, 5.16, 17253.04, 18, 2.54, 14314.17, 17, 1.58, 7.11, 17, 0.98, 3930.21, 17, 4.75, 17267.27, 16, 2.19, 6076.89, 16, 2.19, 18073.70, 16, 6.12, 3.52, 16, 4.61, 9623.69, 16, 3.40, 16496.36, 15, 0.19, 9779.11, 15, 5.30, 13517.87, 15, 4.26, 3128.39, 15, 0.81, 709.93, 14, 0.50, 25158.60, 14, 4.38, 4136.91, 13, 0.98, 65147.62, 13, 3.31, 154717.61, 13, 2.11, 1589.07, 13, 1.92, 22483.85, 12, 6.03, 9225.54, 12, 1.53, 12559.04, 12, 5.82, 6282.10, 12, 5.61, 5642.20, 12, 2.38, 167283.76, 12, 0.39, 12132.44, 12, 3.98, 4686.89, 12, 5.81, 12569.67, 12, 0.56, 5849.36, 11, 0.45, 6172.87, 11, 5.80, 16858.48, 11, 6.22, 12146.67, 11, 2.27, 5429.88, 435939, 5.784551, 6283.075850, 12363, 5.57935, 12566.15170, 1234, 3.1416, 0.0000, 879, 3.628, 77713.771, 569, 1.870, 5573.143, 330, 5.470, 18849.228, 147, 4.480, 5507.553, 110, 2.842, 161000.686, 101, 2.815, 5223.694, 85, 3.11, 1577.34, 65, 5.47, 775.52, 61, 1.38, 6438.50, 50, 4.42, 6286.60, 47, 3.66, 7084.90, 46, 5.39, 149854.40, 42, 0.90, 10977.08, 40, 3.20, 5088.63, 35, 1.81, 5486.78, 32, 5.35, 3154.69, 30, 3.52, 796.30, 29, 4.62, 4690.48, 28, 1.84, 4694.00, 27, 3.14, 71430.70, 27, 6.17, 6836.65, 26, 1.42, 2146.17, 25, 2.81, 1748.02, 24, 2.18, 155.42, 23, 4.76, 7234.79, 21, 3.38, 7632.94, 21, 0.22, 4705.73, 20, 4.22, 1349.87, 20, 2.01, 1194.45, 20, 4.58, 529.69, 19, 1.59, 6309.37, 18, 5.70, 6040.35, 18, 6.03, 4292.33, 17, 2.90, 9437.76, 17, 2.00, 8031.09, 17, 5.78, 83996.85, 16, 0.05, 2544.31, 15, 0.95, 6127.66, 14, 0.36, 10447.39, 14, 1.48, 2352.87, 13, 0.77, 553.57, 13, 5.48, 951.72, 13, 5.27, 6279.55, 13, 3.76, 6812.77, 11, 5.41, 6256.78, 10, 0.68, 1592.60, 10, 4.95, 398.15, 10, 1.15, 3894.18, 10, 5.20, 244287.60, 10, 1.94, 11856.22, 9, 5.39, 25132.30, 8, 6.18, 1059.38, 8, 0.69, 8429.24, 8, 5.85, 242.73, 7, 5.26, 14143.50, 7, 0.52, 801.82, 6, 2.24, 8635.94, 6, 4.00, 13367.97, 6, 2.77, 90955.55, 6, 5.17, 7058.60, 5, 1.46, 233141.31, 5, 4.13, 7860.42, 5, 3.91, 26.30, 5, 3.89, 12036.46, 5, 5.58, 6290.19, 5, 5.54, 1990.75, 5, 0.83, 11506.77, 5, 6.22, 6681.22, 4, 5.26, 10575.41, 4, 1.91, 7477.52, 4, 0.43, 10213.29, 4, 1.09, 709.93, 4, 5.09, 11015.11, 4, 4.22, 88860.06, 4, 3.57, 7079.37, 4, 1.98, 6284.06, 4, 3.93, 10973.56, 4, 6.18, 9917.70, 4, 0.36, 10177.26, 4, 2.75, 3738.76, 4, 3.33, 5643.18, 4, 5.36, 25158.60, 14459, 4.27319, 6283.07585, 673, 3.917, 12566.152, 77, 0.00, 0.00, 25, 3.73, 18849.23, 4, 2.80, 6286.60, 386, 2.564, 6283.076, 31, 2.27, 12566.15, 5, 3.44, 5573.14, 2, 2.05, 18849.23, 1, 2.06, 77713.77, 1, 4.41, 161000.69, 1, 3.82, 149854.40, 1, 4.08, 6127.66, 1, 5.26, 6438.50, 9, 1.22, 6283.08, 1, 0.66, 12566.15};
  private static final double[] QI_KB = {1640650.479938, 15.21842500, 1642476.703182, 15.21874996, 1683430.515601, 15.218750011, 1752157.640664, 15.218749978, 1807675.003759, 15.218620279, 1883627.765182, 15.218612292, 1907369.128100, 15.218449176, 1936603.140413, 15.218425000, 1939145.524180, 15.218466998, 1947180.798300, 15.218524844, 1964362.041824, 15.218533526, 1987372.340971, 15.218513908, 1999653.819126, 15.218530782, 2007445.469786, 15.218535181, 2021324.917146, 15.218526248, 2047257.232342, 15.218519654, 2070282.898213, 15.218425000, 2073204.872850, 15.218515221, 2080144.500926, 15.218530782, 2086703.688963, 15.218523776, 2110033.182763, 15.218425000, 2111190.300888, 15.218425000, 2113731.271005, 15.218515671, 2120670.840263, 15.218425000, 2123973.309063, 15.218425000, 2125068.997336, 15.218477932, 2136026.312633, 15.218472436, 2156099.495538, 15.218425000, 2159021.324663, 15.218425000, 2162308.575254, 15.218461742, 2178485.706538, 15.218425000, 2178759.662849, 15.218445786, 2185334.020800, 15.218425000, 2187525.481425, 15.218425000, 2188621.191481, 15.218437494, 2322147.76};
  private static final String QB = "0000000000000200000001000000000000222000000000000000000000000000000000000000000000000000000000000000000000000200000001010000000000202002000000000000000000000000000000020000000000000020000000000000000000002000000000010000020000002002000000000000000010000000000000100100000000000020000010000000000020000000020000010000000002000002002000000000000000000000000100100101000000000020000000001000000020000000020000010000000002000002000000000000000000020000000000100101000200000020200000001000000020000000000000000000000002000000000000000000000000220000000000000010000200000000200000001000000000000000000000000000000002000200000000000000002000222000000000000010000000000000200000001000100000000000000000000000000000000200000001000000000000222000000000000010000000000000000000000000100000000000200000000000000000000200200001000000000000222002000000000000000000000000000000000000000000000020000000000000000000000200000000010000000000202002000000000000000000000000000000100000000000000020000010000000000000000000020000010000000000002002002000000000000000000000000000100100000000000020000000000000000020000000020000010000000002000002000000000000000001000000000000100101000000000020200000001000000020000000000000000000000002000000000000000000000000020000000000000101000200000020200000001000000020000000000000000000000002000200000000000000000000020000000000000001000200000000200000001000000000000000000000000000000002000200000000000000000000222000000000000010000000000000000000000000000000000000000000000000000000000200000001000000002000222000000000000000000000000000000000000000100000000000000000000000010000000200000000010000000000222002000000000000000000000000000000100000000000000020000010000000000000000200020000010000000000202002002000000000000000000000000100100000000000000020000000000000000000000000020000010000000000002002000000000000000000000000000000100100000000000020200000000000000000000000020000000000000002000002000000000000000000000000000000000100000000000020200000001000000020000000000000000000000002000000000000000000000000020000000000000111000000000000200000001000000020000000000000000000000002000200000000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000002000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000020000000000000000000000000000000200000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002000000000000010000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000020000002000000000000000000000000000000000000000000000000000000000010000000200000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000002000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000001000000002000000000000000000000000000000000100000000000000000000001000010000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000010000000000000000100100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002000000000000000000000000000000000000000000000100000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000001000010000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000000000000000000000000010000000000000000001000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100100000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000002000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
  /** 农历年 */
  private int year;
  /** 农历月，闰月为负，即闰2月=-2 */
  private int month;
  /** 农历日 */
  private int day;
  /** 对应阳历 */
  private Solar solar;
  /** 相对于基准日的偏移天数 */
  private int dayOffset;
  /** 时对应的天干下标，0-9 */
  private int timeGanIndex;
  /** 时对应的地支下标，0-11 */
  private int timeZhiIndex;
  /** 日对应的天干下标，0-9 */
  private int dayGanIndex;
  /** 日对应的地支下标，0-11 */
  private int dayZhiIndex;
  /** 日对应的天干下标（最精确的，供八字用，晚子时算第二天），0-9 */
  private int dayGanIndexExact;
  /** 日对应的地支下标（最精确的，供八字用，晚子时算第二天），0-11 */
  private int dayZhiIndexExact;
  /** 月对应的天干下标（以节交接当天起算），0-9 */
  private int monthGanIndex;
  /** 月对应的地支下标（以节交接当天起算），0-11 */
  private int monthZhiIndex;
  /** 月对应的天干下标（最精确的，供八字用，以节交接时刻起算），0-9 */
  private int monthGanIndexExact;
  /** 月对应的地支下标（最精确的，供八字用，以节交接时刻起算），0-11 */
  private int monthZhiIndexExact;
  /** 年对应的天干下标（国标，以正月初一为起点），0-9 */
  private int yearGanIndex;
  /** 年对应的地支下标（国标，以正月初一为起点），0-11 */
  private int yearZhiIndex;
  /** 年对应的天干下标（月干计算用，以立春为起点），0-9 */
  private int yearGanIndexByLiChun;
  /** 年对应的地支下标（月支计算用，以立春为起点），0-11 */
  private int yearZhiIndexByLiChun;
  /** 年对应的天干下标（最精确的，供八字用，以立春交接时刻为起点），0-9 */
  private int yearGanIndexExact;
  /** 年对应的地支下标（最精确的，供八字用，以立春交接时刻为起点），0-11 */
  private int yearZhiIndexExact;

  /** 周下标，0-6 */
  private int weekIndex;
  /** 阳历小时 */
  private int hour;
  /** 阳历分钟 */
  private int minute;
  /** 阳历秒钟 */
  private int second;
  /** 八字 */
  private EightChar eightChar;
  /** 24节气表（对应阳历的准确时刻） */
  private Map<String,Solar> jieQi = new LinkedHashMap<String, Solar>();

  /**
   * 默认使用当前日期初始化
   */
  public Lunar(){
    this(new Date());
  }

  /**
   * 通过农历年月日初始化
   *
   * @param lunarYear 年（农历）
   * @param lunarMonth 月（农历），1到12，闰月为负，即闰2月=-2
   * @param lunarDay 日（农历），1到30
   */
  public Lunar(int lunarYear,int lunarMonth,int lunarDay){
    this(lunarYear,lunarMonth,lunarDay,0,0,0);
  }

  /**
   * 通过农历年月日时初始化
   *
   * @param lunarYear 年（农历）
   * @param lunarMonth 月（农历），1到12，闰月为负，即闰2月=-2
   * @param lunarDay 日（农历），1到30
   * @param hour 小时（阳历）
   * @param minute 分钟（阳历）
   * @param second 秒钟（阳历）
   */
  public Lunar(int lunarYear,int lunarMonth,int lunarDay,int hour,int minute,int second){
    int m = Math.abs(lunarMonth);
    if(m<1||m>12){
      throw new IllegalArgumentException("lunar month must between 1 and 12, or negative");
    }
    if(lunarMonth<0){
      int leapMonth = LunarUtil.getLeapMonth(lunarYear);
      if(leapMonth==0){
        throw new IllegalArgumentException(String.format("no leap month in lunar year %d",lunarYear));
      }else if(leapMonth!=m){
        throw new IllegalArgumentException(String.format("leap month is %d in lunar year %d",leapMonth,lunarYear));
      }
    }
    if(lunarDay<1||lunarDay>30){
      throw new IllegalArgumentException("lunar day must between 1 and 30");
    }
    int days = LunarUtil.getDaysOfMonth(lunarYear,lunarMonth);
    if(lunarDay>days){
      throw new IllegalArgumentException(String.format("only %d days in lunar year %d month %d",days,lunarYear,lunarMonth));
    }
    this.year = lunarYear;
    this.month = lunarMonth;
    this.day = lunarDay;
    this.hour = hour;
    this.minute = minute;
    this.second = second;
    dayOffset = LunarUtil.computeAddDays(year,month,day);
    this.solar = toSolar();
    compute();
  }

  /**
   * 通过阳历日期初始化
   * @param date 阳历日期
   */
  public Lunar(Date date){
    solar = new Solar(date);
    int y = solar.getYear();
    int m = solar.getMonth();
    int d = solar.getDay();
    int startYear,startMonth,startDay;
    int lunarYear,lunarMonth,lunarDay;
    if(y<2000){
      startYear = SolarUtil.BASE_YEAR;
      startMonth = SolarUtil.BASE_MONTH;
      startDay = SolarUtil.BASE_DAY;
      lunarYear = LunarUtil.BASE_YEAR;
      lunarMonth = LunarUtil.BASE_MONTH;
      lunarDay = LunarUtil.BASE_DAY;
    }else{
      startYear = SolarUtil.BASE_YEAR+99;
      startMonth = 1;
      startDay = 1;
      lunarYear = LunarUtil.BASE_YEAR+99;
      lunarMonth = 11;
      lunarDay = 25;
    }
    int diff = 0;
    for(int i=startYear;i<y;i++){
      diff += 365;
      if(SolarUtil.isLeapYear(i)){
        diff += 1;
      }
    }
    for(int i=startMonth;i<m;i++){
      diff += SolarUtil.getDaysOfMonth(y,i);
    }
    diff += d-startDay;
    lunarDay += diff;
    int lastDate = LunarUtil.getDaysOfMonth(lunarYear,lunarMonth);
    while(lunarDay>lastDate){
      lunarDay -= lastDate;
      lunarMonth = LunarUtil.nextMonth(lunarYear,lunarMonth);
      if(lunarMonth==1){
        lunarYear++;
      }
      lastDate = LunarUtil.getDaysOfMonth(lunarYear,lunarMonth);
    }
    year = lunarYear;
    month = lunarMonth;
    day = lunarDay;
    hour = solar.getHour();
    minute = solar.getMinute();
    second = solar.getSecond();
    dayOffset = LunarUtil.computeAddDays(year,month,day);
    compute();
  }

  private double nutationLon2(double t) {
    double a, t2 = t * t, dl = 0;
    for (int i = 0, j = NUT_B.length; i < j; i += 5) {
      if (i == 0) {
        a = -1.742 * t;
      } else {
        a = 0;
      }
      dl += (NUT_B[i + 3] + a) * Math.sin(NUT_B[i] + NUT_B[i + 1] * t + NUT_B[i + 2] * t2);
    }
    return dl / 100 / SECOND_PER_RAD;
  }

  private double eLon(double t, int n) {
    t /= 10;
    double v = 0, tn = 1;
    int n1,n2;
    double m;
    double c;
    int pn = 1;
    double n0, m0 = XL0[pn + 1] - XL0[pn];
    for (int i = 0; i < 6; i++, tn *= t) {
      n1 = (int)XL0[pn + i];
      n2 = (int)XL0[pn + 1 + i];
      n0 = n2 - n1;
      if (n0 == 0) {
        continue;
      }
      if (n < 0) {
        m = n2;
      } else {
        m = (int)(3 * n * n0 / m0 + 0.5) + n1;
        if (i != 0) {
          m += 3;
        }
        if (m > n2) {
          m = n2;
        }
      }
      c = 0;
      for (int j = n1; j < m; j += 3) {
        c += XL0[j] * Math.cos(XL0[j + 1] + t * XL0[j + 2]);
      }
      v += c * tn;
    }
    v /= XL0[0];
    double t2 = t * t, t3 = t2 * t;
    v += (-0.0728 - 2.7702 * t - 1.1019 * t2 - 0.0996 * t3) / SECOND_PER_RAD;
    return v;
  }

  private double gxcSunLon(double t) {
    double v = -0.043126 + 628.301955 * t - 0.000002732 * t * t;
    double e = 0.016708634 - 0.000042037 * t - 0.0000001267 * t * t;
    return -20.49552 * (1 + e * Math.cos(v)) / SECOND_PER_RAD;
  }

  private double ev(double t){
    double f = 628.307585 * t;
    return 628.332 + 21 * Math.sin(1.527 + f) + 0.44 * Math.sin(1.48 + f * 2) + 0.129 * Math.sin(5.82 + f) * t + 0.00055 * Math.sin(4.21 + f) * t * t;
  }

  private double saLon(double t,int n){
    return eLon(t, n) + nutationLon2(t) + gxcSunLon(t) + Math.PI;
  }

  private double dtExt(double y, double jsd){
    double dy = (y - 1820) / 100;
    return - 20 + jsd * dy * dy;
  }

  private double dtCalc(double y) {
    int size = DT_AT.length;
    double y0 = DT_AT[size - 2];
    double t0 = DT_AT[size - 1];
    if (y >= y0) {
      double jsd = 31;
      if (y > y0 + 100) {
        return dtExt(y, jsd);
      }
      double v = dtExt(y, jsd);
      double dv = dtExt(y0, jsd) - t0;
      return v - dv * (y0 + 100 - y) / 100;
    }
    int i;
    for (i = 0; i < size; i += 5) {
      if (y < DT_AT[i + 5]) {
        break;
      }
    }
    double t1 = (y - DT_AT[i]) / (DT_AT[i + 5] - DT_AT[i]) * 10, t2 = t1 * t1, t3 = t2 * t1;
    return DT_AT[i + 1] + DT_AT[i + 2] * t1 + DT_AT[i + 3] * t2 + DT_AT[i + 4] * t3;
  }

  private double dtT(double t){
    return dtCalc(t / 365.2425 + 2000) / 86400.0;
  }

  private double saLonT(double w){
    double t, v = 628.3319653318;
    t = (w - 1.75347 - Math.PI) / v;
    v = ev(t);
    t += (w - saLon(t, 10)) / v;
    v = ev(t);
    t += (w - saLon(t, -1)) / v;
    return t;
  }

  private double qiLow(double w){
    double t, l, v = 628.3319653318;
    t = (w - 4.895062166) / v;
    t -= (53 * t * t + 334116 * Math.cos(4.67 + 628.307585 * t) + 2061 * Math.cos(2.678 + 628.3076 * t) * t) / v / 10000000;
    l = 48950621.66 + 6283319653.318 * t + 53 * t * t + 334166 * Math.cos(4.669257 + 628.307585 * t) + 3489 * Math.cos(4.6261 + 1256.61517 * t) + 2060.6 * Math.cos(2.67823 + 628.307585 * t) * t - 994 - 834 * Math.sin(2.1824 - 33.75705 * t);
    t -= (l / 10000000 - w) / 628.332 + (32 * (t + 1.8) * (t + 1.8) - 20) / 86400 / 36525;
    return t * 36525 + 8D / 24;
  }

  private double saLonT2(double w){
    double t, v = 628.3319653318;
    t = (w - 1.75347 - Math.PI) / v;
    t -= (0.000005297 * t * t + 0.0334166 * Math.cos(4.669257 + 628.307585 * t) + 0.0002061 * Math.cos(2.67823 + 628.307585 * t) * t) / v;
    t += (w - eLon(t, 8) - Math.PI + (20.5 + 17.2 * Math.sin(2.1824 - 33.75705 * t)) / SECOND_PER_RAD) / v;
    return t;
  }

  private double qiHigh(double w){
    double t = saLonT2(w) * 36525;
    t = t - dtT(t) + 8D / 24;
    double v = ((t + 0.5) % 1) * 86400;
    if (v < 1200 || v > 86400 - 1200){
      t = saLonT(w) * 36525 - dtT(t) + 8D / 24;
    }
    return t;
  }

  private double calcJieQi(double jd) {
    int size = QI_KB.length;
    double d = 0;
    int pc = 7;
    jd += 2451545;
    double f1 = QI_KB[0] - pc, f2 = QI_KB[size - 1] - pc, f3 = 2436935;
    if (jd < f1 || jd >= f3) {
      d = Math.floor(qiHigh(Math.floor((jd + pc - 2451259) * 24D / 365.2422) * Math.PI / 12) + 0.5);
    }else if (jd >= f1 && jd < f2) {
      int i = 0;
      for (; i < size; i += 2) {
        if (jd + pc < QI_KB[i + 2]) {
          break;
        }
      }
      d = QI_KB[i] + QI_KB[i + 1] * Math.floor((jd + pc - QI_KB[i]) / QI_KB[i + 1]);
      d = Math.floor(d + 0.5);
      if (d == 1683460) {
        d++;
      }
      d -= 2451545;
    }else if (jd >= f2 && jd < f3) {
      d = Math.floor(qiLow(Math.floor((jd + pc - 2451259) * 24D / 365.2422) * Math.PI / 12) + 0.5);
      int from = (int) ((jd - f2) / 365.2422 * 24);
      String n = QB.substring(from, from + 1);
      if ("1".equals(n)) {
        d += 1;
      }
      if ("2".equals(n)) {
        d -= 1;
      }
    }
    return d;
  }

  private double qiAccurate(double w){
    double t = saLonT(w) * 36525;
    return t - dtT(t) + 8D / 24;
  }

  private double qiAccurate2(double jd) {
    double d = Math.PI / 12;
    double w = Math.floor((jd + 293) * 24 / 365.2422) * d;
    double a = qiAccurate(w);
    if (a - jd > 5){
      return qiAccurate(w - d);
    }else if (a - jd < -5){
      return qiAccurate(w + d);
    }
    return a;
  }

  /**
   * 计算节气表
   */
  private void computeJieQi(){
    double jd = Math.floor((solar.getYear() - 2000) * 365.2422 + 180);
    double w = Math.floor((jd - 355 + 183) / 365.2422) * 365.2422 + 355;
    if (calcJieQi(w) > jd){
      w -= 365.2422;
    }
    //追加上一农历年末的大雪
    double q = calcJieQi(w - 15.2184);
    jieQi.put(JIE_QI_PREPEND, Solar.fromJulianDay(qiAccurate2(q) + Solar.J2000));
    int size = JIE_QI.length;
    for (int i=0;i<size;i++) {
      q = calcJieQi(w + 15.2184 * i);
      jieQi.put(JIE_QI[i], Solar.fromJulianDay(qiAccurate2(q) + Solar.J2000));
    }
    //追加下一农历年初的冬至
    q = calcJieQi(w + 15.2184 * size);
    jieQi.put(JIE_QI_APPEND, Solar.fromJulianDay(qiAccurate2(q) + Solar.J2000));

    //追加下一阳历年初的小寒
    size++;
    q = calcJieQi(w + 15.2184 * size);
    jieQi.put(JIE_APPEND_SOLAR_FIRST, Solar.fromJulianDay(qiAccurate2(q) + Solar.J2000));

    //追加下一阳历年初的大寒
    size++;
    q = calcJieQi(w + 15.2184 * size);
    jieQi.put(QI_APPEND_SOLAR_SECOND, Solar.fromJulianDay(qiAccurate2(q) + Solar.J2000));
  }

  /**
   * 计算干支纪年
   */
  private void computeYear(){
    //以正月初一开始
    yearGanIndex = (year+LunarUtil.BASE_YEAR_GANZHI_INDEX)%10;
    yearZhiIndex = (year+LunarUtil.BASE_YEAR_GANZHI_INDEX)%12;

    //以立春作为新一年的开始的干支纪年
    int g = yearGanIndex;
    int z = yearZhiIndex;

    //精确的干支纪年，以立春交接时刻为准
    int gExact = yearGanIndex;
    int zExact = yearZhiIndex;

    //获取立春的阳历时刻
    Solar liChun = jieQi.get("立春");

    //阳历和阴历年份相同代表正月初一及以后
    if(year==solar.getYear()){
      //立春日期判断
      if(solar.toYmd().compareTo(liChun.toYmd())<0) {
        g--;
        z--;
      }
      //立春交接时刻判断
      if(solar.toYmdHms().compareTo(liChun.toYmdHms())<0) {
        gExact--;
        zExact--;
      }
    }else{
      if(solar.toYmd().compareTo(liChun.toYmd())>=0) {
        g++;
        z++;
      }
      if(solar.toYmdHms().compareTo(liChun.toYmdHms())>=0) {
        gExact++;
        zExact++;
      }
    }

    if(g<0){
      g += 10;
    }
    if(g>=10){
      g-=10;
    }
    if(z<0){
      z += 12;
    }
    if(z>=12){
      z-=12;
    }
    if(gExact<0){
      gExact += 10;
    }
    if(gExact>=10){
      gExact-=10;
    }
    if(zExact<0){
      zExact += 12;
    }
    if(zExact>=12){
      zExact-=12;
    }

    yearGanIndexByLiChun = g;
    yearZhiIndexByLiChun = z;

    yearGanIndexExact = gExact;
    yearZhiIndexExact = zExact;
  }

  /**
   * 干支纪月计算
   */
  private void computeMonth(){
    Solar start = null;
    Solar end;
    //干偏移值（以立春当天起算）
    int gOffset = ((yearGanIndexByLiChun%5+1)*2)%10;
    //干偏移值（以立春交接时刻起算）
    int gOffsetExact = ((yearGanIndexExact%5+1)*2)%10;

    //序号：大雪到小寒之间-2，小寒到立春之间-1，立春之后0
    int index = -2;
    for(String jie:LunarUtil.JIE){
      end = jieQi.get(jie);
      String ymd = solar.toYmd();
      String symd = null==start?ymd:start.toYmd();
      String eymd = end.toYmd();
      if(ymd.compareTo(symd)>=0&&ymd.compareTo(eymd)<0){
        break;
      }
      start = end;
      index++;
    }
    if(index<0){
      index += 12;
    }

    monthGanIndex = (index+gOffset)%10;
    monthZhiIndex = (index+LunarUtil.BASE_MONTH_ZHI_INDEX)%12;

    //序号：大雪到小寒之间-2，小寒到立春之间-1，立春之后0
    int indexExact = -2;
    for(String jie:LunarUtil.JIE){
      end = jieQi.get(jie);
      String time = solar.toYmdHms();
      String stime = null==start?time:start.toYmdHms();
      String etime = end.toYmdHms();
      if(time.compareTo(stime)>=0&&time.compareTo(etime)<0){
        break;
      }
      start = end;
      indexExact++;
    }
    if(indexExact<0){
      indexExact += 12;
    }
    monthGanIndexExact = (indexExact+gOffsetExact)%10;
    monthZhiIndexExact = (indexExact+LunarUtil.BASE_MONTH_ZHI_INDEX)%12;
  }

  /**
   * 干支纪日计算
   */
  private void computeDay(){
    int addDays = (dayOffset + LunarUtil.BASE_DAY_GANZHI_INDEX)%60;
    dayGanIndex = addDays%10;
    dayZhiIndex = addDays%12;

    int dayGanExact = dayGanIndex;
    int dayZhiExact = dayZhiIndex;

    // 晚子时（夜子/子夜）应算作第二天
    String hm = (hour<10?"0":"")+hour+":"+(minute<10?"0":"")+minute;
    if(hm.compareTo("23:00")>=0&&hm.compareTo("23:59")<=0){
      dayGanExact++;
      if(dayGanExact>=10){
        dayGanExact -= 10;
      }
      dayZhiExact++;
      if(dayZhiExact>=12){
        dayZhiExact -= 12;
      }
    }

    dayGanIndexExact = dayGanExact;
    dayZhiIndexExact = dayZhiExact;
  }

  /**
   * 干支纪时计算
   */
  private void computeTime(){
    String hm = (hour<10?"0":"")+hour+":"+(minute<10?"0":"")+minute;
    timeZhiIndex = LunarUtil.getTimeZhiIndex(hm);
    timeGanIndex = (dayGanIndexExact%5*2+timeZhiIndex)%10;
  }

  /**
   * 星期计算
   */
  private void computeWeek(){
    weekIndex = (dayOffset+LunarUtil.BASE_WEEK_INDEX)%7;
  }

  private void compute(){
    computeJieQi();
    computeYear();
    computeMonth();
    computeDay();
    computeTime();
    computeWeek();
  }

  /**
   * 通过指定阳历日期获取农历
   *
   * @param date 阳历日期
   * @return 农历
   */
  public static Lunar fromDate(Date date){
    return new Lunar(date);
  }

  /**
   * 通过指定农历年月日获取农历
   *
   * @param lunarYear 年（农历）
   * @param lunarMonth 月（农历），1到12，闰月为负，即闰2月=-2
   * @param lunarDay 日（农历），1到31
   * @return 农历
   */
  public static Lunar fromYmd(int lunarYear,int lunarMonth,int lunarDay){
    return new Lunar(lunarYear,lunarMonth,lunarDay);
  }

  /**
   * 通过指定农历年月日获取农历
   *
   * @param lunarYear 年（农历）
   * @param lunarMonth 月（农历），1到12，闰月为负，即闰2月=-2
   * @param lunarDay 日（农历），1到31
   * @param hour 小时（阳历）
   * @param minute 分钟（阳历）
   * @param second 秒钟（阳历）
   * @return 农历
   */
  public static Lunar fromYmdHms(int lunarYear,int lunarMonth,int lunarDay,int hour,int minute,int second){
    return new Lunar(lunarYear,lunarMonth,lunarDay,hour,minute,second);
  }

  /**
   * 获取年份的天干（以正月初一作为新年的开始）
   *
   * @return 天干，如辛
   * @deprecated 使用getYearGan
   */
  @Deprecated
  public String getGan(){
    return getYearGan();
  }

  /**
   * 获取年份的天干（以正月初一作为新年的开始）
   *
   * @return 天干，如辛
   */
  public String getYearGan(){
    return LunarUtil.GAN[yearGanIndex+1];
  }

  /**
   * 获取年份的天干（以立春当天作为新年的开始）
   *
   * @return 天干，如辛
   */
  public String getYearGanByLiChun(){
    return LunarUtil.GAN[yearGanIndexByLiChun+1];
  }

  /**
   * 获取最精确的年份天干（以立春交接的时刻作为新年的开始）
   *
   * @return 天干，如辛
   */
  public String getYearGanExact(){
    return LunarUtil.GAN[yearGanIndexExact+1];
  }

  /**
   * 获取年份的地支（以正月初一作为新年的开始）
   *
   * @return 地支，如亥
   * @deprecated 使用getYearZhi
   */
  @Deprecated
  public String getZhi(){
    return getYearZhi();
  }

  /**
   * 获取年份的地支（以正月初一作为新年的开始）
   *
   * @return 地支，如亥
   */
  public String getYearZhi(){
    return LunarUtil.ZHI[yearZhiIndex+1];
  }

  /**
   * 获取年份的地支（以立春当天作为新年的开始）
   *
   * @return 地支，如亥
   */
  public String getYearZhiByLiChun(){
    return LunarUtil.ZHI[yearZhiIndexByLiChun+1];
  }

  /**
   * 获取最精确的年份地支（以立春交接的时刻作为新年的开始）
   *
   * @return 地支，如亥
   */
  public String getYearZhiExact(){
    return LunarUtil.ZHI[yearZhiIndexExact+1];
  }

  /**
   * 获取干支纪年（年柱）（以正月初一作为新年的开始）
   * @return 年份的干支（年柱），如辛亥
   */
  public String getYearInGanZhi(){
    return getYearGan()+getYearZhi();
  }

  /**
   * 获取干支纪年（年柱）（以立春当天作为新年的开始）
   * @return 年份的干支（年柱），如辛亥
   */
  public String getYearInGanZhiByLiChun(){
    return getYearGanByLiChun()+getYearZhiByLiChun();
  }

  /**
   * 获取干支纪年（年柱）（以立春交接的时刻作为新年的开始）
   * @return 年份的干支（年柱），如辛亥
   */
  public String getYearInGanZhiExact(){
    return getYearGanExact()+getYearZhiExact();
  }

  /**
   * 获取干支纪月（月柱）（以节交接当天起算）
   * <p>月天干口诀：甲己丙寅首，乙庚戊寅头。丙辛从庚寅，丁壬壬寅求，戊癸甲寅居，周而复始流。</p>
   * <p>月地支：正月起寅</p>
   *
   * @return 干支纪月（月柱），如己卯
   */
  public String getMonthInGanZhi(){
    return getMonthGan()+getMonthZhi();
  }

  /**
   * 获取精确的干支纪月（月柱）（以节交接时刻起算）
   * <p>月天干口诀：甲己丙寅首，乙庚戊寅头。丙辛从庚寅，丁壬壬寅求，戊癸甲寅居，周而复始流。</p>
   * <p>月地支：正月起寅</p>
   *
   * @return 干支纪月（月柱），如己卯
   */
  public String getMonthInGanZhiExact(){
    return getMonthGanExact()+getMonthZhiExact();
  }

  /**
   * 获取月天干（以节交接当天起算）
   * @return 月天干，如己
   */
  public String getMonthGan(){
    return LunarUtil.GAN[monthGanIndex+1];
  }

  /**
   * 获取精确的月天干（以节交接时刻起算）
   * @return 月天干，如己
   */
  public String getMonthGanExact(){
    return LunarUtil.GAN[monthGanIndexExact+1];
  }

  /**
   * 获取月地支（以节交接当天起算）
   * @return 月地支，如卯
   */
  public String getMonthZhi(){
    return LunarUtil.ZHI[monthZhiIndex+1];
  }

  /**
   * 获取精确的月地支（以节交接时刻起算）
   * @return 月地支，如卯
   */
  public String getMonthZhiExact(){
    return LunarUtil.ZHI[monthZhiIndexExact+1];
  }

  /**
   * 获取干支纪日（日柱）
   *
   * @return 干支纪日（日柱），如己卯
   */
  public String getDayInGanZhi(){
    return getDayGan()+getDayZhi();
  }

  /**
   * 获取干支纪日（日柱，晚子时算第二天）
   *
   * @return 干支纪日（日柱），如己卯
   */
  public String getDayInGanZhiExact(){
    return getDayGanExact()+getDayZhiExact();
  }

  /**
   * 获取日天干
   *
   * @return 日天干，如甲
   */
  public String getDayGan(){
    return LunarUtil.GAN[dayGanIndex+1];
  }

  /**
   * 获取日天干（晚子时算第二天）
   *
   * @return 日天干，如甲
   */
  public String getDayGanExact(){
    return LunarUtil.GAN[dayGanIndexExact+1];
  }

  /**
   * 获取日地支
   *
   * @return 日地支，如卯
   */
  public String getDayZhi(){
    return LunarUtil.ZHI[dayZhiIndex+1];
  }

  /**
   * 获取日地支（晚子时算第二天）
   *
   * @return 日地支，如卯
   */
  public String getDayZhiExact(){
    return LunarUtil.ZHI[dayZhiIndexExact+1];
  }

  /**
   * 获取年生肖
   *
   * @return 年生肖，如虎
   * @deprecated 使用getYearShengXiao
   */
  @Deprecated
  public String getShengxiao(){
    return getYearShengXiao();
  }

  /**
   * 获取年生肖（以正月初一起算）
   *
   * @return 年生肖，如虎
   */
  public String getYearShengXiao(){
    return LunarUtil.SHENGXIAO[yearZhiIndex+1];
  }

  /**
   * 获取年生肖（以立春当天起算）
   *
   * @return 年生肖，如虎
   */
  public String getYearShengXiaoByLiChun(){
    return LunarUtil.SHENGXIAO[yearZhiIndexByLiChun+1];
  }

  /**
   * 获取精确的年生肖（以立春交接时刻起算）
   *
   * @return 年生肖，如虎
   */
  public String getYearShengXiaoExact(){
    return LunarUtil.SHENGXIAO[yearZhiIndexExact+1];
  }

  /**
   * 获取月生肖
   *
   * @return 月生肖，如虎
   */
  public String getMonthShengXiao(){
    return LunarUtil.SHENGXIAO[monthZhiIndex+1];
  }

  /**
   * 获取日生肖
   *
   * @return 日生肖，如虎
   */
  public String getDayShengXiao(){
    return LunarUtil.SHENGXIAO[dayZhiIndex+1];
  }

  /**
   * 获取时辰生肖
   *
   * @return 时辰生肖，如虎
   */
  public String getTimeShengXiao(){
    return LunarUtil.SHENGXIAO[timeZhiIndex+1];
  }

  /**
   * 获取中文的年
   *
   * @return 中文年，如二零零一
   */
  public String getYearInChinese(){
    String y = (year+"");
    StringBuilder s = new StringBuilder();
    for(int i=0,j=y.length();i<j;i++){
      s.append(LunarUtil.NUMBER[y.charAt(i)-'0']);
    }
    return s.toString();
  }

  /**
   * 获取中文的月
   *
   * @return 中文月，如正
   */
  public String getMonthInChinese(){
    return (month<0?"闰":"")+LunarUtil.MONTH[Math.abs(month)];
  }

  /**
   * 获取中文日
   *
   * @return 中文日，如初一
   */
  public String getDayInChinese(){
    return LunarUtil.DAY[day];
  }

  /**
   * 获取时辰（地支）
   * @return 时辰（地支）
   */
  public String getTimeZhi(){
    return LunarUtil.ZHI[timeZhiIndex+1];
  }

  /**
   * 获取时辰（天干）
   * @return 时辰（天干）
   */
  public String getTimeGan(){
    return LunarUtil.GAN[timeGanIndex+1];
  }

  /**
   * 获取时辰干支（时柱），支持早子时和晚子时
   * @return 时辰干支（时柱）
   */
  public String getTimeInGanZhi(){
    return getTimeGan()+getTimeZhi();
  }

  /**
   * 获取季节
   * @return 农历季节
   */
  public String getSeason(){
    return LunarUtil.SEASON[Math.abs(month)];
  }

  /**
   * 获取节令
   *
   * @return 节令
   */
  public String getJie(){
    for(String jie:LunarUtil.JIE){
      Solar d = jieQi.get(jie);
      if(d.getYear()==solar.getYear()&&d.getMonth()==solar.getMonth()&&d.getDay()==solar.getDay()){
        return jie;
      }
    }
    // 追加的节令：大雪
    Solar d = jieQi.get(JIE_QI_PREPEND);
    if(d.getYear()==solar.getYear()&&d.getMonth()==solar.getMonth()&&d.getDay()==solar.getDay()){
      return JIE_QI_LAST;
    }
    // 追加的节令：小寒
    d = jieQi.get(JIE_APPEND_SOLAR_FIRST);
    if(d.getYear()==solar.getYear()&&d.getMonth()==solar.getMonth()&&d.getDay()==solar.getDay()){
      return JIE_SOLAR_FIRST;
    }
    return "";
  }

  /**
   * 获取气令
   *
   * @return 气令
   */
  public String getQi(){
    for(String qi:LunarUtil.QI){
      Solar d = jieQi.get(qi);
      if(d.getYear()==solar.getYear()&&d.getMonth()==solar.getMonth()&&d.getDay()==solar.getDay()){
        return qi;
      }
    }
    // 追加的气令：冬至
    Solar d = jieQi.get(JIE_QI_APPEND);
    if(d.getYear()==solar.getYear()&&d.getMonth()==solar.getMonth()&&d.getDay()==solar.getDay()){
      return JIE_QI_FIRST;
    }
    // 追加的气令：大寒
    d = jieQi.get(QI_APPEND_SOLAR_SECOND);
    if(d.getYear()==solar.getYear()&&d.getMonth()==solar.getMonth()&&d.getDay()==solar.getDay()){
      return QI_SOLAR_SECOND;
    }
    return "";
  }

  /**
   * 获取星期，0代表周日，1代表周一
   *
   * @return 0123456
   */
  public int getWeek(){
    return weekIndex;
  }

  /**
   * 获取星期的中文
   *
   * @return 日一二三四五六
   */
  public String getWeekInChinese(){
    return SolarUtil.WEEK[getWeek()];
  }

  /**
   * 获取宿
   *
   * @return 宿
   */
  public String getXiu(){
    return LunarUtil.XIU.get(getDayZhi()+getWeek());
  }

  /**
   * 获取宿吉凶
   *
   * @return 吉/凶
   */
  public String getXiuLuck(){
    return LunarUtil.XIU_LUCK.get(getXiu());
  }

  /**
   * 获取宿歌诀
   *
   * @return 宿歌诀
   */
  public String getXiuSong(){
    return LunarUtil.XIU_SONG.get(getXiu());
  }

  /**
   * 获取政
   *
   * @return 政
   */
  public String getZheng(){
    return LunarUtil.ZHENG.get(getXiu());
  }

  /**
   * 获取动物
   * @return 动物
   */
  public String getAnimal(){
    return LunarUtil.ANIMAL.get(getXiu());
  }

  /**
   * 获取宫
   * @return 宫
   */
  public String getGong(){
    return LunarUtil.GONG.get(getXiu());
  }

  /**
   * 获取兽
   * @return 兽
   */
  public String getShou(){
    return LunarUtil.SHOU.get(getGong());
  }

  /**
   * 获取节日，有可能一天会有多个节日
   *
   * @return 节日列表，如春节
   */
  public List<String> getFestivals(){
    List<String> l = new ArrayList<String>();
    String f = LunarUtil.FESTIVAL.get(month+"-"+day);
    if(null!=f){
      l.add(f);
    }
    return l;
  }

  /**
   * 获取非正式的节日，有可能一天会有多个节日
   *
   * @return 非正式的节日列表，如中元节
   */
  public List<String> getOtherFestivals(){
    List<String> l = new ArrayList<String>();
    List<String> fs = LunarUtil.OTHER_FESTIVAL.get(month+"-"+day);
    if(null!=fs){
      l.addAll(fs);
    }
    return l;
  }

  /**
   * 转换为阳历日期
   *
   * @return 阳历日期
   */
  private Solar toSolar(){
    Calendar c = Calendar.getInstance();
    c.set(SolarUtil.BASE_YEAR,SolarUtil.BASE_MONTH-1,SolarUtil.BASE_DAY,hour,minute,second);
    c.add(Calendar.DATE,dayOffset);
    return new Solar(c);
  }

  /**
   * 获取彭祖百忌天干
   * @return 彭祖百忌天干
   */
  public String getPengZuGan(){
    return LunarUtil.PENGZU_GAN[dayGanIndex+1];
  }

  /**
   * 获取彭祖百忌地支
   * @return 彭祖百忌地支
   */
  public String getPengZuZhi(){
    return LunarUtil.PENGZU_ZHI[dayZhiIndex+1];
  }

  /**
   * 获取日喜神方位
   * @return 喜神方位，如艮
   * @deprecated 使用getDayPositionXi
   */
  public String getPositionXi(){
    return getDayPositionXi();
  }

  /**
   * 获取喜神方位描述
   * @return 喜神方位描述，如东北
   * @deprecated 使用getDayPositionXiDesc
   */
  public String getPositionXiDesc(){
    return getDayPositionXiDesc();
  }

  /**
   * 获取阳贵神方位
   * @return 阳贵神方位，如艮
   * @deprecated 使用getDayPositionYangGui
   */
  public String getPositionYangGui(){
    return getDayPositionYangGui();
  }

  /**
   * 获取阳贵神方位描述
   * @return 阳贵神方位描述，如东北
   * @deprecated 使用getDayPositionYangGuiDesc
   */
  public String getPositionYangGuiDesc(){
    return getDayPositionYangGuiDesc();
  }

  /**
   * 获取阴贵神方位
   * @return 阴贵神方位，如艮
   * @deprecated 使用getDayPositionYinGui
   */
  public String getPositionYinGui(){
    return getDayPositionYinGui();
  }

  /**
   * 获取阴贵神方位描述
   * @return 阴贵神方位描述，如东北
   * @deprecated 使用getDayPositionYinGuiDesc
   */
  public String getPositionYinGuiDesc(){
    return getDayPositionYinGuiDesc();
  }

  /**
   * 获取福神方位
   * @return 福神方位，如艮
   * @deprecated 使用getDayPositionFu
   */
  public String getPositionFu(){
    return getDayPositionFu();
  }

  /**
   * 获取福神方位描述
   * @return 福神方位描述，如东北
   * @deprecated 使用getDayPositionFuDesc
   */
  public String getPositionFuDesc(){
    return getDayPositionFuDesc();
  }

  /**
   * 获取财神方位
   * @return 财神方位，如艮
   * @deprecated 使用getDayPositionCai
   */
  public String getPositionCai(){
    return getDayPositionCai();
  }

  /**
   * 获取财神方位描述
   * @return 财神方位描述，如东北
   * @deprecated 使用getDayPositionCaiDesc
   */
  public String getPositionCaiDesc(){
    return getDayPositionCaiDesc();
  }

  /**
   * 获取日喜神方位
   * @return 喜神方位，如艮
   */
  public String getDayPositionXi(){
    return LunarUtil.POSITION_XI[dayGanIndex+1];
  }

  /**
   * 获取日喜神方位描述
   * @return 喜神方位描述，如东北
   */
  public String getDayPositionXiDesc(){
    return LunarUtil.POSITION_DESC.get(getDayPositionXi());
  }

  /**
   * 获取日阳贵神方位
   * @return 阳贵神方位，如艮
   */
  public String getDayPositionYangGui(){
    return LunarUtil.POSITION_YANG_GUI[dayGanIndex+1];
  }

  /**
   * 获取日阳贵神方位描述
   * @return 阳贵神方位描述，如东北
   */
  public String getDayPositionYangGuiDesc(){
    return LunarUtil.POSITION_DESC.get(getDayPositionYangGui());
  }

  /**
   * 获取日阴贵神方位
   * @return 阴贵神方位，如艮
   */
  public String getDayPositionYinGui(){
    return LunarUtil.POSITION_YIN_GUI[dayGanIndex+1];
  }

  /**
   * 获取日阴贵神方位描述
   * @return 阴贵神方位描述，如东北
   */
  public String getDayPositionYinGuiDesc(){
    return LunarUtil.POSITION_DESC.get(getDayPositionYinGui());
  }

  /**
   * 获取日福神方位
   * @return 福神方位，如艮
   */
  public String getDayPositionFu(){
    return LunarUtil.POSITION_FU[dayGanIndex+1];
  }

  /**
   * 获取日福神方位描述
   * @return 福神方位描述，如东北
   */
  public String getDayPositionFuDesc(){
    return LunarUtil.POSITION_DESC.get(getDayPositionFu());
  }

  /**
   * 获取日财神方位
   * @return 财神方位，如艮
   */
  public String getDayPositionCai(){
    return LunarUtil.POSITION_CAI[dayGanIndex+1];
  }

  /**
   * 获取日财神方位描述
   * @return 财神方位描述，如东北
   */
  public String getDayPositionCaiDesc(){
    return LunarUtil.POSITION_DESC.get(getDayPositionCai());
  }

  /**
   * 获取时辰喜神方位
   * @return 喜神方位，如艮
   */
  public String getTimePositionXi(){
    return LunarUtil.POSITION_XI[timeGanIndex+1];
  }

  /**
   * 获取时辰喜神方位描述
   * @return 喜神方位描述，如东北
   */
  public String getTimePositionXiDesc(){
    return LunarUtil.POSITION_DESC.get(getTimePositionXi());
  }

  /**
   * 获取时辰阳贵神方位
   * @return 阳贵神方位，如艮
   */
  public String getTimePositionYangGui(){
    return LunarUtil.POSITION_YANG_GUI[timeGanIndex+1];
  }

  /**
   * 获取时辰阳贵神方位描述
   * @return 阳贵神方位描述，如东北
   */
  public String getTimePositionYangGuiDesc(){
    return LunarUtil.POSITION_DESC.get(getTimePositionYangGui());
  }

  /**
   * 获取时辰阴贵神方位
   * @return 阴贵神方位，如艮
   */
  public String getTimePositionYinGui(){
    return LunarUtil.POSITION_YIN_GUI[timeGanIndex+1];
  }

  /**
   * 获取时辰阴贵神方位描述
   * @return 阴贵神方位描述，如东北
   */
  public String getTimePositionYinGuiDesc(){
    return LunarUtil.POSITION_DESC.get(getTimePositionYinGui());
  }

  /**
   * 获取时辰福神方位
   * @return 福神方位，如艮
   */
  public String getTimePositionFu(){
    return LunarUtil.POSITION_FU[timeGanIndex+1];
  }

  /**
   * 获取时辰福神方位描述
   * @return 福神方位描述，如东北
   */
  public String getTimePositionFuDesc(){
    return LunarUtil.POSITION_DESC.get(getTimePositionFu());
  }

  /**
   * 获取时辰财神方位
   * @return 财神方位，如艮
   */
  public String getTimePositionCai(){
    return LunarUtil.POSITION_CAI[timeGanIndex+1];
  }

  /**
   * 获取时辰财神方位描述
   * @return 财神方位描述，如东北
   */
  public String getTimePositionCaiDesc(){
    return LunarUtil.POSITION_DESC.get(getTimePositionCai());
  }

  /**
   * 获取冲
   * @return 冲，如申
   * @deprecated 使用getDayChong
   */
  @Deprecated
  public String getChong(){
    return getDayChong();
  }

  /**
   * 获取无情之克的冲天干
   * @return 无情之克的冲天干，如甲
   * @deprecated 使用getDayChongGan
   */
  @Deprecated
  public String getChongGan(){
    return getDayChongGan();
  }

  /**
   * 获取有情之克的冲天干
   * @return 有情之克的冲天干，如甲
   * @deprecated 使用getDayChongGanTie
   */
  @Deprecated
  public String getChongGanTie(){
    return getDayChongGanTie();
  }

  /**
   * 获取冲生肖
   * @return 冲生肖，如猴
   * @deprecated 使用getDayChongShengXiao
   */
  @Deprecated
  public String getChongShengXiao(){
    return getDayChongShengXiao();
  }

  /**
   * 获取冲描述
   * @return 冲描述，如(壬申)猴
   * @deprecated 使用getDayChongDesc
   */
  @Deprecated
  public String getChongDesc(){
    return getDayChongDesc();
  }

  /**
   * 获取煞
   * @return 煞，如北
   * @deprecated 使用getDaySha
   */
  @Deprecated
  public String getSha(){
    return getDaySha();
  }

  /**
   * 获取年纳音
   * @return 年纳音，如剑锋金
   */
  public String getYearNaYin(){
    return LunarUtil.NAYIN.get(getYearInGanZhi());
  }

  /**
   * 获取月纳音
   * @return 月纳音，如剑锋金
   */
  public String getMonthNaYin(){
    return LunarUtil.NAYIN.get(getMonthInGanZhi());
  }

  /**
   * 获取日纳音
   * @return 日纳音，如剑锋金
   */
  public String getDayNaYin(){
    return LunarUtil.NAYIN.get(getDayInGanZhi());
  }

  /**
   * 获取时辰纳音
   * @return 时辰纳音，如剑锋金
   */
  public String getTimeNaYin(){
    return LunarUtil.NAYIN.get(getTimeInGanZhi());
  }

  /**
   * 获取八字，男性也称乾造，女性也称坤造（以立春交接时刻作为新年的开始）
   * @return 八字（男性也称乾造，女性也称坤造）
   * @deprecated 使用getEightChar
   */
  @Deprecated
  public List<String> getBaZi(){
    List<String> l = new ArrayList<String>(4);
    EightChar eightChar = getEightChar();
    l.add(eightChar.getYear());
    l.add(eightChar.getMonth());
    l.add(eightChar.getDay());
    l.add(eightChar.getTime());
    return l;
  }

  /**
   * 获取八字五行
   * @return 八字五行
   * @deprecated 使用getEightChar
   */
  @Deprecated
  public List<String> getBaZiWuXing(){
    List<String> l = new ArrayList<String>(4);
    EightChar eightChar = getEightChar();
    l.add(eightChar.getYearWuXing());
    l.add(eightChar.getMonthWuXing());
    l.add(eightChar.getDayWuXing());
    l.add(eightChar.getTimeWuXing());
    return l;
  }

  /**
   * 获取八字纳音
   * @return 八字纳音
   * @deprecated 使用getEightChar
   */
  @Deprecated
  public List<String> getBaZiNaYin(){
    List<String> l = new ArrayList<String>(4);
    EightChar eightChar = getEightChar();
    l.add(eightChar.getYearNaYin());
    l.add(eightChar.getMonthNaYin());
    l.add(eightChar.getDayNaYin());
    l.add(eightChar.getTimeNaYin());
    return l;
  }

  /**
   * 获取八字天干十神，日柱十神为日主，其余三柱根据天干十神表查询
   * @return 八字天干十神
   * @deprecated 使用getEightChar
   */
  @Deprecated
  public List<String> getBaZiShiShenGan(){
    List<String> l = new ArrayList<String>(4);
    EightChar eightChar = getEightChar();
    l.add(eightChar.getYearShiShenGan());
    l.add(eightChar.getMonthShiShenGan());
    l.add(eightChar.getDayShiShenGan());
    l.add(eightChar.getTimeShiShenGan());
    return l;
  }

  /**
   * 获取八字地支十神，根据地支十神表查询
   * @return 八字地支十神
   * @deprecated 使用getEightChar
   */
  @Deprecated
  public List<String> getBaZiShiShenZhi(){
    List<String> l = new ArrayList<String>(4);
    EightChar eightChar = getEightChar();
    l.add(eightChar.getYearShiShenZhi().get(0));
    l.add(eightChar.getMonthShiShenZhi().get(0));
    l.add(eightChar.getDayShiShenZhi().get(0));
    l.add(eightChar.getTimeShiShenZhi().get(0));
    return l;
  }

  /**
   * 获取八字年支十神
   * @return 八字年支十神
   * @deprecated 使用getEightChar
   */
  @Deprecated
  public List<String> getBaZiShiShenYearZhi(){
    return getEightChar().getYearShiShenZhi();
  }

  /**
   * 获取八字月支十神
   * @return 八字月支十神
   * @deprecated 使用getEightChar
   */
  @Deprecated
  public List<String> getBaZiShiShenMonthZhi(){
    return getEightChar().getMonthShiShenZhi();
  }

  /**
   * 获取八字日支十神
   * @return 八字日支十神
   * @deprecated 使用getEightChar
   */
  @Deprecated
  public List<String> getBaZiShiShenDayZhi(){
    return getEightChar().getDayShiShenZhi();
  }

  /**
   * 获取八字时支十神
   * @return 八字时支十神
   * @deprecated 使用getEightChar
   */
  @Deprecated
  public List<String> getBaZiShiShenTimeZhi(){
    return getEightChar().getTimeShiShenZhi();
  }

  /**
   * 获取十二执星：建、除、满、平、定、执、破、危、成、收、开、闭。当月支与日支相同即为建，依次类推
   * @return 执星
   */
  public String getZhiXing(){
    int offset = dayZhiIndex-monthZhiIndex;
    if(offset<0){
      offset += 12;
    }
    return LunarUtil.ZHI_XING[offset+1];
  }

  /**
   * 获取值日天神
   * @return 值日天神
   */
  public String getDayTianShen(){
    String monthZhi = getMonthZhi();
    int offset = LunarUtil.ZHI_TIAN_SHEN_OFFSET.get(monthZhi);
    return LunarUtil.TIAN_SHEN[(dayZhiIndex+offset)%12+1];
  }

  /**
   * 获取值时天神
   * @return 值时天神
   */
  public String getTimeTianShen(){
    String dayZhi = getDayZhiExact();
    int offset = LunarUtil.ZHI_TIAN_SHEN_OFFSET.get(dayZhi);
    return LunarUtil.TIAN_SHEN[(timeZhiIndex+offset)%12+1];
  }

  /**
   * 获取值日天神类型：黄道/黑道
   * @return 值日天神类型：黄道/黑道
   */
  public String getDayTianShenType(){
    return LunarUtil.TIAN_SHEN_TYPE.get(getDayTianShen());
  }

  /**
   * 获取值时天神类型：黄道/黑道
   * @return 值时天神类型：黄道/黑道
   */
  public String getTimeTianShenType(){
    return LunarUtil.TIAN_SHEN_TYPE.get(getTimeTianShen());
  }

  /**
   * 获取值日天神吉凶
   * @return 吉/凶
   */
  public String getDayTianShenLuck(){
    return LunarUtil.TIAN_SHEN_TYPE_LUCK.get(getDayTianShenType());
  }

  /**
   * 获取值时天神吉凶
   * @return 吉/凶
   */
  public String getTimeTianShenLuck(){
    return LunarUtil.TIAN_SHEN_TYPE_LUCK.get(getTimeTianShenType());
  }

  /**
   * 获取逐日胎神方位
   * @return 逐日胎神方位
   */
  public String getDayPositionTai(){
    int offset = dayGanIndex-dayZhiIndex;
    if(offset<0){
      offset += 12;
    }
    return LunarUtil.POSITION_TAI_DAY[offset*5+dayGanIndex];
  }

  /**
   * 获取逐月胎神方位，闰月无
   * @return 逐月胎神方位
   */
  public String getMonthPositionTai(){
    if(month<0){
      return "";
    }
    return LunarUtil.POSITION_TAI_MONTH[month-1];
  }

  /**
   * 获取每日宜，如果没有，返回["无"]
   * @return 宜
   */
  public List<String> getDayYi(){
    return LunarUtil.getDayYi(getMonthInGanZhiExact(),getDayInGanZhi());
  }

  /**
   * 获取每日忌，如果没有，返回["无"]
   * @return 忌
   */
  public List<String> getDayJi(){
    return LunarUtil.getDayJi(getMonthInGanZhiExact(),getDayInGanZhi());
  }

  /**
   * 获取日吉神（宜趋），如果没有，返回["无"]
   * @return 日吉神
   */
  public List<String> getDayJiShen(){
    return LunarUtil.getDayJiShen(getMonth(),getDayInGanZhi());
  }

  /**
   * 获取日凶煞（宜忌），如果没有，返回["无"]
   * @return 日凶煞
   */
  public List<String> getDayXiongSha(){
    return LunarUtil.getDayXiongSha(getMonth(),getDayInGanZhi());
  }

  /**
   * 获取日冲
   * @return 日冲，如申
   */
  public String getDayChong(){
    return LunarUtil.CHONG[dayZhiIndex+1];
  }

  /**
   * 获取日煞
   * @return 日煞，如北
   */
  public String getDaySha(){
    return LunarUtil.SHA.get(getDayZhi());
  }

  /**
   * 获取日冲描述
   * @return 日冲描述，如(壬申)猴
   */
  public String getDayChongDesc(){
    return "("+getDayChongGan()+getDayChong()+")"+getDayChongShengXiao();
  }

  /**
   * 获取日冲生肖
   * @return 日冲生肖，如猴
   */
  public String getDayChongShengXiao(){
    String chong = getDayChong();
    for(int i=0,j=LunarUtil.ZHI.length;i<j;i++){
      if(LunarUtil.ZHI[i].equals(chong)){
        return LunarUtil.SHENGXIAO[i];
      }
    }
    return "";
  }

  /**
   * 获取无情之克的日冲天干
   * @return 无情之克的日冲天干，如甲
   */
  public String getDayChongGan(){
    return LunarUtil.CHONG_GAN[dayGanIndex+1];
  }

  /**
   * 获取有情之克的日冲天干
   * @return 有情之克的日冲天干，如甲
   */
  public String getDayChongGanTie(){
    return LunarUtil.CHONG_GAN_TIE[dayGanIndex+1];
  }

  /**
   * 获取时冲
   * @return 时冲，如申
   */
  public String getTimeChong(){
    return LunarUtil.CHONG[timeZhiIndex+1];
  }

  /**
   * 获取时煞
   * @return 时煞，如北
   */
  public String getTimeSha(){
    return LunarUtil.SHA.get(getTimeZhi());
  }

  /**
   * 获取时冲生肖
   * @return 时冲生肖，如猴
   */
  public String getTimeChongShengXiao(){
    String chong = getTimeChong();
    for(int i=0,j=LunarUtil.ZHI.length;i<j;i++){
      if(LunarUtil.ZHI[i].equals(chong)){
        return LunarUtil.SHENGXIAO[i];
      }
    }
    return "";
  }

  /**
   * 获取时冲描述
   * @return 时冲描述，如(壬申)猴
   */
  public String getTimeChongDesc(){
    return "("+getTimeChongGan()+getTimeChong()+")"+getTimeChongShengXiao();
  }

  /**
   * 获取无情之克的时冲天干
   * @return 无情之克的时冲天干，如甲
   */
  public String getTimeChongGan(){
    return LunarUtil.CHONG_GAN[timeGanIndex+1];
  }

  /**
   * 获取有情之克的时冲天干
   * @return 有情之克的时冲天干，如甲
   */
  public String getTimeChongGanTie(){
    return LunarUtil.CHONG_GAN_TIE[timeGanIndex+1];
  }

  /**
   * 获取时辰宜，如果没有，返回["无"]
   * @return 宜
   */
  public List<String> getTimeYi(){
    return LunarUtil.getTimeYi(getDayInGanZhiExact(),getTimeInGanZhi());
  }

  /**
   * 获取时辰忌，如果没有，返回["无"]
   * @return 忌
   */
  public List<String> getTimeJi(){
    return LunarUtil.getTimeJi(getDayInGanZhiExact(),getTimeInGanZhi());
  }

  /**
   * 获取月相
   * @return 月相
   */
  public String getYueXiang() {
    return LunarUtil.YUE_XIANG[day];
  }

  /**
   * 获取值年九星（流年紫白星起例歌诀：年上吉星论甲子，逐年星逆中宫起；上中下作三元汇，一上四中七下兑。）
   * @return 值年九星
   */
  public NineStar getYearNineStar(){
    int index = LunarUtil.BASE_YEAR_JIU_XING_INDEX-(year-LunarUtil.BASE_YEAR)%9;
    if(index<0){
      index += 9;
    }
    return new NineStar(index);
  }

  /**
   * 获取值月九星（月紫白星歌诀：子午卯酉八白起，寅申巳亥二黑求，辰戌丑未五黄中。）
   * @return 值月九星
   */
  public NineStar getMonthNineStar(){
    int start = 2;
    String yearZhi = getYearZhi();
    if ("子午卯酉".contains(yearZhi)) {
      start = 8;
    } else if ("辰戌丑未".contains(yearZhi)) {
      start = 5;
    }
    // 寅月起，所以需要-2
    int monthIndex = monthZhiIndex-2;
    if(monthIndex<0){
      monthIndex += 12;
    }
    int index = start-monthIndex-1;
    while(index<0){
      index += 9;
    }
    return new NineStar(index);
  }

  /**
   * 获取值日九星（日家紫白星歌诀：日家白法不难求，二十四气六宫周；冬至雨水及谷雨，阳顺一七四中游；夏至处暑霜降后，九三六星逆行求。）
   * @return 值日九星
   */
  public NineStar getDayNineStar(){
    //顺逆
    String solarYmd = solar.toYmd();
    String dongZhi = jieQi.get("冬至").toYmd();
    String yuShui = jieQi.get("雨水").toYmd();
    String guYu = jieQi.get("谷雨").toYmd();
    String xiaZhi = jieQi.get("夏至").toYmd();
    String chuShu = jieQi.get("处暑").toYmd();
    String shuangJiang = jieQi.get("霜降").toYmd();

    int start = 6;
    boolean asc = false;
    if(solarYmd.compareTo(dongZhi)>=0 && solarYmd.compareTo(yuShui)<0){
      asc = true;
      start = 1;
    } else if(solarYmd.compareTo(yuShui)>=0 && solarYmd.compareTo(guYu)<0){
      asc = true;
      start = 7;
    } else if(solarYmd.compareTo(guYu)>=0 && solarYmd.compareTo(xiaZhi)<0){
      asc = true;
      start = 4;
    } else if(solarYmd.compareTo(xiaZhi)>=0 && solarYmd.compareTo(chuShu)<0){
      start = 9;
    } else if(solarYmd.compareTo(chuShu)>=0 && solarYmd.compareTo(shuangJiang)<0){
      start = 3;
    }
    int ganZhiIndex = LunarUtil.getJiaZiIndex(getDayInGanZhi())%9;
    int index = asc?start+ganZhiIndex-1:start-ganZhiIndex-1;
    if(index>8){
      index -= 9;
    }
    if(index<0){
      index += 9;
    }
    return new NineStar(index);
  }

  /**
   * 获取值时九星（时家紫白星歌诀：三元时白最为佳，冬至阳生顺莫差，孟日七宫仲一白，季日四绿发萌芽，每把时辰起甲子，本时星耀照光华，时星移入中宫去，顺飞八方逐细查。夏至阴生逆回首，孟归三碧季加六，仲在九宫时起甲，依然掌中逆轮跨。）
   * @return 值时九星
   */
  public NineStar getTimeNineStar(){
    //顺逆
    String solarYmd = solar.toYmd();
    boolean asc = false;
    if(solarYmd.compareTo(jieQi.get("冬至").toYmd())>=0 && solarYmd.compareTo(jieQi.get("夏至").toYmd())<0){
      asc = true;
    }
    int start = asc?7:3;
    String dayZhi = getDayZhi();
    if ("子午卯酉".contains(dayZhi)) {
      start = asc?1:9;
    } else if ("辰戌丑未".contains(dayZhi)) {
      start = asc?4:6;
    }
    int index = asc?start+timeZhiIndex-1:start-timeZhiIndex-1;
    if(index>8){
      index -= 9;
    }
    if(index<0){
      index += 9;
    }
    return new NineStar(index);
  }

  /**
   * 获取节气表（节气名称:阳历），节气交接时刻精确到秒，以冬至开头，按先后顺序排列
   * @return 节气表
   */
  public Map<String,Solar> getJieQiTable(){
    return jieQi;
  }

  /**
   * 获取下一节令（顺推的第一个节令）
   * @return 节气
   */
  public JieQi getNextJie(){
    return getNearJieQi(true,LunarUtil.JIE);
  }

  /**
   * 获取上一节令（逆推的第一个节令）
   * @return 节气
   */
  public JieQi getPrevJie(){
    return getNearJieQi(false,LunarUtil.JIE);
  }

  /**
   * 获取下一气令（顺推的第一个气令）
   * @return 节气
   */
  public JieQi getNextQi(){
    return getNearJieQi(true,LunarUtil.QI);
  }

  /**
   * 获取上一气令（逆推的第一个气令）
   * @return 节气
   */
  public JieQi getPrevQi(){
    return getNearJieQi(false,LunarUtil.QI);
  }

  /**
   * 获取下一节气（顺推的第一个节气）
   * @return 节气
   */
  public JieQi getNextJieQi(){
    return getNearJieQi(true,null);
  }

  /**
   * 获取上一节气（逆推的第一个节气）
   * @return 节气
   */
  public JieQi getPrevJieQi(){
    return getNearJieQi(false,null);
  }

  /**
   * 获取最近的节气，如果未找到匹配的，返回null
   * @param forward 是否顺推，true为顺推，false为逆推
   * @param conditions 过滤条件，如果设置过滤条件，仅返回匹配该名称的
   * @return 节气
   */
  protected JieQi getNearJieQi(boolean forward, String[] conditions){
    String name = null;
    Solar near = null;
    Set<String> filters = new HashSet<String>();
    if(null!=conditions) {
      Collections.addAll(filters, conditions);
    }
    boolean filter = !filters.isEmpty();
    String today = solar.toYmdHms();
    for(Map.Entry<String,Solar> entry:jieQi.entrySet()){
      String jq = entry.getKey();
      if(JIE_QI_APPEND.equals(jq)){
        jq = JIE_QI_FIRST;
      }
      if(JIE_QI_PREPEND.equals(jq)){
        jq = JIE_QI_LAST;
      }
      if(JIE_APPEND_SOLAR_FIRST.equals(jq)){
        jq = JIE_SOLAR_FIRST;
      }
      if(QI_APPEND_SOLAR_SECOND.equals(jq)){
        jq = QI_SOLAR_SECOND;
      }
      if(filter){
        if(!filters.contains(jq)){
          continue;
        }
      }
      Solar solar = entry.getValue();
      String day = solar.toYmdHms();
      if(forward){
        if(day.compareTo(today)<0){
          continue;
        }
        if(null==near || day.compareTo(near.toYmdHms())<0){
          name = jq;
          near = solar;
        }
      }else{
        if(day.compareTo(today)>0){
          continue;
        }
        if(null==near || day.compareTo(near.toYmdHms())>0) {
          name = jq;
          near = solar;
        }
      }
    }
    if(null==near){
      return null;
    }
    return new JieQi(name, near);
  }

  /**
   * 获取节气名称，如果无节气，返回空字符串
   * @return 节气名称
   */
  public String getJieQi(){
    String name = "";
    for(Map.Entry<String,Solar> jq:jieQi.entrySet()){
      Solar d = jq.getValue();
      if(d.getYear()==solar.getYear()&&d.getMonth()==solar.getMonth()&&d.getDay()==solar.getDay()){
        name = jq.getKey();
        break;
      }
    }
    if(JIE_QI_APPEND.equals(name)){
      name = JIE_QI_FIRST;
    }else if(JIE_QI_PREPEND.equals(name)){
      name = JIE_QI_LAST;
    }else if(JIE_APPEND_SOLAR_FIRST.equals(name)){
      name = JIE_SOLAR_FIRST;
    }else if(QI_APPEND_SOLAR_SECOND.equals(name)){
      name = QI_SOLAR_SECOND;
    }
    return name;
  }

  /**
   * 获取当天节气对象，如果无节气，返回null
   * @return 节气对象
   */
  public JieQi getCurrentJieQi(){
    String name = getJieQi();
    return name.length()>0 ? new JieQi(name,solar) : null;
  }

  /**
   * 获取当天节令对象，如果无节令，返回null
   * @return 节气对象
   */
  public JieQi getCurrentJie(){
    String name = getJie();
    return name.length()>0 ? new JieQi(name,solar) : null;
  }

  /**
   * 获取当天气令对象，如果无气令，返回null
   * @return 节气对象
   */
  public JieQi getCurrentQi(){
    String name = getQi();
    return name.length()>0 ? new JieQi(name,solar) : null;
  }

  public String toFullString(){
    StringBuilder s = new StringBuilder();
    s.append(toString());
    s.append(" ");
    s.append(getYearInGanZhi());
    s.append("(");
    s.append(getYearShengXiao());
    s.append(")年 ");
    s.append(getMonthInGanZhi());
    s.append("(");
    s.append(getMonthShengXiao());
    s.append(")月 ");
    s.append(getDayInGanZhi());
    s.append("(");
    s.append(getDayShengXiao());
    s.append(")日 ");
    s.append(getTimeZhi());
    s.append("(");
    s.append(getTimeShengXiao());
    s.append(")时 纳音[");
    s.append(getYearNaYin());
    s.append(" ");
    s.append(getMonthNaYin());
    s.append(" ");
    s.append(getDayNaYin());
    s.append(" ");
    s.append(getTimeNaYin());
    s.append("] 星期");
    s.append(getWeekInChinese());
    for(String f:getFestivals()){
      s.append(" (");
      s.append(f);
      s.append(")");
    }
    for(String f:getOtherFestivals()){
      s.append(" (");
      s.append(f);
      s.append(")");
    }
    String jq = getJieQi();
    if(jq.length()>0){
      s.append(" [");
      s.append(jq);
      s.append("]");
    }
    s.append(" ");
    s.append(getGong());
    s.append("方");
    s.append(getShou());
    s.append(" 星宿[");
    s.append(getXiu());
    s.append(getZheng());
    s.append(getAnimal());
    s.append("](");
    s.append(getXiuLuck());
    s.append(") 彭祖百忌[");
    s.append(getPengZuGan());
    s.append(" ");
    s.append(getPengZuZhi());
    s.append("] 喜神方位[");
    s.append(getDayPositionXi());
    s.append("](");
    s.append(getDayPositionXiDesc());
    s.append(") 阳贵神方位[");
    s.append(getDayPositionYangGui());
    s.append("](");
    s.append(getDayPositionYangGuiDesc());
    s.append(") 阴贵神方位[");
    s.append(getDayPositionYinGui());
    s.append("](");
    s.append(getDayPositionYinGuiDesc());
    s.append(") 福神方位[");
    s.append(getDayPositionFu());
    s.append("](");
    s.append(getDayPositionFuDesc());
    s.append(") 财神方位[");
    s.append(getDayPositionCai());
    s.append("](");
    s.append(getDayPositionCaiDesc());
    s.append(") 冲[");
    s.append(getDayChongDesc());
    s.append("] 煞[");
    s.append(getDaySha());
    s.append("]");
    return s.toString();
  }

  @Override
  public String toString(){
    return getYearInChinese()+"年"+getMonthInChinese()+"月"+getDayInChinese();
  }

  /**
   * 获取年份
   *
   * @return 如2015
   */
  public int getYear(){
    return year;
  }

  /**
   * 获取月份
   *
   * @return 1到12，负数为闰月
   */
  public int getMonth(){
    return month;
  }

  /**
   * 获取日期
   *
   * @return 日期
   */
  public int getDay(){
    return day;
  }

  /**
   * 获取小时
   *
   * @return 0到23之间的数字
   */
  public int getHour(){
    return hour;
  }

  /**
   * 获取分钟
   *
   * @return 0到59之间的数字
   */
  public int getMinute(){
    return minute;
  }

  /**
   * 获取秒钟
   *
   * @return 0到59之间的数字
   */
  public int getSecond(){
    return second;
  }

  public int getTimeGanIndex() {
    return timeGanIndex;
  }

  public int getTimeZhiIndex() {
    return timeZhiIndex;
  }

  public int getDayGanIndexExact() {
    return dayGanIndexExact;
  }

  public int getDayZhiIndexExact() {
    return dayZhiIndexExact;
  }

  public int getMonthGanIndexExact() {
    return monthGanIndexExact;
  }

  public int getMonthZhiIndexExact() {
    return monthZhiIndexExact;
  }

  public int getYearGanIndexExact(){
    return yearGanIndexExact;
  }

  public int getYearZhiIndexExact(){
    return yearZhiIndexExact;
  }

  public Solar getSolar(){
    return solar;
  }

  public EightChar getEightChar(){
    if(null==eightChar){
      eightChar = new EightChar(this);
    }
    return eightChar;
  }

  /**
   * 获取往后推几天的农历日期，如果要往前推，则天数用负数
   * @param days 天数
   * @return 农历日期
   */
  public Lunar next(int days){
    int y = year;
    int m = month;
    int d = day;
    if(days>0){
      int daysInMonth = LunarUtil.getDaysOfMonth(y,m);
      int rest = day+days;
      while(daysInMonth < rest) {
        if(m>0){
          if(LunarUtil.getLeapMonth(y)!=m){
            m++;
          }else{
            m = -m;
          }
        }else{
          m = 1-m;
        }
        if(13==m){
          y++;
          m=1;
        }
        rest -= daysInMonth;
        daysInMonth = LunarUtil.getDaysOfMonth(y,m);
      }
      d = rest;
    }else if(days<0){
      int daysInMonth = day;
      int rest = -days;
      while(daysInMonth <= rest) {
        if(m>0){
          m--;
          if(0==m){
            y--;
            m = LunarUtil.getLeapMonth(y)!=12?12:-12;
          }
        }else{
          m = -m;
        }
        rest -= daysInMonth;
        daysInMonth = LunarUtil.getDaysOfMonth(y,m);
      }
      d = daysInMonth - rest;
    }
    return new Lunar(y,m,d,hour,minute,second);
  }

  /**
   * 获取年所在旬（以正月初一作为新年的开始）
   * @return 旬
   */
  public String getYearXun(){
    return LunarUtil.getXun(getYearInGanZhi());
  }

  /**
   * 获取年所在旬（以立春当天作为新年的开始）
   * @return 旬
   */
  public String getYearXunByLiChun(){
    return LunarUtil.getXun(getYearInGanZhiByLiChun());
  }

  /**
   * 获取年所在旬（以立春交接时刻作为新年的开始）
   * @return 旬
   */
  public String getYearXunExact(){
    return LunarUtil.getXun(getYearInGanZhiExact());
  }

  /**
   * 获取值年空亡（以正月初一作为新年的开始）
   * @return 空亡(旬空)
   */
  public String getYearXunKong(){
    return LunarUtil.getXunKong(getYearInGanZhi());
  }

  /**
   * 获取值年空亡（以立春当天作为新年的开始）
   * @return 空亡(旬空)
   */
  public String getYearXunKongByLiChun(){
    return LunarUtil.getXunKong(getYearInGanZhiByLiChun());
  }

  /**
   * 获取值年空亡（以立春交接时刻作为新年的开始）
   * @return 空亡(旬空)
   */
  public String getYearXunKongExact(){
    return LunarUtil.getXunKong(getYearInGanZhiExact());
  }

  /**
   * 获取月所在旬（以节交接当天起算）
   * @return 旬
   */
  public String getMonthXun(){
    return LunarUtil.getXun(getMonthInGanZhi());
  }

  /**
   * 获取月所在旬（以节交接时刻起算）
   * @return 旬
   */
  public String getMonthXunExact(){
    return LunarUtil.getXun(getMonthInGanZhiExact());
  }

  /**
   * 获取值月空亡（以节交接当天起算）
   * @return 空亡(旬空)
   */
  public String getMonthXunKong(){
    return LunarUtil.getXunKong(getMonthInGanZhi());
  }

  /**
   * 获取值月空亡（以节交接时刻起算）
   * @return 空亡(旬空)
   */
  public String getMonthXunKongExact(){
    return LunarUtil.getXunKong(getMonthInGanZhiExact());
  }

  /**
   * 获取日所在旬（以节交接当天起算）
   * @return 旬
   */
  public String getDayXun(){
    return LunarUtil.getXun(getDayInGanZhi());
  }

  /**
   * 获取日所在旬（晚子时算第二天）
   * @return 旬
   */
  public String getDayXunExact(){
    return LunarUtil.getXun(getDayInGanZhiExact());
  }

  /**
   * 获取值日空亡
   * @return 空亡(旬空)
   */
  public String getDayXunKong(){
    return LunarUtil.getXunKong(getDayInGanZhi());
  }

  /**
   * 获取值日空亡（晚子时算第二天）
   * @return 空亡(旬空)
   */
  public String getDayXunKongExact(){
    return LunarUtil.getXunKong(getDayInGanZhiExact());
  }

  /**
   * 获取时辰所在旬
   * @return 旬
   */
  public String getTimeXun(){
    return LunarUtil.getXun(getTimeInGanZhi());
  }

  /**
   * 获取值时空亡
   * @return 空亡(旬空)
   */
  public String getTimeXunKong(){
    return LunarUtil.getXunKong(getTimeInGanZhi());
  }
}
