/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar.eightchar;

import com.nlf.calendar.Lunar;
import com.nlf.calendar.eightchar.DaYun;
import com.nlf.calendar.eightchar.LiuYue;
import com.nlf.calendar.util.LunarUtil;

public class LiuNian {
    private int index;
    private DaYun daYun;
    private int year;
    private int age;
    private Lunar lunar;

    public LiuNian(DaYun daYun, int index) {
        this.daYun = daYun;
        this.lunar = daYun.getLunar();
        this.index = index;
        this.year = daYun.getStartYear() + index;
        this.age = daYun.getStartAge() + index;
    }

    public int getIndex() {
        return this.index;
    }

    public int getYear() {
        return this.year;
    }

    public int getAge() {
        return this.age;
    }

    public String getGanZhi() {
        int offset = LunarUtil.getJiaZiIndex(this.lunar.getYearInGanZhiExact()) + this.index;
        if (this.daYun.getIndex() > 0) {
            offset += this.daYun.getStartAge() - 1;
        }
        return LunarUtil.JIA_ZI[offset %= LunarUtil.JIA_ZI.length];
    }

    public String getXun() {
        return LunarUtil.getXun(this.getGanZhi());
    }

    public String getXunKong() {
        return LunarUtil.getXunKong(this.getGanZhi());
    }

    public LiuYue[] getLiuYue() {
        int n = 12;
        LiuYue[] l = new LiuYue[n];
        for (int i = 0; i < n; ++i) {
            l[i] = new LiuYue(this, i);
        }
        return l;
    }
}

