/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.Lunar;
import com.nlf.calendar.eightchar.Yun;
import com.nlf.calendar.util.LunarUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EightChar {
    private static final String[] MONTH_ZHI = new String[]{"", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5", "\u5b50", "\u4e11"};
    public static final String[] CHANG_SHENG = new String[]{"\u957f\u751f", "\u6c90\u6d74", "\u51a0\u5e26", "\u4e34\u5b98", "\u5e1d\u65fa", "\u8870", "\u75c5", "\u6b7b", "\u5893", "\u7edd", "\u80ce", "\u517b"};
    private static final Map<String, Integer> CHANG_SHENG_OFFSET = new HashMap<String, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("\u7532", 11);
            this.put("\u4e19", 2);
            this.put("\u620a", 2);
            this.put("\u5e9a", 5);
            this.put("\u58ec", 8);
            this.put("\u4e59", 6);
            this.put("\u4e01", 9);
            this.put("\u5df1", 9);
            this.put("\u8f9b", 0);
            this.put("\u7678", 3);
        }
    };
    protected Lunar lunar;

    public EightChar(Lunar lunar) {
        this.lunar = lunar;
    }

    public static EightChar fromLunar(Lunar lunar) {
        return new EightChar(lunar);
    }

    public String toString() {
        return this.getYear() + " " + this.getMonth() + " " + this.getDay() + " " + this.getTime();
    }

    public String getYear() {
        return this.lunar.getYearInGanZhiExact();
    }

    public String getYearGan() {
        return this.lunar.getYearGanExact();
    }

    public String getYearZhi() {
        return this.lunar.getYearZhiExact();
    }

    public List<String> getYearHideGan() {
        return LunarUtil.ZHI_HIDE_GAN.get(this.getYearZhi());
    }

    public String getYearWuXing() {
        return LunarUtil.WU_XING_GAN.get(this.lunar.getYearGanExact()) + LunarUtil.WU_XING_ZHI.get(this.lunar.getYearZhiExact());
    }

    public String getYearNaYin() {
        return LunarUtil.NAYIN.get(this.getYear());
    }

    public String getYearShiShenGan() {
        return LunarUtil.SHI_SHEN_GAN.get(this.getDayGan() + this.getYearGan());
    }

    private List<String> getShiShenZhi(String zhi) {
        List<String> hideGan = LunarUtil.ZHI_HIDE_GAN.get(zhi);
        ArrayList<String> l = new ArrayList<String>(hideGan.size());
        for (String gan : hideGan) {
            l.add(LunarUtil.SHI_SHEN_ZHI.get(this.getDayGan() + zhi + gan));
        }
        return l;
    }

    public List<String> getYearShiShenZhi() {
        return this.getShiShenZhi(this.getYearZhi());
    }

    private String getDiShi(int zhiIndex) {
        int offset = CHANG_SHENG_OFFSET.get(this.getDayGan());
        int index = offset + (this.lunar.getDayGanIndexExact() % 2 == 0 ? zhiIndex : -zhiIndex);
        if (index >= 12) {
            index -= 12;
        }
        if (index < 0) {
            index += 12;
        }
        return CHANG_SHENG[index];
    }

    public String getYearDiShi() {
        return this.getDiShi(this.lunar.getYearZhiIndexExact());
    }

    public String getMonth() {
        return this.lunar.getMonthInGanZhiExact();
    }

    public String getMonthGan() {
        return this.lunar.getMonthGanExact();
    }

    public String getMonthZhi() {
        return this.lunar.getMonthZhiExact();
    }

    public List<String> getMonthHideGan() {
        return LunarUtil.ZHI_HIDE_GAN.get(this.getMonthZhi());
    }

    public String getMonthWuXing() {
        return LunarUtil.WU_XING_GAN.get(this.lunar.getMonthGanExact()) + LunarUtil.WU_XING_ZHI.get(this.lunar.getMonthZhiExact());
    }

    public String getMonthNaYin() {
        return LunarUtil.NAYIN.get(this.getMonth());
    }

    public String getMonthShiShenGan() {
        return LunarUtil.SHI_SHEN_GAN.get(this.getDayGan() + this.getMonthGan());
    }

    public List<String> getMonthShiShenZhi() {
        return this.getShiShenZhi(this.getMonthZhi());
    }

    public String getMonthDiShi() {
        return this.getDiShi(this.lunar.getMonthZhiIndexExact());
    }

    public String getDay() {
        return this.lunar.getDayInGanZhiExact();
    }

    public String getDayGan() {
        return this.lunar.getDayGanExact();
    }

    public String getDayZhi() {
        return this.lunar.getDayZhiExact();
    }

    public List<String> getDayHideGan() {
        return LunarUtil.ZHI_HIDE_GAN.get(this.getDayZhi());
    }

    public String getDayWuXing() {
        return LunarUtil.WU_XING_GAN.get(this.lunar.getDayGanExact()) + LunarUtil.WU_XING_ZHI.get(this.lunar.getDayZhiExact());
    }

    public String getDayNaYin() {
        return LunarUtil.NAYIN.get(this.getDay());
    }

    public String getDayShiShenGan() {
        return "\u65e5\u4e3b";
    }

    public List<String> getDayShiShenZhi() {
        return this.getShiShenZhi(this.getDayZhi());
    }

    public String getDayDiShi() {
        return this.getDiShi(this.lunar.getDayZhiIndexExact());
    }

    public String getTime() {
        return this.lunar.getTimeInGanZhi();
    }

    public String getTimeGan() {
        return this.lunar.getTimeGan();
    }

    public String getTimeZhi() {
        return this.lunar.getTimeZhi();
    }

    public List<String> getTimeHideGan() {
        return LunarUtil.ZHI_HIDE_GAN.get(this.getTimeZhi());
    }

    public String getTimeWuXing() {
        return LunarUtil.WU_XING_GAN.get(this.lunar.getTimeGan()) + LunarUtil.WU_XING_ZHI.get(this.lunar.getTimeZhi());
    }

    public String getTimeNaYin() {
        return LunarUtil.NAYIN.get(this.getTime());
    }

    public String getTimeShiShenGan() {
        return LunarUtil.SHI_SHEN_GAN.get(this.getDayGan() + this.getTimeGan());
    }

    public List<String> getTimeShiShenZhi() {
        return this.getShiShenZhi(this.getTimeZhi());
    }

    public String getTimeDiShi() {
        return this.getDiShi(this.lunar.getTimeZhiIndex());
    }

    public String getTaiYuan() {
        int zhiIndex;
        int ganIndex = this.lunar.getMonthGanIndexExact() + 1;
        if (ganIndex >= 10) {
            ganIndex -= 10;
        }
        if ((zhiIndex = this.lunar.getMonthZhiIndexExact() + 3) >= 12) {
            zhiIndex -= 12;
        }
        return LunarUtil.GAN[ganIndex + 1] + LunarUtil.ZHI[zhiIndex + 1];
    }

    public String getTaiYuanNaYin() {
        return LunarUtil.NAYIN.get(this.getTaiYuan());
    }

    public String getMingGong() {
        int jiaZiIndex;
        int monthZhiIndex = 0;
        int timeZhiIndex = 0;
        int j = MONTH_ZHI.length;
        for (int i = 0; i < j; ++i) {
            String zhi = MONTH_ZHI[i];
            if (this.lunar.getMonthZhiExact().equals(zhi)) {
                monthZhiIndex = i;
            }
            if (!this.lunar.getTimeZhi().equals(zhi)) continue;
            timeZhiIndex = i;
        }
        int zhiIndex = 26 - (monthZhiIndex + timeZhiIndex);
        if (zhiIndex > 12) {
            zhiIndex -= 12;
        }
        if ((jiaZiIndex = LunarUtil.getJiaZiIndex(this.lunar.getMonthInGanZhiExact()) - (monthZhiIndex - zhiIndex)) >= 60) {
            jiaZiIndex -= 60;
        }
        if (jiaZiIndex < 0) {
            jiaZiIndex += 60;
        }
        return LunarUtil.JIA_ZI[jiaZiIndex];
    }

    public String getMingGongNaYin() {
        return LunarUtil.NAYIN.get(this.getMingGong());
    }

    public String getShenGong() {
        int monthZhiIndex = 0;
        int timeZhiIndex = 0;
        int j = MONTH_ZHI.length;
        for (int i = 0; i < j; ++i) {
            String zhi = MONTH_ZHI[i];
            if (this.lunar.getMonthZhiExact().equals(zhi)) {
                monthZhiIndex = i;
            }
            if (!this.lunar.getTimeZhi().equals(zhi)) continue;
            timeZhiIndex = i;
        }
        int zhiIndex = (2 + (monthZhiIndex + timeZhiIndex)) % 12;
        int jiaZiIndex = LunarUtil.getJiaZiIndex(this.lunar.getMonthInGanZhiExact()) - (monthZhiIndex - zhiIndex);
        if (jiaZiIndex >= 60) {
            jiaZiIndex -= 60;
        }
        if (jiaZiIndex < 0) {
            jiaZiIndex += 60;
        }
        return LunarUtil.JIA_ZI[jiaZiIndex];
    }

    public String getShenGongNaYin() {
        return LunarUtil.NAYIN.get(this.getShenGong());
    }

    public Lunar getLunar() {
        return this.lunar;
    }

    public Yun getYun(int gender) {
        return new Yun(this, gender);
    }

    public String getYearXun() {
        return this.lunar.getYearXunExact();
    }

    public String getYearXunKong() {
        return this.lunar.getYearXunKongExact();
    }

    public String getMonthXun() {
        return this.lunar.getMonthXunExact();
    }

    public String getMonthXunKong() {
        return this.lunar.getMonthXunKongExact();
    }

    public String getDayXun() {
        return this.lunar.getDayXunExact();
    }

    public String getDayXunKong() {
        return this.lunar.getDayXunKongExact();
    }

    public String getTimeXun() {
        return this.lunar.getTimeXun();
    }

    public String getTimeXunKong() {
        return this.lunar.getTimeXunKong();
    }
}

