/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar.util;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class SolarUtil {
    public static final int BASE_YEAR = 1901;
    public static final int BASE_MONTH = 1;
    public static final int BASE_DAY = 1;
    public static final String[] WEEK = new String[]{"\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"};
    public static final int[] DAYS_OF_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final String[] XINGZUO = new String[]{"\u767d\u7f8a", "\u91d1\u725b", "\u53cc\u5b50", "\u5de8\u87f9", "\u72ee\u5b50", "\u5904\u5973", "\u5929\u79e4", "\u5929\u874e", "\u5c04\u624b", "\u6469\u7faf", "\u6c34\u74f6", "\u53cc\u9c7c"};
    public static final Map<String, String> FESTIVAL = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("1-1", "\u5143\u65e6\u8282");
            this.put("2-14", "\u60c5\u4eba\u8282");
            this.put("3-8", "\u5987\u5973\u8282");
            this.put("3-12", "\u690d\u6811\u8282");
            this.put("3-15", "\u6d88\u8d39\u8005\u6743\u76ca\u65e5");
            this.put("4-1", "\u611a\u4eba\u8282");
            this.put("5-1", "\u52b3\u52a8\u8282");
            this.put("5-4", "\u9752\u5e74\u8282");
            this.put("6-1", "\u513f\u7ae5\u8282");
            this.put("7-1", "\u5efa\u515a\u8282");
            this.put("8-1", "\u5efa\u519b\u8282");
            this.put("9-10", "\u6559\u5e08\u8282");
            this.put("10-1", "\u56fd\u5e86\u8282");
            this.put("12-24", "\u5e73\u5b89\u591c");
            this.put("12-25", "\u5723\u8bde\u8282");
        }
    };
    public static final Map<String, String> WEEK_FESTIVAL = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("5-2-0", "\u6bcd\u4eb2\u8282");
            this.put("6-3-0", "\u7236\u4eb2\u8282");
            this.put("11-4-4", "\u611f\u6069\u8282");
        }
    };

    protected SolarUtil() {
    }

    public static boolean isLeapYear(int year) {
        boolean leap = false;
        if (year % 4 == 0) {
            leap = true;
        }
        if (year % 100 == 0) {
            leap = false;
        }
        if (year % 400 == 0) {
            leap = true;
        }
        return leap;
    }

    public static int getDaysOfMonth(int year, int month) {
        int m = month - 1;
        int d = DAYS_OF_MONTH[m];
        if (m == 1 && SolarUtil.isLeapYear(year)) {
            ++d;
        }
        return d;
    }

    public static int getWeeksOfMonth(int year, int month, int start) {
        int days = SolarUtil.getDaysOfMonth(year, month);
        Calendar c = Calendar.getInstance();
        c.set(year, month - 1, 1);
        int week = c.get(7) - 1;
        return (int)Math.ceil((double)(days + week - start) / 7.0);
    }
}

