/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar.util;

import java.util.HashMap;
import java.util.Map;

public class LunarUtil {
    public static final int BASE_YEAR = 1900;
    public static final int BASE_MONTH = 11;
    public static final int BASE_DAY = 11;
    public static final int BASE_INDEX = 0;
    public static final int[] LEAP_MONTH_YEAR = new int[]{6, 14, 19, 25, 33, 36, 38, 41, 44, 52, 55, 79, 117, 136, 147, 150, 155, 158, 185, 193};
    public static final int[] LUNAR_MONTH = new int[]{0, 4, 173, 8, 90, 1, 213, 84, 180, 9, 100, 5, 89, 69, 149, 10, 166, 4, 85, 36, 173, 8, 90, 98, 218, 4, 180, 5, 180, 85, 82, 13, 148, 10, 74, 42, 86, 2, 109, 113, 109, 1, 218, 2, 210, 82, 169, 5, 73, 13, 42, 69, 43, 9, 86, 1, 181, 32, 109, 1, 89, 105, 212, 10, 168, 5, 169, 86, 165, 4, 43, 9, 158, 56, 182, 8, 236, 116, 108, 5, 212, 10, 228, 106, 82, 5, 149, 10, 90, 66, 91, 4, 182, 4, 180, 34, 106, 5, 82, 117, 201, 10, 82, 5, 53, 85, 77, 10, 90, 2, 93, 49, 181, 2, 106, 138, 104, 5, 169, 10, 138, 106, 42, 5, 45, 9, 170, 72, 90, 1, 181, 9, 176, 57, 100, 5, 37, 117, 149, 10, 150, 4, 77, 84, 173, 4, 218, 4, 212, 68, 180, 5, 84, 133, 82, 13, 146, 10, 86, 106, 86, 2, 109, 2, 106, 65, 218, 2, 178, 161, 169, 5, 73, 13, 10, 109, 42, 9, 86, 1, 173, 80, 109, 1, 217, 2, 209, 58, 168, 5, 41, 133, 165, 12, 42, 9, 150, 84, 182, 8, 108, 9, 100, 69, 212, 10, 164, 5, 81, 37, 149, 10, 42, 114, 91, 4, 182, 4, 172, 82, 106, 5, 210, 10, 162, 74, 74, 5, 85, 148, 45, 10, 90, 2, 117, 97, 181, 2, 106, 3, 97, 69, 169, 10, 74, 5, 37, 37, 45, 9, 154, 104, 218, 8, 180, 9, 168, 89, 84, 3, 165, 10, 145, 58, 150, 4, 173, 176, 173, 4, 218, 4, 244, 98, 180, 5, 84, 11, 68, 93, 82, 10, 149, 4, 85, 34, 109, 2, 90, 113, 218, 2, 170, 5, 178, 85, 73, 11, 74, 10, 45, 57, 54, 1, 109, 128, 109, 1, 217, 2, 233, 106, 168, 5, 41, 11, 154, 76, 170, 8, 182, 8, 180, 56, 108, 9, 84, 117, 212, 10, 164, 5, 69, 85, 149, 10, 154, 4, 85, 68, 181, 4, 106, 130, 106, 5, 210, 10, 146, 106, 74, 5, 85, 10, 42, 74, 90, 2, 181, 2, 178, 49, 105, 3, 49, 115, 169, 10, 74, 5, 45, 85, 45, 9, 90, 1, 213, 72, 180, 9, 104, 137, 84, 11, 164, 10, 165, 106, 149, 4, 173, 8, 106, 68, 218, 4, 116, 5, 176, 37, 84, 3};
    public static final int[][] JIE_YEAR = new int[][]{{13, 49, 85, 117, 149, 185, 201, 250, 250}, {13, 45, 81, 117, 149, 185, 201, 250, 250}, {13, 48, 84, 112, 148, 184, 200, 201, 250}, {13, 45, 76, 108, 140, 172, 200, 201, 250}, {13, 44, 72, 104, 132, 168, 200, 201, 250}, {5, 33, 68, 96, 124, 152, 188, 200, 201}, {29, 57, 85, 120, 148, 176, 200, 201, 250}, {13, 48, 76, 104, 132, 168, 196, 200, 201}, {25, 60, 88, 120, 148, 184, 200, 201, 250}, {16, 44, 76, 108, 144, 172, 200, 201, 250}, {28, 60, 92, 124, 160, 192, 200, 201, 250}, {17, 53, 85, 124, 156, 188, 200, 201, 250}};
    public static final int[][] JIE_MAP = new int[][]{{7, 6, 6, 6, 6, 6, 6, 6, 6, 5, 6, 6, 6, 5, 5, 6, 6, 5, 5, 5, 5, 5, 5, 5, 5, 4, 5, 5}, {5, 4, 5, 5, 5, 4, 4, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 3, 4, 4, 4, 3, 3, 4, 4, 3, 3, 3}, {6, 6, 6, 7, 6, 6, 6, 6, 5, 6, 6, 6, 5, 5, 6, 6, 5, 5, 5, 6, 5, 5, 5, 5, 4, 5, 5, 5, 5}, {5, 5, 6, 6, 5, 5, 5, 6, 5, 5, 5, 5, 4, 5, 5, 5, 4, 4, 5, 5, 4, 4, 4, 5, 4, 4, 4, 4, 5}, {6, 6, 6, 7, 6, 6, 6, 6, 5, 6, 6, 6, 5, 5, 6, 6, 5, 5, 5, 6, 5, 5, 5, 5, 4, 5, 5, 5, 5}, {6, 6, 7, 7, 6, 6, 6, 7, 6, 6, 6, 6, 5, 6, 6, 6, 5, 5, 6, 6, 5, 5, 5, 6, 5, 5, 5, 5, 4, 5, 5, 5, 5}, {7, 8, 8, 8, 7, 7, 8, 8, 7, 7, 7, 8, 7, 7, 7, 7, 6, 7, 7, 7, 6, 6, 7, 7, 6, 6, 6, 7, 7}, {8, 8, 8, 9, 8, 8, 8, 8, 7, 8, 8, 8, 7, 7, 8, 8, 7, 7, 7, 8, 7, 7, 7, 7, 6, 7, 7, 7, 6, 6, 7, 7, 7}, {8, 8, 8, 9, 8, 8, 8, 8, 7, 8, 8, 8, 7, 7, 8, 8, 7, 7, 7, 8, 7, 7, 7, 7, 6, 7, 7, 7, 7}, {9, 9, 9, 9, 8, 9, 9, 9, 8, 8, 9, 9, 8, 8, 8, 9, 8, 8, 8, 8, 7, 8, 8, 8, 7, 7, 8, 8, 8}, {8, 8, 8, 8, 7, 8, 8, 8, 7, 7, 8, 8, 7, 7, 7, 8, 7, 7, 7, 7, 6, 7, 7, 7, 6, 6, 7, 7, 7}, {7, 8, 8, 8, 7, 7, 8, 8, 7, 7, 7, 8, 7, 7, 7, 7, 6, 7, 7, 7, 6, 6, 7, 7, 6, 6, 6, 7, 7}};
    public static final int[][] QI_YEAR = new int[][]{{13, 45, 81, 113, 149, 185, 201}, {21, 57, 93, 125, 161, 193, 201}, {21, 56, 88, 120, 152, 188, 200, 201}, {21, 49, 81, 116, 144, 176, 200, 201}, {17, 49, 77, 112, 140, 168, 200, 201}, {28, 60, 88, 116, 148, 180, 200, 201}, {25, 53, 84, 112, 144, 172, 200, 201}, {29, 57, 89, 120, 148, 180, 200, 201}, {17, 45, 73, 108, 140, 168, 200, 201}, {28, 60, 92, 124, 160, 192, 200, 201}, {16, 44, 80, 112, 148, 180, 200, 201}, {17, 53, 88, 120, 156, 188, 200, 201}};
    public static final int[][] QI_MAP = new int[][]{{21, 21, 21, 21, 21, 20, 21, 21, 21, 20, 20, 21, 21, 20, 20, 20, 20, 20, 20, 20, 20, 19, 20, 20, 20, 19, 19, 20}, {20, 19, 19, 20, 20, 19, 19, 19, 19, 19, 19, 19, 19, 18, 19, 19, 19, 18, 18, 19, 19, 18, 18, 18, 18, 18, 18, 18}, {21, 21, 21, 22, 21, 21, 21, 21, 20, 21, 21, 21, 20, 20, 21, 21, 20, 20, 20, 21, 20, 20, 20, 20, 19, 20, 20, 20, 20}, {20, 21, 21, 21, 20, 20, 21, 21, 20, 20, 20, 21, 20, 20, 20, 20, 19, 20, 20, 20, 19, 19, 20, 20, 19, 19, 19, 20, 20}, {21, 22, 22, 22, 21, 21, 22, 22, 21, 21, 21, 22, 21, 21, 21, 21, 20, 21, 21, 21, 20, 20, 21, 21, 20, 20, 20, 21, 21}, {22, 22, 22, 22, 21, 22, 22, 22, 21, 21, 22, 22, 21, 21, 21, 22, 21, 21, 21, 21, 20, 21, 21, 21, 20, 20, 21, 21, 21}, {23, 23, 24, 24, 23, 23, 23, 24, 23, 23, 23, 23, 22, 23, 23, 23, 22, 22, 23, 23, 22, 22, 22, 23, 22, 22, 22, 22, 23}, {23, 24, 24, 24, 23, 23, 24, 24, 23, 23, 23, 24, 23, 23, 23, 23, 22, 23, 23, 23, 22, 22, 23, 23, 22, 22, 22, 23, 23}, {23, 24, 24, 24, 23, 23, 24, 24, 23, 23, 23, 24, 23, 23, 23, 23, 22, 23, 23, 23, 22, 22, 23, 23, 22, 22, 22, 23, 23}, {24, 24, 24, 24, 23, 24, 24, 24, 23, 23, 24, 24, 23, 23, 23, 24, 23, 23, 23, 23, 22, 23, 23, 23, 22, 22, 23, 23, 23}, {23, 23, 23, 23, 22, 23, 23, 23, 22, 22, 23, 23, 22, 22, 22, 23, 22, 22, 22, 22, 21, 22, 22, 22, 21, 21, 22, 22, 22}, {22, 22, 23, 23, 22, 22, 22, 23, 22, 22, 22, 22, 21, 22, 22, 22, 21, 21, 22, 22, 21, 21, 21, 22, 21, 21, 21, 21, 22}};
    public static final String[] GAN = new String[]{"", "\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
    public static final String[] ZHI = new String[]{"", "\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
    public static final String[] MONTH = new String[]{"", "\u6b63", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396", "\u62fe", "\u51ac", "\u814a"};
    public static final String[] SEASON = new String[]{"", "\u5b5f\u6625", "\u4ef2\u6625", "\u5b63\u6625", "\u5b5f\u590f", "\u4ef2\u590f", "\u5b63\u590f", "\u5b5f\u79cb", "\u4ef2\u79cb", "\u5b63\u79cb", "\u5b5f\u51ac", "\u4ef2\u51ac", "\u5b63\u51ac"};
    public static final String[] SHENGXIAO = new String[]{"", "\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
    public static final String[] QI = new String[]{"\u5927\u5bd2", "\u96e8\u6c34", "\u6625\u5206", "\u8c37\u96e8", "\u590f\u6ee1", "\u590f\u81f3", "\u5927\u6691", "\u5904\u6691", "\u79cb\u5206", "\u971c\u964d", "\u5c0f\u96ea", "\u51ac\u81f3"};
    public static final String[] JIE = new String[]{"\u5c0f\u5bd2", "\u7acb\u6625", "\u60ca\u86f0", "\u6e05\u660e", "\u7acb\u590f", "\u8292\u79cd", "\u5c0f\u6691", "\u7acb\u79cb", "\u767d\u9732", "\u5bd2\u9732", "\u7acb\u51ac", "\u5927\u96ea"};
    public static final String[] DAY = new String[]{"", "\u521d\u4e00", "\u521d\u4e8c", "\u521d\u4e09", "\u521d\u56db", "\u521d\u4e94", "\u521d\u516d", "\u521d\u4e03", "\u521d\u516b", "\u521d\u4e5d", "\u521d\u5341", "\u5341\u4e00", "\u5341\u4e8c", "\u5341\u4e09", "\u5341\u56db", "\u5341\u4e94", "\u5341\u516d", "\u5341\u4e03", "\u5341\u516b", "\u5341\u4e5d", "\u4e8c\u5341", "\u5eff\u4e00", "\u5eff\u4e8c", "\u5eff\u4e09", "\u5eff\u56db", "\u5eff\u4e94", "\u5eff\u516d", "\u5eff\u4e03", "\u5eff\u516b", "\u5eff\u4e5d", "\u4e09\u5341"};
    public static final Map<String, String> FESTIVAL = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("1-1", "\u6625\u8282");
            this.put("1-15", "\u5143\u5bb5\u8282");
            this.put("2-2", "\u9f99\u5934\u8282");
            this.put("5-5", "\u7aef\u5348\u8282");
            this.put("7-7", "\u4e03\u5915\u8282");
            this.put("8-15", "\u4e2d\u79cb\u8282");
            this.put("9-9", "\u91cd\u9633\u8282");
            this.put("12-8", "\u814a\u516b\u8282");
        }
    };
    public static final String[][] XIU = new String[][]{{"\u5ba4", "\u594e", "\u80c3", "\u6bd5", "\u53c2", "\u9b3c", "\u5f20", "\u89d2", "\u6c10", "\u5fc3", "\u6597", "\u865a"}, {"\u58c1", "\u5a04", "\u6634", "\u89dc", "\u4e95", "\u67f3", "\u7ffc", "\u4ea2", "\u623f", "\u5c3e", "\u5973", "\u5371"}, {"\u594e", "\u80c3", "\u6bd5", "\u53c2", "\u9b3c", "\u661f", "\u8f78", "\u6c10", "\u5fc3", "\u7b95", "\u865a", "\u5ba4"}, {"\u5a04", "\u6634", "\u89dc", "\u4e95", "\u67f3", "\u5f20", "\u89d2", "\u623f", "\u5c3e", "\u6597", "\u5371", "\u58c1"}, {"\u80c3", "\u6bd5", "\u53c2", "\u9b3c", "\u661f", "\u7ffc", "\u4ea2", "\u5fc3", "\u7b95", "\u5973", "\u5ba4", "\u594e"}, {"\u6634", "\u89dc", "\u4e95", "\u67f3", "\u5f20", "\u8f78", "\u6c10", "\u5c3e", "\u6597", "\u865a", "\u58c1", "\u5a04"}, {"\u6bd5", "\u53c2", "\u9b3c", "\u661f", "\u7ffc", "\u89d2", "\u623f", "\u7b95", "\u5973", "\u5371", "\u594e", "\u80c3"}, {"\u89dc", "\u4e95", "\u67f3", "\u5f20", "\u8f78", "\u4ea2", "\u5fc3", "\u6597", "\u865a", "\u5ba4", "\u5a04", "\u6634"}, {"\u53c2", "\u9b3c", "\u661f", "\u7ffc", "\u89d2", "\u6c10", "\u5c3e", "\u5973", "\u5371", "\u58c1", "\u80c3", "\u6bd5"}, {"\u4e95", "\u67f3", "\u5f20", "\u8f78", "\u4ea2", "\u623f", "\u7b95", "\u865a", "\u5ba4", "\u594e", "\u6634", "\u89dc"}, {"\u9b3c", "\u661f", "\u7ffc", "\u89d2", "\u6c10", "\u5fc3", "\u6597", "\u5371", "\u58c1", "\u5a04", "\u6bd5", "\u53c2"}, {"\u67f3", "\u5f20", "\u8f78", "\u4ea2", "\u623f", "\u5c3e", "\u5973", "\u5ba4", "\u594e", "\u80c3", "\u89dc", "\u4e95"}, {"\u661f", "\u7ffc", "\u89d2", "\u6c10", "\u5fc3", "\u7b95", "\u865a", "\u58c1", "\u5a04", "\u6634", "\u53c2", "\u9b3c"}, {"\u5f20", "\u8f78", "\u4ea2", "\u623f", "\u5c3e", "\u6597", "\u5371", "\u594e", "\u80c3", "\u6bd5", "\u4e95", "\u67f3"}, {"\u7ffc", "\u89d2", "\u6c10", "\u5fc3", "\u7b95", "\u5973", "\u5ba4", "\u5a04", "\u6634", "\u89dc", "\u9b3c", "\u661f"}, {"\u8f78", "\u4ea2", "\u623f", "\u5c3e", "\u6597", "\u865a", "\u58c1", "\u80c3", "\u6bd5", "\u53c2", "\u67f3", "\u5f20"}, {"\u89d2", "\u6c10", "\u5fc3", "\u7b95", "\u5973", "\u5371", "\u594e", "\u6634", "\u89dc", "\u4e95", "\u661f", "\u7ffc"}, {"\u4ea2", "\u623f", "\u5c3e", "\u6597", "\u865a", "\u5ba4", "\u5a04", "\u6bd5", "\u53c2", "\u9b3c", "\u5f20", "\u8f78"}, {"\u6c10", "\u5fc3", "\u7b95", "\u5973", "\u5371", "\u58c1", "\u80c3", "\u89dc", "\u4e95", "\u67f3", "\u7ffc", "\u89d2"}, {"\u623f", "\u5c3e", "\u6597", "\u865a", "\u5ba4", "\u594e", "\u6634", "\u53c2", "\u9b3c", "\u661f", "\u8f78", "\u4ea2"}, {"\u5fc3", "\u7b95", "\u5973", "\u5371", "\u58c1", "\u5a04", "\u6bd5", "\u4e95", "\u67f3", "\u5f20", "\u89d2", "\u6c10"}, {"\u5c3e", "\u6597", "\u865a", "\u5ba4", "\u594e", "\u80c3", "\u89dc", "\u9b3c", "\u661f", "\u7ffc", "\u4ea2", "\u623f"}, {"\u7b95", "\u5973", "\u5371", "\u58c1", "\u5a04", "\u6634", "\u53c2", "\u67f3", "\u5f20", "\u8f78", "\u6c10", "\u5fc3"}, {"\u6597", "\u865a", "\u5ba4", "\u594e", "\u80c3", "\u6bd5", "\u4e95", "\u661f", "\u7ffc", "\u89d2", "\u623f", "\u5c3e"}, {"\u5973", "\u5371", "\u58c1", "\u5a04", "\u6634", "\u89dc", "\u9b3c", "\u5f20", "\u8f78", "\u4ea2", "\u5fc3", "\u7b95"}, {"\u865a", "\u5ba4", "\u594e", "\u80c3", "\u6bd5", "\u53c2", "\u67f3", "\u7ffc", "\u89d2", "\u6c10", "\u5c3e", "\u6597"}, {"\u5371", "\u58c1", "\u5a04", "\u6634", "\u89dc", "\u4e95", "\u661f", "\u8f78", "\u4ea2", "\u623f", "\u7b95", "\u5973"}, {"\u5ba4", "\u594e", "\u80c3", "\u6bd5", "\u53c2", "\u9b3c", "\u5f20", "\u89d2", "\u6c10", "\u5fc3", "\u6597", "\u865a"}, {"\u58c1", "\u5a04", "\u6634", "\u89dc", "\u4e95", "\u67f3", "\u7ffc", "\u4ea2", "\u623f", "\u5c3e", "\u5973", "\u5371"}, {"\u80c3", "\u9b3c", "\u6c10", "\u5fc3", "\u865a", "\u661f", "\u8f78", "\u6c10", "\u5fc3", "\u7b95", "\u865a", "\u5ba4"}};
    public static final Map<String, String> SHOU = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u4e1c", "\u9752\u9f99");
            this.put("\u5357", "\u6731\u96c0");
            this.put("\u897f", "\u767d\u864e");
            this.put("\u5317", "\u7384\u6b66");
        }
    };
    public static final Map<String, String> GONG = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u89d2", "\u4e1c");
            this.put("\u4e95", "\u5357");
            this.put("\u594e", "\u897f");
            this.put("\u6597", "\u5317");
            this.put("\u4ea2", "\u4e1c");
            this.put("\u9b3c", "\u5357");
            this.put("\u5a04", "\u897f");
            this.put("\u725b", "\u5317");
            this.put("\u6c10", "\u5357");
            this.put("\u67f3", "\u5357");
            this.put("\u80c3", "\u897f");
            this.put("\u5973", "\u5317");
            this.put("\u623f", "\u4e1c");
            this.put("\u661f", "\u5357");
            this.put("\u6634", "\u897f");
            this.put("\u865a", "\u5317");
            this.put("\u5fc3", "\u4e1c");
            this.put("\u5f20", "\u5357");
            this.put("\u6bd5", "\u897f");
            this.put("\u5371", "\u5317");
            this.put("\u5c3e", "\u4e1c");
            this.put("\u7ffc", "\u5357");
            this.put("\u89dc", "\u897f");
            this.put("\u5ba4", "\u5317");
            this.put("\u7b95", "\u4e1c");
            this.put("\u8f78", "\u5357");
            this.put("\u53c2", "\u897f");
            this.put("\u58c1", "\u5317");
        }
    };
    public static final Map<String, String> ZHENG = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u89d2", "\u6728");
            this.put("\u4e95", "\u6728");
            this.put("\u594e", "\u6728");
            this.put("\u6597", "\u6728");
            this.put("\u4ea2", "\u91d1");
            this.put("\u9b3c", "\u91d1");
            this.put("\u5a04", "\u91d1");
            this.put("\u725b", "\u91d1");
            this.put("\u6c10", "\u571f");
            this.put("\u67f3", "\u571f");
            this.put("\u80c3", "\u571f");
            this.put("\u5973", "\u571f");
            this.put("\u623f", "\u65e5");
            this.put("\u661f", "\u65e5");
            this.put("\u6634", "\u65e5");
            this.put("\u865a", "\u65e5");
            this.put("\u5fc3", "\u6708");
            this.put("\u5f20", "\u6708");
            this.put("\u6bd5", "\u6708");
            this.put("\u5371", "\u6708");
            this.put("\u5c3e", "\u706b");
            this.put("\u7ffc", "\u706b");
            this.put("\u89dc", "\u706b");
            this.put("\u5ba4", "\u706b");
            this.put("\u7b95", "\u6c34");
            this.put("\u8f78", "\u6c34");
            this.put("\u53c2", "\u6c34");
            this.put("\u58c1", "\u6c34");
        }
    };
    public static final Map<String, String> ANIMAL = new HashMap<String, String>(){
        private static final long serialVersionUID = -1L;
        {
            this.put("\u89d2", "\u86df");
            this.put("\u6597", "\u736c");
            this.put("\u594e", "\u72fc");
            this.put("\u4e95", "\u72b4");
            this.put("\u4ea2", "\u9f99");
            this.put("\u725b", "\u725b");
            this.put("\u5a04", "\u72d7");
            this.put("\u9b3c", "\u7f8a");
            this.put("\u5973", "\u8760");
            this.put("\u6c10", "\u8c89");
            this.put("\u80c3", "\u5f58");
            this.put("\u67f3", "\u7350");
            this.put("\u623f", "\u5154");
            this.put("\u865a", "\u9f20");
            this.put("\u6634", "\u9e21");
            this.put("\u661f", "\u9a6c");
            this.put("\u5fc3", "\u72d0");
            this.put("\u5371", "\u71d5");
            this.put("\u6bd5", "\u4e4c");
            this.put("\u5f20", "\u9e7f");
            this.put("\u5c3e", "\u864e");
            this.put("\u5ba4", "\u732a");
            this.put("\u89dc", "\u7334");
            this.put("\u7ffc", "\u86c7");
            this.put("\u7b95", "\u8c79");
            this.put("\u58c1", "\u735d");
            this.put("\u53c2", "\u733f");
            this.put("\u8f78", "\u8693");
        }
    };

    protected LunarUtil() {
    }

    public static int nextMonth(int y, int m) {
        int n = Math.abs(m) + 1;
        if (m > 0) {
            int index = y - 1900 + 0;
            int v = LUNAR_MONTH[2 * index + 1];
            if ((v = v >> 4 & 0xF) == m) {
                n = -m;
            }
        }
        if (n == 13) {
            n = 1;
        }
        return n;
    }

    public static int getDaysOfMonth(int year, int month) {
        int d;
        block4: {
            int index;
            block5: {
                block3: {
                    index = year - 1900 + 0;
                    d = 30;
                    if (1 > month || month > 8) break block3;
                    int v = LUNAR_MONTH[2 * index];
                    int l = month - 1;
                    if ((v >> l & 1) != 1) break block4;
                    d = 29;
                    break block4;
                }
                if (9 > month || month > 12) break block5;
                int v = LUNAR_MONTH[2 * index + 1];
                int l = month - 9;
                if ((v >> l & 1) != 1) break block4;
                d = 29;
                break block4;
            }
            int v = LUNAR_MONTH[2 * index + 1];
            if ((v = v >> 4 & 0xF) != Math.abs(month)) {
                d = 0;
            } else {
                d = 29;
                for (int i : LEAP_MONTH_YEAR) {
                    if (i != index) continue;
                    d = 30;
                    break;
                }
            }
        }
        return d;
    }
}

