/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.calendar;

import com.nlf.calendar.Solar;
import com.nlf.calendar.util.LunarUtil;
import com.nlf.calendar.util.SolarUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lunar {
    private int year;
    private int month;
    private int day;
    private Solar solar;

    public Lunar() {
        this(new Date());
    }

    public Lunar(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.solar = this.toSolar();
    }

    public Lunar(Date date) {
        int i;
        int lunarD;
        int lunarM;
        int lunarY;
        int startD;
        int startM;
        int startY;
        this.solar = new Solar(date);
        int y = this.solar.getYear();
        int m = this.solar.getMonth();
        int d = this.solar.getDay();
        if (y < 2000) {
            startY = 1901;
            startM = 1;
            startD = 1;
            lunarY = 1900;
            lunarM = 11;
            lunarD = 11;
        } else {
            startY = 2000;
            startM = 1;
            startD = 1;
            lunarY = 1999;
            lunarM = 11;
            lunarD = 25;
        }
        int diff = 0;
        for (i = startY; i < y; ++i) {
            diff += 365;
            if (!SolarUtil.isLeapYear(i)) continue;
            ++diff;
        }
        for (i = startM; i < m; ++i) {
            diff += SolarUtil.getDaysOfMonth(y, i);
        }
        lunarD += (diff += d - startD);
        int lastDate = LunarUtil.getDaysOfMonth(lunarY, lunarM);
        while (lunarD > lastDate) {
            lunarD -= lastDate;
            if ((lunarM = LunarUtil.nextMonth(lunarY, lunarM)) == 1) {
                ++lunarY;
            }
            lastDate = LunarUtil.getDaysOfMonth(lunarY, lunarM);
        }
        this.year = lunarY;
        this.month = lunarM;
        this.day = lunarD;
    }

    public String getGan() {
        return LunarUtil.GAN[(this.year - 4) % 10 + 1];
    }

    public String getZhi() {
        return LunarUtil.ZHI[(this.year - 4) % 12 + 1];
    }

    public String getShengxiao() {
        return LunarUtil.SHENGXIAO[(this.year - 4) % 12 + 1];
    }

    public String getMonthInChinese() {
        if (this.month > 0) {
            return LunarUtil.MONTH[this.month];
        }
        return "\u95f0" + LunarUtil.MONTH[-this.month];
    }

    public String getSeason() {
        return LunarUtil.SEASON[Math.abs(this.month)];
    }

    public String getDayInChinese() {
        return LunarUtil.DAY[this.day];
    }

    public String getJie() {
        String s = "";
        int solarYear = this.solar.getYear();
        int solarMonth = this.solar.getMonth();
        int solarDay = this.solar.getDay();
        int index = 0;
        int ry = solarYear - 1901 + 1;
        while (ry >= LunarUtil.JIE_YEAR[solarMonth - 1][index]) {
            ++index;
        }
        int term = LunarUtil.JIE_MAP[solarMonth - 1][4 * index + ry % 4];
        if (ry == 121 && solarMonth == 4) {
            term = 5;
        }
        if (ry == 132 && solarMonth == 4) {
            term = 5;
        }
        if (ry == 194 && solarMonth == 6) {
            term = 6;
        }
        if (solarDay == term) {
            s = LunarUtil.JIE[solarMonth - 1];
        }
        return s;
    }

    public String getQi() {
        String s = "";
        int solarYear = this.solar.getYear();
        int solarMonth = this.solar.getMonth();
        int solarDay = this.solar.getDay();
        int index = 0;
        int ry = solarYear - 1901 + 1;
        while (ry >= LunarUtil.QI_YEAR[solarMonth - 1][index]) {
            ++index;
        }
        int term = LunarUtil.QI_MAP[solarMonth - 1][4 * index + ry % 4];
        if (ry == 171 && solarMonth == 3) {
            term = 21;
        }
        if (ry == 181 && solarMonth == 5) {
            term = 21;
        }
        if (solarDay == term) {
            s = LunarUtil.QI[solarMonth - 1];
        }
        return s;
    }

    public String getXiu() {
        return LunarUtil.XIU[this.day - 1][this.month - 1];
    }

    public String getZheng() {
        return LunarUtil.ZHENG.get(this.getXiu());
    }

    public String getAnimal() {
        return LunarUtil.ANIMAL.get(this.getXiu());
    }

    public String getGong() {
        return LunarUtil.GONG.get(this.getXiu());
    }

    public String getShou() {
        return LunarUtil.SHOU.get(this.getGong());
    }

    public List<String> getFestivals() {
        ArrayList<String> l = new ArrayList<String>();
        String f = LunarUtil.FESTIVAL.get(this.month + "-" + this.day);
        if (null != f) {
            l.add(f);
        }
        return l;
    }

    private Solar toSolar() {
        int y = 1900;
        int m = 11;
        int d = 11;
        int diff = LunarUtil.getDaysOfMonth(y, m) - d;
        m = LunarUtil.nextMonth(y, m);
        do {
            diff += LunarUtil.getDaysOfMonth(y, m);
            if ((m = LunarUtil.nextMonth(y, m)) != 1) continue;
            ++y;
        } while (y != this.year || m != this.month);
        Calendar c = Calendar.getInstance();
        c.set(1901, 0, 1);
        c.add(5, diff += this.day);
        return new Solar(c);
    }

    public String toFullString() {
        StringBuilder s = new StringBuilder();
        s.append(this.toString());
        s.append(" ");
        s.append(this.getShengxiao());
        s.append("\u5e74");
        for (String f : this.getFestivals()) {
            s.append(" (");
            s.append(f);
            s.append(")");
        }
        String jq = this.getJie() + this.getQi();
        if (jq.length() > 0) {
            s.append(" [");
            s.append(jq);
            s.append("]");
        }
        s.append(" ");
        s.append(this.getGong());
        s.append("\u65b9");
        s.append(this.getShou());
        s.append(" ");
        s.append(this.getXiu());
        s.append(this.getZheng());
        s.append(this.getAnimal());
        return s.toString();
    }

    public String toString() {
        return this.getGan() + this.getZhi() + "\u5e74" + this.getMonthInChinese() + "\u6708" + this.getDayInChinese();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public Solar getSolar() {
        return this.solar;
    }
}

