/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.websocket.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import javax.websocket.Session;

public class WebSocketUtil {
    public static boolean sendMessage(Session session, String message) {
        try {
            session.getBasicRemote().sendText(message);
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean sendMessageAsync(Session session, String message) {
        Future voidFuture = session.getAsyncRemote().sendText(message);
        return voidFuture.isDone();
    }

    public static boolean sendBytes(Session session, byte[] bytes) {
        try {
            session.getBasicRemote().sendBinary(ByteBuffer.wrap(bytes));
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean sendBytesAsync(Session session, byte[] bytes) {
        Future voidFuture = session.getAsyncRemote().sendBinary(ByteBuffer.wrap(bytes));
        return voidFuture.isDone();
    }

    public static boolean sendObject(Session session, Object o) {
        try {
            session.getBasicRemote().sendObject(o);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean sendObjectAsync(Session session, Object o) {
        Future voidFuture = session.getAsyncRemote().sendObject(o);
        return voidFuture.isDone();
    }
}

