/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.websocket.redis;

import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPubSub;
import top.jfunc.json.impl.JSONObject;
import top.jfunc.websocket.WebSocketManager;
import top.jfunc.websocket.WebSocketManagerUtil;
import top.jfunc.websocket.redis.action.Action;
import top.jfunc.websocket.redis.action.ActionFactory;

public class Subscriber
extends JedisPubSub {
    private static final Logger LOGGER = LoggerFactory.getLogger(Subscriber.class);
    private CountDownLatch latch;

    public Subscriber() {
    }

    public Subscriber(CountDownLatch latch) {
        this.latch = latch;
    }

    public void onMessage(String channel, String message) {
        System.out.println(String.format("receive redis published message, channel %s, message %s", channel, message));
        LOGGER.info(message);
        JSONObject object = new JSONObject(message);
        if (!object.containsKey("action")) {
            return;
        }
        String actionName = object.getString("action");
        Action action = this.getAction(actionName);
        action.doMessage(this.getWebSocketManager(), object);
        if (null != this.latch) {
            this.latch.countDown();
        }
    }

    public void onSubscribe(String channel, int subscribedChannels) {
        LOGGER.info(String.format("subscribe redis channel success, channel %s, subscribedChannels %d", channel, subscribedChannels));
    }

    public void onUnsubscribe(String channel, int subscribedChannels) {
        LOGGER.info(String.format("unsubscribe redis channel, channel %s, subscribedChannels %d", channel, subscribedChannels));
    }

    protected Action getAction(String actionName) {
        return ActionFactory.getAction(actionName);
    }

    protected WebSocketManager getWebSocketManager() {
        return WebSocketManagerUtil.getWebSocketManager();
    }
}

