/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.websocket.redis;

import java.util.HashMap;
import redis.clients.jedis.Jedis;
import top.jfunc.websocket.WebSocket;
import top.jfunc.websocket.memory.MemWebSocketManager;
import top.jfunc.websocket.redis.action.BroadCastAction;
import top.jfunc.websocket.redis.action.RemoveAction;
import top.jfunc.websocket.redis.action.SendMessageAction;
import top.jfunc.websocket.utils.JsonUtil;
import top.jfunc.websocket.utils.WebSocketUtil;

public class RedisWebSocketManager
extends MemWebSocketManager {
    public static final String CHANNEL = "websocket";
    private static final String COUNT_KEY = "RedisWebSocketManagerCountKey";
    protected Jedis jedis;

    public RedisWebSocketManager(Jedis jedis) {
        this.jedis = jedis;
    }

    @Override
    public void put(String identifier, WebSocket webSocket) {
        super.put(identifier, webSocket);
        this.countChange(1);
    }

    @Override
    public void remove(String identifier) {
        boolean containsKey = this.localWebSocketMap().containsKey(identifier);
        if (containsKey) {
            super.remove(identifier);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("action", RemoveAction.NAME);
            map.put("identifier", identifier);
            this.jedis.publish(this.getChannel(), JsonUtil.serializeMap(map));
        }
        this.countChange(-1);
    }

    @Override
    public int size() {
        return this.getCount();
    }

    @Override
    public void sendMessage(String identifier, String message) {
        WebSocket webSocket = this.get(identifier);
        if (null != webSocket) {
            WebSocketUtil.sendMessage(webSocket.getSession(), message);
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("action", SendMessageAction.NAME);
        map.put("identifier", identifier);
        map.put("message", message);
        this.jedis.publish(this.getChannel(), JsonUtil.serializeMap(map));
    }

    @Override
    public void broadcast(String message) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("action", BroadCastAction.NAME);
        map.put("message", message);
        this.jedis.publish(this.getChannel(), JsonUtil.serializeMap(map));
    }

    protected String getChannel() {
        return CHANNEL;
    }

    private void countChange(int delta) {
        int count = this.getCount();
        count = (count += delta) > 0 ? count : 0;
        this.jedis.set(COUNT_KEY, "" + count);
    }

    private int getCount() {
        String countStr = this.jedis.get(COUNT_KEY);
        int count = 0;
        if (null != countStr) {
            count = Integer.parseInt(countStr);
        }
        return count;
    }
}

