/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.websocket.memory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import top.jfunc.websocket.WebSocket;
import top.jfunc.websocket.WebSocketManager;
import top.jfunc.websocket.utils.WebSocketUtil;

public class MemWebSocketManager
implements WebSocketManager {
    private final Map<String, WebSocket> connections = new ConcurrentHashMap<String, WebSocket>(100);

    @Override
    public WebSocket get(String identifier) {
        return this.connections.get(identifier);
    }

    @Override
    public void put(String identifier, WebSocket webSocket) {
        this.connections.put(identifier, webSocket);
    }

    @Override
    public void remove(String identifier) {
        this.connections.remove(identifier);
    }

    @Override
    public Map<String, WebSocket> localWebSocketMap() {
        return this.connections;
    }

    @Override
    public void sendMessage(String identifier, String message) {
        WebSocket webSocket = this.get(identifier);
        if (null == webSocket) {
            throw new RuntimeException("identifier \u4e0d\u5b58\u5728");
        }
        WebSocketUtil.sendMessage(webSocket.getSession(), message);
    }

    @Override
    public void broadcast(String message) {
        this.localWebSocketMap().values().forEach(webSocket -> WebSocketUtil.sendMessage(webSocket.getSession(), message));
    }

    @Override
    public void onMessage(String identifier, String message) {
    }
}

