/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.websocket.config;

import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;
import top.jfunc.websocket.TodoAtRemoved;
import top.jfunc.websocket.WebSocketManagerUtil;
import top.jfunc.websocket.config.WebSocketHeartBeatChecker;
import top.jfunc.websocket.memory.MemWebSocketManager;
import top.jfunc.websocket.redis.RedisWebSocketManager;
import top.jfunc.websocket.redis.Subscriber;

public class WebSocketManagerConfig {
    public static void configMemory() {
        WebSocketManagerUtil.setWebSocketManager(new MemWebSocketManager());
    }

    public static void configCluster(Jedis jedis) {
        jedis.subscribe((JedisPubSub)new Subscriber(), new String[]{"websocket"});
        WebSocketManagerUtil.setWebSocketManager(new RedisWebSocketManager(jedis));
    }

    public static void configHeartBeatCheck(int period, long timeSpan, int errorTolerant, TodoAtRemoved todoAtRemoved) {
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> WebSocketHeartBeatChecker.INSTANCE.check(WebSocketManagerUtil.getWebSocketManager(), timeSpan, errorTolerant, todoAtRemoved), 0L, period, TimeUnit.SECONDS);
    }
}

