/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.websocket.config;

import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.jfunc.websocket.TodoAtRemoved;
import top.jfunc.websocket.WebSocket;
import top.jfunc.websocket.WebSocketManager;

public class WebSocketHeartBeatChecker {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketHeartBeatChecker.class);
    public static final WebSocketHeartBeatChecker INSTANCE = new WebSocketHeartBeatChecker();

    public void check(WebSocketManager webSocketManager, long timeSpan, int errorTolerant, TodoAtRemoved todoAtRemoved) {
        long timeSpans = timeSpan * (long)errorTolerant;
        Map<String, WebSocket> socketMap = webSocketManager.localWebSocketMap();
        Date now = new Date();
        LinkedList<WebSocket> toRemoves = new LinkedList<WebSocket>();
        socketMap.forEach((identifier, webSocket) -> {
            long interval = now.getTime() - webSocket.getLastHeart().getTime();
            if (interval >= timeSpans) {
                logger.info("{} \u5931\u53bb\u5fc3\u8df3\u4e86", identifier);
                toRemoves.add((WebSocket)webSocket);
            }
        });
        if (toRemoves.size() > 0) {
            for (WebSocket webSocket2 : toRemoves) {
                socketMap.remove(webSocket2.getIdentifier());
            }
            todoAtRemoved.todoWith(toRemoves);
        }
    }
}

