/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.websocket;

import java.util.Date;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.jfunc.common.utils.StrUtil;
import top.jfunc.websocket.WebSocket;
import top.jfunc.websocket.WebSocketManager;
import top.jfunc.websocket.WebSocketManagerUtil;
import top.jfunc.websocket.utils.WebSocketUtil;

public abstract class BaseWebSocketEndpoint {
    public static final String IDENTIFIER = "identifier";
    protected static final Logger logger = LoggerFactory.getLogger(BaseWebSocketEndpoint.class);

    public void connect(String identifier, Session session) {
        try {
            if (StrUtil.isBlank((CharSequence)identifier)) {
                return;
            }
            WebSocketManager websocketManager = this.getWebSocketManager();
            WebSocket webSocket = new WebSocket();
            webSocket.setIdentifier(identifier);
            webSocket.setSession(session);
            webSocket.setLastHeart(new Date());
            websocketManager.put(identifier, webSocket);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void disconnect(String identifier) {
        this.getWebSocketManager().remove(identifier);
    }

    public void receiveMessage(String identifier, String message, Session session) {
        WebSocketManager webSocketManager = this.getWebSocketManager();
        if (webSocketManager.isPing(identifier, message)) {
            String pong = webSocketManager.pong(identifier, message);
            WebSocketUtil.sendMessage(session, pong);
            WebSocket webSocket = webSocketManager.get(identifier);
            if (null != webSocket) {
                webSocket.setLastHeart(new Date());
            }
            return;
        }
        webSocketManager.onMessage(identifier, message);
    }

    protected WebSocketManager getWebSocketManager() {
        return WebSocketManagerUtil.getWebSocketManager();
    }
}

