/*
 * Decompiled with CFR 0.152.
 */
package cn.z.ip2region.autoconfigure;

import cn.z.ip2region.Ip2Region;
import cn.z.ip2region.autoconfigure.Ip2RegionProperties;
import java.io.InputStream;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;

@Configuration
@EnableConfigurationProperties(value={Ip2RegionProperties.class})
public class Ip2RegionAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(Ip2RegionAutoConfiguration.class);
    private final Ip2RegionProperties ip2RegionProperties;

    public Ip2RegionAutoConfiguration(Ip2RegionProperties ip2RegionProperties) {
        this.ip2RegionProperties = ip2RegionProperties;
    }

    @PostConstruct
    public void init() {
        if (this.ip2RegionProperties.getResourcePath() != null) {
            log.info("\u8bfb\u53d6\u5230\u914d\u7f6e\uff0cRESOURCE_PATH\u4e3a\uff1a{}", (Object)this.ip2RegionProperties.getResourcePath());
            try {
                Ip2Region.init((InputStream)new ClassPathResource(this.ip2RegionProperties.getResourcePath()).getInputStream());
            }
            catch (Exception e) {
                log.error("\u8d44\u6e90\u6587\u4ef6\u5f02\u5e38\uff01", (Throwable)e);
            }
        } else if (this.ip2RegionProperties.getLocalPath() != null) {
            log.info("\u8bfb\u53d6\u5230\u914d\u7f6e\uff0cLOCAL_PATH\u4e3a\uff1a{}", (Object)this.ip2RegionProperties.getLocalPath());
            Ip2Region.initByFile((String)this.ip2RegionProperties.getLocalPath());
        } else if (this.ip2RegionProperties.getUrlPath() != null) {
            log.info("\u8bfb\u53d6\u5230\u914d\u7f6e\uff0cURL_PATH\u4e3a\uff1a{}", (Object)this.ip2RegionProperties.getUrlPath());
            Ip2Region.initByUrl((String)this.ip2RegionProperties.getUrlPath());
        }
    }
}

