/*
 * Decompiled with CFR 0.152.
 */
package cn.z.ip2region.autoconfigure;

import cn.z.ip2region.Ip2Region;
import cn.z.ip2region.autoconfigure.Ip2RegionProperties;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;

@Configuration
@EnableConfigurationProperties(value={Ip2RegionProperties.class})
public class Ip2RegionAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(Ip2RegionAutoConfiguration.class);
    private final Ip2RegionProperties ip2RegionProperties;

    public Ip2RegionAutoConfiguration(Ip2RegionProperties ip2RegionProperties) {
        this.ip2RegionProperties = ip2RegionProperties;
    }

    @PostConstruct
    public void init() {
        if (this.ip2RegionProperties.getResourcePath() != null) {
            log.info("\u8bfb\u53d6\u5230\u914d\u7f6e\u6587\u4ef6\uff0cRESOURCE_PATH\u4e3a" + this.ip2RegionProperties.getResourcePath());
            try {
                Ip2Region.init((byte[])Ip2Region.inputStream2bytes((InputStream)new ClassPathResource(this.ip2RegionProperties.getResourcePath()).getInputStream()));
            }
            catch (IOException e) {
                log.error("\u6570\u636e\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38", (Throwable)e);
            }
        } else if (this.ip2RegionProperties.getLocalPath() != null) {
            log.info("\u8bfb\u53d6\u5230\u914d\u7f6e\u6587\u4ef6\uff0cLOCAL_PATH\u4e3a" + this.ip2RegionProperties.getLocalPath());
            Ip2Region.initByFile((String)this.ip2RegionProperties.getLocalPath());
        } else if (this.ip2RegionProperties.getUrlPath() != null) {
            log.info("\u8bfb\u53d6\u5230\u914d\u7f6e\u6587\u4ef6\uff0cURL_PATH\u4e3a" + this.ip2RegionProperties.getUrlPath());
            Ip2Region.initByUrl((String)this.ip2RegionProperties.getUrlPath());
        }
    }
}

