/*
 * Decompiled with CFR 0.152.
 */
package cn.z.clock;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class Clock {
    private static final AtomicLong NOW = new AtomicLong(System.currentTimeMillis());
    private static final ZoneId ZONE_ID = ZoneId.systemDefault();

    private Clock() {
    }

    public static long now() {
        return NOW.get();
    }

    public static Date date() {
        return new Date(NOW.get());
    }

    public static Timestamp timestamp() {
        return new Timestamp(NOW.get());
    }

    public static Calendar calendar() {
        return new Calendar.Builder().setInstant(NOW.get()).build();
    }

    public static Instant instant() {
        return Instant.ofEpochMilli(NOW.get());
    }

    public static LocalDateTime localDateTime() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(NOW.get()), ZONE_ID);
    }

    public static OffsetDateTime offsetDateTime() {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(NOW.get()), ZONE_ID);
    }

    public static ZonedDateTime zonedDateTime() {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(NOW.get()), ZONE_ID);
    }

    static {
        Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable, "Clock");
            thread.setDaemon(true);
            return thread;
        }).scheduleAtFixedRate(() -> NOW.set(System.currentTimeMillis()), 0L, 1L, TimeUnit.MILLISECONDS);
    }
}

