package com.chen.tools.cache;

import java.util.Set;

/**
 * redis缓存服务
 * @author chao.zheng
 */
public interface RedisService {

    /**
     * 通过key删除
     *
     * @param keys  keys
     * @return long
     */
    long del(String... keys);

    /**
     * 通过前缀删除
     * @param prex 前缀
     * @return 影响的行数
     */
    Long delByPrex(final String prex);

    /**
     * 添加key value 并且设置存活时间(byte)
     *
     * @param key key
     * @param value value
     * @param liveTime liveTime
     */
    void set(byte[] key, byte[] value, long liveTime);

    /**
     * 添加key value 并且设置存活时间
     *
     * @param key key
     * @param value value
     * @param liveTime 单位秒
     */
    void set(String key, String value, long liveTime);

    /**
     * 添加key value
     *
     * @param key key
     * @param value value
     */
    void set(String key, String value);

    /**
     * 添加key value (字节)(序列化)
     *
     * @param key key
     * @param value value
     */
    void set(byte[] key, byte[] value);

    /**
     * 获取redis value (String)
     *
     * @param key key
     * @return value
     */
    String get(String key);

    /**
     * 通过正则匹配keys
     *
     * @param pattern 正则
     * @return set String
     *
     */
    Set<String> Setkeys(String pattern);

    /**
     * 检查key是否已经存在
     *
     * @param key key
     * @return 检查key是否已经存在
     */
    boolean exists(String key);

    /**
     * 清空redis 所有数据
     *
     * @return 清空redis 所有数据
     */
    String flushDB();

    /**
     * 查看redis里有多少数据
     * @return 查看redis里有多少数据
     */
    long dbSize();

    /**
     * 检查是否连接成功
     *
     * @return 检查是否连接成功
     */
    String ping();

    /**
     * 基于redis自增
     * @param key key
     * @return 基于redis自增
     */
    Integer incRedisKey(String key);

    /**
     * 往set中添加一个键值对
     *
     * @param key key
     * @param value value
     * @return 往set中添加一个键值对
     */
    Integer setSortSet(String key, String value);


}
