/*
 * Decompiled with CFR 0.152.
 */
package cn.lm.mybatis.spring.mapper;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public abstract class SpringBootBindUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBootBindUtil.class);

    public static <T> T bind(Environment environment, Class<T> targetClass, String prefix) {
        try {
            Class<?> binderClass = Class.forName("org.springframework.boot.context.properties.bind.Binder");
            Method getMethod = binderClass.getDeclaredMethod("get", Environment.class);
            Method bindMethod = binderClass.getDeclaredMethod("bind", String.class, Class.class);
            Object binder = getMethod.invoke(null, environment);
            Object bindResult = bindMethod.invoke(binder, prefix, targetClass);
            Method isBoundMethod = bindResult.getClass().getDeclaredMethod("isBound", new Class[0]);
            boolean isBound = (Boolean)isBoundMethod.invoke(bindResult, new Object[0]);
            if (isBound) {
                Method getMethodResult = bindResult.getClass().getDeclaredMethod("get", new Class[0]);
                return (T)getMethodResult.invoke(bindResult, new Object[0]);
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.warn("Bind " + targetClass + " error", (Throwable)e);
            return null;
        }
    }
}

