/*
 * Decompiled with CFR 0.152.
 */
package cn.lm.mybatis.spring.mapper;

import cn.lm.mybatis.mapper.MapperException;
import cn.lm.mybatis.mapper.entity.Config;
import cn.lm.mybatis.mapper.mapperhelper.MapperHelper;
import cn.lm.mybatis.spring.mapper.MapperFactoryBean;
import cn.lm.mybatis.spring.mapper.SpringBootBindUtil;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.scope.ScopedProxyFactoryBean;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.aot.AotDetector;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.NativeDetector;
import org.springframework.core.env.Environment;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.StringUtils;

public class ClassPathMapperScanner
extends ClassPathBeanDefinitionScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassPathMapperScanner.class);
    static final String FACTORY_BEAN_OBJECT_TYPE = "factoryBeanObjectType";
    private boolean addToConfig = true;
    private boolean lazyInitialization;
    private boolean printWarnLogIfNotFoundMappers = true;
    private SqlSessionFactory sqlSessionFactory;
    private SqlSessionTemplate sqlSessionTemplate;
    private String sqlSessionTemplateBeanName;
    private String sqlSessionFactoryBeanName;
    private Class<? extends Annotation> annotationClass;
    private Class<?> markerInterface;
    private MapperHelper mapperHelper;
    private String mapperHelperBeanName;
    private Class<? extends MapperFactoryBean> mapperFactoryBeanClass = MapperFactoryBean.class;
    private String defaultScope;
    private List<TypeFilter> excludeFilters;

    public ClassPathMapperScanner(BeanDefinitionRegistry registry, Environment environment) {
        super(registry, false, environment);
        this.setIncludeAnnotationConfig(!AotDetector.useGeneratedArtifacts());
        this.setPrintWarnLogIfNotFoundMappers(!NativeDetector.inNativeImage());
    }

    @Deprecated(since="3.0.4", forRemoval=true)
    public ClassPathMapperScanner(BeanDefinitionRegistry registry) {
        super(registry, false);
        this.setIncludeAnnotationConfig(!AotDetector.useGeneratedArtifacts());
        this.setPrintWarnLogIfNotFoundMappers(!NativeDetector.inNativeImage());
    }

    public void setAddToConfig(boolean addToConfig) {
        this.addToConfig = addToConfig;
    }

    public void setAnnotationClass(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public void setLazyInitialization(boolean lazyInitialization) {
        this.lazyInitialization = lazyInitialization;
    }

    public void setPrintWarnLogIfNotFoundMappers(boolean printWarnLogIfNotFoundMappers) {
        this.printWarnLogIfNotFoundMappers = printWarnLogIfNotFoundMappers;
    }

    public void setMarkerInterface(Class<?> markerInterface) {
        this.markerInterface = markerInterface;
    }

    public void setExcludeFilters(List<TypeFilter> excludeFilters) {
        this.excludeFilters = excludeFilters;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.sqlSessionTemplate = sqlSessionTemplate;
    }

    public void setSqlSessionTemplateBeanName(String sqlSessionTemplateBeanName) {
        this.sqlSessionTemplateBeanName = sqlSessionTemplateBeanName;
    }

    public void setSqlSessionFactoryBeanName(String sqlSessionFactoryBeanName) {
        this.sqlSessionFactoryBeanName = sqlSessionFactoryBeanName;
    }

    @Deprecated
    public void setMapperFactoryBean(MapperFactoryBean<?> mapperFactoryBean) {
        this.mapperFactoryBeanClass = mapperFactoryBean == null ? MapperFactoryBean.class : ((Object)mapperFactoryBean).getClass();
    }

    public void setMapperFactoryBeanClass(Class<? extends MapperFactoryBean> mapperFactoryBeanClass) {
        this.mapperFactoryBeanClass = mapperFactoryBeanClass == null ? MapperFactoryBean.class : mapperFactoryBeanClass;
    }

    public void setDefaultScope(String defaultScope) {
        this.defaultScope = defaultScope;
    }

    public void registerFilters() {
        boolean acceptAllInterfaces = true;
        if (this.annotationClass != null) {
            this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(this.annotationClass));
            acceptAllInterfaces = false;
        }
        if (this.markerInterface != null) {
            this.addIncludeFilter((TypeFilter)new AssignableTypeFilter(this.markerInterface){

                protected boolean matchClassName(String className) {
                    return false;
                }
            });
            acceptAllInterfaces = false;
        }
        if (acceptAllInterfaces) {
            this.addIncludeFilter((metadataReader, metadataReaderFactory) -> true);
        }
        this.addExcludeFilter((metadataReader, metadataReaderFactory) -> {
            String className = metadataReader.getClassMetadata().getClassName();
            if (className.endsWith("package-info")) {
                return true;
            }
            return metadataReader.getAnnotationMetadata().hasAnnotation("cn.lm.mybatis.mapper.annotation.RegisterMapper");
        });
        if (this.excludeFilters != null && this.excludeFilters.size() > 0) {
            for (TypeFilter excludeFilter : this.excludeFilters) {
                this.addExcludeFilter(excludeFilter);
            }
        }
    }

    public Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            if (this.printWarnLogIfNotFoundMappers) {
                LOGGER.warn("No MyBatis mapper was found in '" + Arrays.toString(basePackages) + "' package. Please check your configuration.");
            }
        } else {
            this.processBeanDefinitions(beanDefinitions);
        }
        return beanDefinitions;
    }

    private void processBeanDefinitions(Set<BeanDefinitionHolder> beanDefinitions) {
        BeanDefinitionRegistry registry = this.getRegistry();
        for (BeanDefinitionHolder holder : beanDefinitions) {
            AbstractBeanDefinition definition = (AbstractBeanDefinition)holder.getBeanDefinition();
            boolean scopedProxy = false;
            if (ScopedProxyFactoryBean.class.getName().equals(definition.getBeanClassName())) {
                definition = (AbstractBeanDefinition)Optional.ofNullable(((RootBeanDefinition)definition).getDecoratedDefinition()).map(BeanDefinitionHolder::getBeanDefinition).orElseThrow(() -> new IllegalStateException("The target bean definition of scoped proxy bean not found. Root bean definition[" + holder + "]"));
                scopedProxy = true;
            }
            String beanClassName = definition.getBeanClassName();
            LOGGER.debug("Creating MapperFactoryBean with name '" + holder.getBeanName() + "' and '" + beanClassName + "' mapperInterface");
            definition.getConstructorArgumentValues().addGenericArgumentValue((Object)beanClassName);
            try {
                Class beanClass = Resources.classForName((String)beanClassName);
                definition.setAttribute(FACTORY_BEAN_OBJECT_TYPE, (Object)beanClass);
                definition.getPropertyValues().add("mapperInterface", (Object)beanClass);
            }
            catch (ClassNotFoundException beanClass) {
                // empty catch block
            }
            definition.setBeanClass(this.mapperFactoryBeanClass);
            if (StringUtils.hasText((String)this.mapperHelperBeanName)) {
                definition.getPropertyValues().add("mapperHelper", (Object)new RuntimeBeanReference(this.mapperHelperBeanName));
            } else {
                if (this.mapperHelper == null) {
                    this.mapperHelper = new MapperHelper();
                }
                definition.getPropertyValues().add("mapperHelper", (Object)this.mapperHelper);
            }
            definition.getPropertyValues().add("addToConfig", (Object)this.addToConfig);
            boolean explicitFactoryUsed = false;
            if (StringUtils.hasText((String)this.sqlSessionFactoryBeanName)) {
                definition.getPropertyValues().add("sqlSessionFactory", (Object)new RuntimeBeanReference(this.sqlSessionFactoryBeanName));
                explicitFactoryUsed = true;
            } else if (this.sqlSessionFactory != null) {
                definition.getPropertyValues().add("sqlSessionFactory", (Object)this.sqlSessionFactory);
                explicitFactoryUsed = true;
            }
            if (StringUtils.hasText((String)this.sqlSessionTemplateBeanName)) {
                if (explicitFactoryUsed) {
                    LOGGER.warn("Cannot use both: sqlSessionTemplate and sqlSessionFactory together. sqlSessionFactory is ignored.");
                }
                definition.getPropertyValues().add("sqlSessionTemplate", (Object)new RuntimeBeanReference(this.sqlSessionTemplateBeanName));
                explicitFactoryUsed = true;
            } else if (this.sqlSessionTemplate != null) {
                if (explicitFactoryUsed) {
                    LOGGER.warn("Cannot use both: sqlSessionTemplate and sqlSessionFactory together. sqlSessionFactory is ignored.");
                }
                definition.getPropertyValues().add("sqlSessionTemplate", (Object)this.sqlSessionTemplate);
                explicitFactoryUsed = true;
            }
            if (!explicitFactoryUsed) {
                LOGGER.debug("Enabling autowire by type for MapperFactoryBean with name '" + holder.getBeanName() + "'.");
                definition.setAutowireMode(2);
            }
            definition.setLazyInit(this.lazyInitialization);
            if (scopedProxy) continue;
            if ("singleton".equals(definition.getScope()) && this.defaultScope != null) {
                definition.setScope(this.defaultScope);
            }
            if (definition.isSingleton()) continue;
            BeanDefinitionHolder proxyHolder = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry, (boolean)true);
            if (registry.containsBeanDefinition(proxyHolder.getBeanName())) {
                registry.removeBeanDefinition(proxyHolder.getBeanName());
            }
            registry.registerBeanDefinition(proxyHolder.getBeanName(), proxyHolder.getBeanDefinition());
        }
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }

    protected boolean checkCandidate(String beanName, BeanDefinition beanDefinition) {
        if (super.checkCandidate(beanName, beanDefinition)) {
            return true;
        }
        LOGGER.warn("Skipping MapperFactoryBean with name '" + beanName + "' and '" + beanDefinition.getBeanClassName() + "' mapperInterface. Bean already defined with the same name!");
        return false;
    }

    public MapperHelper getMapperHelper() {
        return this.mapperHelper;
    }

    public void setMapperHelper(MapperHelper mapperHelper) {
        this.mapperHelper = mapperHelper;
    }

    public void setConfig(Config config) {
        if (this.mapperHelper == null) {
            this.mapperHelper = new MapperHelper();
        }
        this.mapperHelper.setConfig(config);
    }

    public void setMapperHelperBeanName(String mapperHelperBeanName) {
        this.mapperHelperBeanName = mapperHelperBeanName;
    }

    public void setMapperProperties(Environment environment) {
        Config config = SpringBootBindUtil.bind(environment, Config.class, "mapper");
        if (this.mapperHelper == null) {
            this.mapperHelper = new MapperHelper();
        }
        if (config != null) {
            this.mapperHelper.setConfig(config);
        }
    }

    public void setMapperProperties(String[] properties) {
        if (this.mapperHelper == null) {
            this.mapperHelper = new MapperHelper();
        }
        Properties props = new Properties();
        for (String property : properties) {
            int index = (property = property.trim()).indexOf("=");
            if (index < 0) {
                throw new MapperException("\u901a\u8fc7 @MapperScan \u6ce8\u89e3\u7684 properties \u53c2\u6570\u914d\u7f6e\u51fa\u9519:" + property + " !\n\u8bf7\u4fdd\u8bc1\u914d\u7f6e\u9879\u6309 properties \u6587\u4ef6\u683c\u5f0f\u8981\u6c42\u8fdb\u884c\u914d\u7f6e\uff0c\u4f8b\u5982\uff1a\nproperties = {\n\t\"mappers=cn.lm.mybatis.mapper.common.AllMapper\",\n\t\"notEmpty=true\"\n}");
            }
            props.put(property.substring(0, index).trim(), property.substring(index + 1).trim());
        }
        this.mapperHelper.setProperties(props);
    }
}

