/*
 * Decompiled with CFR 0.152.
 */
package cn.lm.mybatis.mapper.additional.upsert;

import cn.lm.mybatis.mapper.entity.EntityColumn;
import cn.lm.mybatis.mapper.mapperhelper.EntityHelper;
import cn.lm.mybatis.mapper.mapperhelper.MapperHelper;
import cn.lm.mybatis.mapper.mapperhelper.MapperTemplate;
import cn.lm.mybatis.mapper.mapperhelper.SqlHelper;
import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;

public class UpsertProvider
extends MapperTemplate {
    public UpsertProvider(Class<?> mapperClass, MapperHelper mapperHelper) {
        super(mapperClass, mapperHelper);
    }

    public String upsert(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append(this.tableName(entityClass));
        Set columns = EntityHelper.getColumns((Class)entityClass);
        String primaryKeyColumn = null;
        EntityColumn logicDeleteColumn = SqlHelper.getLogicDeleteColumn((Class)entityClass);
        sql.append("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">");
        for (EntityColumn column : columns) {
            if (column.isId()) {
                primaryKeyColumn = column.getColumn();
            }
            if (!column.isInsertable()) continue;
            sql.append(column.getColumn() + ",");
        }
        sql.append("</trim>");
        sql.append(" VALUES ");
        sql.append("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">");
        for (EntityColumn column : columns) {
            if (column.getGenIdClass() == null) continue;
            sql.append("<bind name=\"").append(column.getColumn()).append("GenIdBind\" value=\"@cn.lm.mybatis.mapper.genid.GenIdUtil@genId(");
            sql.append("record").append(", '").append(column.getProperty()).append("'");
            sql.append(", @").append(column.getGenIdClass().getCanonicalName()).append("@class");
            sql.append(", '").append(this.tableName(entityClass)).append("'");
            sql.append(", '").append(column.getColumn()).append("')");
            sql.append("\"/>");
        }
        for (EntityColumn column : columns) {
            if (!column.isInsertable()) continue;
            if (logicDeleteColumn != null && logicDeleteColumn == column) {
                sql.append(SqlHelper.getLogicDeletedValue((EntityColumn)column, (boolean)false)).append(",");
                continue;
            }
            sql.append(column.getColumnHolder() + ",");
        }
        sql.append("</trim>");
        sql.append(" ON CONFLICT (" + primaryKeyColumn + ") DO UPDATE ");
        sql.append(SqlHelper.updateSetColumns((Class)entityClass, null, (boolean)true, (boolean)this.isNotEmpty()));
        return sql.toString();
    }
}

