/*
 * Decompiled with CFR 0.152.
 */
package cn.lm.mybatis.mapper.additional.update.force;

import cn.lm.mybatis.mapper.annotation.Version;
import cn.lm.mybatis.mapper.entity.EntityColumn;
import cn.lm.mybatis.mapper.mapperhelper.EntityHelper;
import cn.lm.mybatis.mapper.mapperhelper.MapperHelper;
import cn.lm.mybatis.mapper.mapperhelper.MapperTemplate;
import cn.lm.mybatis.mapper.mapperhelper.SqlHelper;
import cn.lm.mybatis.mapper.util.StringUtil;
import cn.lm.mybatis.mapper.version.VersionException;
import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;

public class UpdatePickByIdProvider
extends MapperTemplate {
    public static final String FORCE_UPDATE_PROPERTIES = "forceUpdateProperties";

    public UpdatePickByIdProvider(Class<?> mapperClass, MapperHelper mapperHelper) {
        super(mapperClass, mapperHelper);
    }

    public String updatePickById(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlHelper.updateTable((Class)entityClass, (String)this.tableName(entityClass), (String)"record"));
        sql.append(this.updateSetColumnsForce(entityClass, "record", true, this.isNotEmpty()));
        sql.append(SqlHelper.wherePKColumns((Class)entityClass, (String)"record", (boolean)true));
        return sql.toString();
    }

    public String updateSetColumnsForce(Class<?> entityClass, String entityName, boolean notNull, boolean notEmpty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<set>");
        Set columnSet = EntityHelper.getColumns(entityClass);
        EntityColumn versionColumn = null;
        for (EntityColumn column : columnSet) {
            if (column.getEntityField().isAnnotationPresent(Version.class)) {
                if (versionColumn != null) {
                    throw new VersionException(entityClass.getName() + " \u4e2d\u5305\u542b\u591a\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5\uff0c\u4e00\u4e2a\u7c7b\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5!");
                }
                versionColumn = column;
            }
            if (!column.isId() && column.isUpdatable()) {
                if (column == versionColumn) {
                    Version version = (Version)versionColumn.getEntityField().getAnnotation(Version.class);
                    String versionClass = version.nextVersion().getName();
                    sql.append(column.getColumn()).append(" = ${@cn.lm.mybatis.mapper.version.VersionUtil@nextVersion(").append("@").append(versionClass).append("@class, ");
                    if (StringUtil.isNotEmpty((CharSequence)entityName)) {
                        sql.append(entityName).append('.');
                    }
                    sql.append(column.getProperty()).append(")},");
                    continue;
                }
                if (notNull) {
                    sql.append(this.getIfNotNull(entityName, column, column.getColumnEqualsHolder(entityName) + ",", notEmpty));
                    continue;
                }
                sql.append(column.getColumnEqualsHolder(entityName)).append(",");
                continue;
            }
            if (!column.isId() || !column.isUpdatable()) continue;
            sql.append(column.getColumn()).append(" = ").append(column.getColumn()).append(",");
        }
        sql.append("</set>");
        return sql.toString();
    }

    public String getIfNotNull(String entityName, EntityColumn column, String contents, boolean empty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<choose>");
        sql.append("<when test=\"");
        sql.append(FORCE_UPDATE_PROPERTIES).append(" != null and ").append(FORCE_UPDATE_PROPERTIES).append(".contains('");
        sql.append(column.getProperty());
        sql.append("')\">");
        sql.append(contents);
        sql.append("</when>");
        sql.append("<otherwise></otherwise>");
        sql.append("</choose>");
        return sql.toString();
    }
}

