/*
 * Decompiled with CFR 0.152.
 */
package cn.lm.mybatis.mapper.additional.idlist;

import cn.lm.mybatis.mapper.MapperException;
import cn.lm.mybatis.mapper.entity.EntityColumn;
import cn.lm.mybatis.mapper.mapperhelper.EntityHelper;
import cn.lm.mybatis.mapper.mapperhelper.MapperHelper;
import cn.lm.mybatis.mapper.mapperhelper.MapperTemplate;
import cn.lm.mybatis.mapper.mapperhelper.SqlHelper;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;

public class IdListProvider
extends MapperTemplate {
    public IdListProvider(Class<?> mapperClass, MapperHelper mapperHelper) {
        super(mapperClass, mapperHelper);
    }

    public static void notEmpty(List<?> list, String errorMsg) {
        if (list == null || list.size() == 0) {
            throw new MapperException(errorMsg);
        }
    }

    public String deleteByIdList(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlHelper.deleteFromTable((Class)entityClass, (String)this.tableName(entityClass)));
        this.appendWhereIdList(sql, entityClass, this.getConfig().isSafeDelete());
        return sql.toString();
    }

    public String selectByIdList(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlHelper.selectAllColumns((Class)entityClass));
        sql.append(SqlHelper.fromTable((Class)entityClass, (String)this.tableName(entityClass)));
        this.appendWhereIdList(sql, entityClass, this.isNotEmpty());
        return sql.toString();
    }

    private void appendWhereIdList(StringBuilder sql, Class<?> entityClass, boolean notEmpty) {
        EntityColumn column;
        Set columnList = EntityHelper.getPKColumns(entityClass);
        if (columnList.size() == 1) {
            column = (EntityColumn)columnList.iterator().next();
            if (notEmpty) {
                sql.append("<bind name=\"notEmptyListCheck\" value=\"@cn.lm.mybatis.mapper.additional.idlist.IdListProvider@notEmpty(");
                sql.append("idList, 'idList \u4e0d\u80fd\u4e3a\u7a7a')\"/>");
            }
        } else {
            throw new MapperException("\u7ee7\u627f ByIdList \u65b9\u6cd5\u7684\u5b9e\u4f53\u7c7b[" + entityClass.getName() + "]\u4e2d\u5fc5\u987b\u53ea\u6709\u4e00\u4e2a\u5e26\u6709 @Id \u6ce8\u89e3\u7684\u5b57\u6bb5");
        }
        sql.append("<where>");
        sql.append("<foreach collection=\"idList\" item=\"id\" separator=\",\" open=\"");
        sql.append(column.getColumn());
        sql.append(" in ");
        sql.append("(\" close=\")\">");
        sql.append("#{id}");
        sql.append("</foreach>");
        sql.append("</where>");
    }
}

