/*
 * Decompiled with CFR 0.152.
 */
package cn.lm.mybatis.mapper.util;

import cn.lm.mybatis.mapper.MapperException;
import cn.lm.mybatis.mapper.annotation.LogicDelete;
import cn.lm.mybatis.mapper.entity.Condition;
import cn.lm.mybatis.mapper.entity.EntityColumn;
import cn.lm.mybatis.mapper.entity.IDynamicTableName;
import cn.lm.mybatis.mapper.mapperhelper.EntityHelper;
import cn.lm.mybatis.mapper.mapperhelper.SqlHelper;
import cn.lm.mybatis.mapper.util.StringUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class OGNL {
    public static final String SAFE_DELETE_ERROR = "\u901a\u7528 Mapper \u5b89\u5168\u68c0\u67e5: \u5bf9\u67e5\u8be2\u6761\u4ef6\u53c2\u6570\u8fdb\u884c\u68c0\u67e5\u65f6\u51fa\u9519!";
    public static final String SAFE_DELETE_EXCEPTION = "\u901a\u7528 Mapper \u5b89\u5168\u68c0\u67e5: \u5f53\u524d\u64cd\u4f5c\u7684\u65b9\u6cd5\u6ca1\u6709\u6307\u5b9a\u67e5\u8be2\u6761\u4ef6\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u8be5\u64cd\u4f5c!";

    public static boolean checkExampleEntityClass(Object parameter, String entityFullName) {
        Condition example;
        Class<?> entityClass;
        if (parameter != null && parameter instanceof Condition && StringUtil.isNotEmpty(entityFullName) && !(entityClass = (example = (Condition)parameter).getEntityClass()).getName().equals(entityFullName)) {
            throw new MapperException("\u5f53\u524d Example \u65b9\u6cd5\u5bf9\u5e94\u5b9e\u4f53\u4e3a:" + entityFullName + ", \u4f46\u662f\u53c2\u6570 Example \u4e2d\u7684 entityClass \u4e3a:" + entityClass.getName());
        }
        return true;
    }

    public static boolean notAllNullParameterCheck(Object parameter, String fields) {
        if (parameter != null) {
            try {
                Set<EntityColumn> columns = EntityHelper.getColumns(parameter.getClass());
                HashSet<String> fieldSet = new HashSet<String>(Arrays.asList(fields.split(",")));
                for (EntityColumn column : columns) {
                    Object value;
                    if (!fieldSet.contains(column.getProperty()) || (value = column.getEntityField().getValue(parameter)) == null) continue;
                    return true;
                }
            }
            catch (Exception e) {
                throw new MapperException(SAFE_DELETE_ERROR, e);
            }
        }
        throw new MapperException(SAFE_DELETE_EXCEPTION);
    }

    public static boolean notEmptyCollectionCheck(Object parameter, String error) {
        if (parameter == null || parameter instanceof Collection && ((Collection)parameter).size() == 0) {
            throw new IllegalArgumentException(error);
        }
        return true;
    }

    public static boolean exampleHasAtLeastOneCriteriaCheck(Object parameter) {
        if (parameter != null) {
            try {
                Method getter;
                Object list;
                List criteriaList;
                if (parameter instanceof Condition ? (criteriaList = ((Condition)parameter).getOredCriteria()) != null && criteriaList.size() > 0 : (list = (getter = parameter.getClass().getDeclaredMethod("getOredCriteria", new Class[0])).invoke(parameter, new Object[0])) != null && list instanceof List && ((List)list).size() > 0) {
                    return true;
                }
            }
            catch (Exception e) {
                throw new MapperException(SAFE_DELETE_ERROR, e);
            }
        }
        throw new MapperException(SAFE_DELETE_EXCEPTION);
    }

    public static boolean hasSelectColumns(Object parameter) {
        Condition example;
        return parameter != null && parameter instanceof Condition && (example = (Condition)parameter).getSelectColumns() != null && example.getSelectColumns().size() > 0;
    }

    public static boolean hasCountColumn(Object parameter) {
        if (parameter != null && parameter instanceof Condition) {
            Condition example = (Condition)parameter;
            return StringUtil.isNotEmpty(example.getCountColumn());
        }
        return false;
    }

    public static boolean hasForUpdate(Object parameter) {
        if (parameter != null && parameter instanceof Condition) {
            Condition example = (Condition)parameter;
            return example.isForUpdate();
        }
        return false;
    }

    public static boolean hasNoSelectColumns(Object parameter) {
        return !OGNL.hasSelectColumns(parameter);
    }

    public static boolean isDynamicParameter(Object parameter) {
        return parameter != null && parameter instanceof IDynamicTableName;
    }

    public static boolean isNotDynamicParameter(Object parameter) {
        return !OGNL.isDynamicParameter(parameter);
    }

    public static String andOr(Object parameter) {
        if (parameter instanceof Condition.Criteria) {
            return ((Condition.Criteria)parameter).getAndOr();
        }
        if (parameter instanceof Condition.Criterion) {
            return ((Condition.Criterion)parameter).getAndOr();
        }
        if (parameter.getClass().getName().endsWith("Criteria")) {
            return "or";
        }
        return "and";
    }

    public static String andNotLogicDelete(Object parameter) {
        Object result = "";
        if (parameter instanceof Condition) {
            Condition example = (Condition)parameter;
            Map<String, EntityColumn> propertyMap = example.getPropertyMap();
            for (Map.Entry<String, EntityColumn> entry : propertyMap.entrySet()) {
                EntityColumn column = entry.getValue();
                if (!column.getEntityField().isAnnotationPresent(LogicDelete.class)) continue;
                Integer logicDeletedValue = SqlHelper.getLogicDeletedValue(column, false);
                result = logicDeletedValue == null ? column.getColumn() + " is null " : column.getColumn() + " = " + logicDeletedValue;
                if (!OGNL.hasWhereCause(example)) continue;
                result = (String)result + " and ";
            }
        }
        return result;
    }

    private static <T> boolean hasWhereCause(Condition<T> example) {
        if (example.getOredCriteria() == null || example.getOredCriteria().size() == 0) {
            return false;
        }
        for (Condition.Criteria<T> oredCriterion : example.getOredCriteria()) {
            if (oredCriterion.getAllCriteria().size() == 0) continue;
            return true;
        }
        return false;
    }
}

