/*
 * Decompiled with CFR 0.152.
 */
package cn.lm.mybatis.mapper.util;

import cn.lm.mybatis.mapper.MapperException;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.decorators.SoftCache;
import org.apache.ibatis.cache.impl.PerpetualCache;
import org.apache.ibatis.mapping.MappedStatement;

public class MsUtil {
    public static final Cache CLASS_CACHE = new SoftCache((Cache)new PerpetualCache("MAPPER_CLASS_CACHE"));

    public static Class<?> getMapperClass(String msId) {
        ClassLoader[] classLoader;
        if (msId.indexOf(".") == -1) {
            throw new MapperException("\u5f53\u524dMappedStatement\u7684id=" + msId + ",\u4e0d\u7b26\u5408MappedStatement\u7684\u89c4\u5219!");
        }
        String mapperClassStr = msId.substring(0, msId.lastIndexOf("."));
        Class<?> mapperClass = (Class<?>)CLASS_CACHE.getObject((Object)mapperClassStr);
        if (mapperClass != null) {
            return mapperClass;
        }
        for (ClassLoader cl : classLoader = MsUtil.getClassLoaders()) {
            if (null == cl) continue;
            try {
                mapperClass = Class.forName(mapperClassStr, true, cl);
                if (mapperClass == null) continue;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (mapperClass == null) {
            throw new MapperException("class loaders failed to locate the class " + mapperClassStr);
        }
        CLASS_CACHE.putObject((Object)mapperClassStr, (Object)mapperClass);
        return mapperClass;
    }

    private static ClassLoader[] getClassLoaders() {
        return new ClassLoader[]{Thread.currentThread().getContextClassLoader(), MsUtil.class.getClassLoader()};
    }

    public static String getMethodName(MappedStatement ms) {
        return MsUtil.getMethodName(ms.getId());
    }

    public static String getMethodName(String msId) {
        return msId.substring(msId.lastIndexOf(".") + 1);
    }
}

